//%attributes = {}
//******************************************************************************
//
//Method: SDA_strt_Prefs
//
//Written by  Tod Gentille on 12/4/97
//
//Purpose: A convenient place to put the  users preferences for using SDA
//Called from SDA_Startup
//
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************

//----------------------------- User Preferences --------------------------------
C_BOOLEAN:C305(<>bSDA_HorizontalToolbar)
<>bSDA_HorizontalToolbar:=False:C215  //False uses the Vertical orientation by default
C_BOOLEAN:C305(<>bSDA_TableFieldExtraInfo)
<>bSDA_TableFieldExtraInfo:=False:C215  //display extra info like table#, field#, type, indexed in popup
C_BOOLEAN:C305(<>bSDA_EnableShortcuts)
<>bSDA_EnableShortcuts:=False:C215
//SDA be default preserves the contents of the clipboard when using
//it for its purposes. However, sometimes the design environment
//does not process the paste key fast enough and the clipboard is restored
//to its original contents too soon. The safest thing to do is increase
//the value of POST_KEY_DELAY below but if you feel that makes
//performance too sluggish you can also elect to not preserve
//the contents of the clipboard. That way for certain
//operations your paste will always work. For commands where the
//clipboard is used more than once by SDA this may not do you any good
C_BOOLEAN:C305(<>bPreserveClipboard)
<>bPreserveClipboard:=True:C214  //this matches the initial setting of the toggle in the misc tools DL

//Declare the var used by the SDA_ResizePalette routine
C_TEXT:C284(<>SDA_PaletteSize)
<>SDA_PaletteSize:=<>SDA_MAXIMIZED_PALETTE  //other choice is <>SDA_MINIMIZED_PALETTE

//certain operations wait for windows to come to the front or
//leave from the front. Typically these should not fail but instead
//of coding a forever wait loop the loops wait for the windows
//to come or go or for this maximum number of loops
//the loops have a delay process of 1 tick built in
//so this can be a signficant wait if the loop value is large.
//This wait loop has nothing to do with the other delay loops that wait for
//things to be processed by the design environment. see SDA_util_CloseWindowWait
//for an example
C_LONGINT:C283(<>SDA_MAX_WAIT_LOOP)
<>SDA_MAX_WAIT_LOOP:=35


C_LONGINT:C283(<>SDA_POST_KEY_DELAY)
<>SDA_POST_KEY_DELAY:=3  //modify this number to a larger value if post keys don't seem to work
//When posting keys between processes the scheduler needs a chance to let the post
//key event happen. This count is the number of times the post key routines will
//loop on a one tick delay statement. Some machines may be able to use a lower
//number and others may need a higher number. The responsiveness of the palette
//is greately affected by this value.
//Also using the runtime palette causes all non-tokenized methods to be tokenized
//if you find that you have to issue commands twice to have them work it is probab
//because you have a lot of untokenized methods or the current method is large
//try tokenizing the methods (CMD-ENTER) as you finish working with them

C_LONGINT:C283(<>SDA_TYPE_AHEAD_MAX_LEN; <>SDA_NUM_POST_DOWNS)
<>SDA_NUM_POST_DOWNS:=5
<>SDA_TYPE_AHEAD_MAX_LEN:=10
//The SDA_PostString command is used to try and open existing methods. Only
//so many characters seem to get processed in the explorer type ahead. Even
//though the subsequent characters don't start a new type ahead they don't do
//anything. Therefore after trying type ahead for <>SDA_TYPE_AHEAD_MAX_LEN
//characters PostString will stop posting keys.
//SDA_util_OpenMethodByPostDown will  start issuing down arrows and see if the cor
//method opens. This only affects methods that have a large number of characters
//that are the same at the beginning of the name.

C_LONGINT:C283(<>SDA_BUSY_TICK_LIMIT; <>SDA_EXTRA_TICK_WAIT)
//in an attempt to fine tune the wait this var is used to determine if
//the system is pretty busy. Ideally a one tick delay would be 16.67 milliseconds
//if a delay in SDA_PostKey takes longer than this variables value the system wait
//the extra number of ticks specifiec.
<>SDA_BUSY_TICK_LIMIT:=35  //If a one tick delay process takes over 50 milliseconds
<>SDA_EXTRA_TICK_WAIT:=8  //wait this many extra ticks for every loop that it happens
//Since the popup that displays table and field info can only show 31 chars
//when we add extra information it is in abbreviated form
//if you have short table and field names you may want to see a
//longer version of the info. The tools popup will toggle this value
C_BOOLEAN:C305(<>bSDA_VerboseFieldInfo; <>bSDA_ForceRplcComment)
<>bSDA_VerboseFieldInfo:=False:C215
<>bSDA_ForceRplcComment:=False:C215
