//%attributes = {}
//******************************************************************************
//Method: SDA_util_IsExplorerWinOpen(->WinListArray)->Status
//
//Written by  cyril Harnisch on 3/9/99
//
//Purpose: return true if the Explorer window is open
//
//$1 - pointer - window list array, optional, if not present, create
// window list locally
//$0 - boolean - true if the explorer window is open
//
//Copyright 1997 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $pWindowListArray)
C_BOOLEAN:C305($0)
C_BOOLEAN:C305($bDone)
C_LONGINT:C283($lWindowTitleIdx; $lWindowTitleArySize)
C_TEXT:C284($tWinTitle)

If (Count parameters:C259>0)  //if at least 1 parameter
	$pWindowListArray:=$1
	
Else   //no parameters
	ARRAY LONGINT:C221(<>alWinRef_L; 0)
	WINDOW LIST:C442(<>alWinRef_L)  //get list of windows that are currently open.
	$pWindowListArray:=-><>alWinRef_L
End if 

$lWindowTitleIdx:=1
$lWindowTitleArySize:=Size of array:C274($pWindowListArray->)

Repeat   //for each window title
	
	If ($lWindowTitleIdx<=$lWindowTitleArySize)  //if there are titles still to check  
		
		If (Get window title:C450($pWindowListArray->{$lWindowTitleIdx})#<>SDA_EXPLORER)  //if not the explorer window
			$lWindowTitleIdx:=$lWindowTitleIdx+1
			$bDone:=False:C215
			
		Else   //the explorer window
			$bDone:=True:C214  //terminate loop
			$0:=True:C214  //indicate we found the Explorer window
		End if 
		
	Else   //no more titles to check
		$bDone:=True:C214  //terminate loop
		$0:=False:C215  //indicate we did not find the Explorer window
	End if 
	
Until ($bDone)
