//%attributes = {}
//******************************************************************************
//Method: SDA_util_IsMethod(lWindowRef)
//Written by  Tod Gentille on 4/22/98
//
//Purpose: Return true if the passed window ref is a method window
//looks for the name "method" or whatever is stored in str resource 77;6
//in the method name, that the window is a regular window and that it is 
//owned by the design process
//$1 - longint - window reference of window to test
//$0 - boolean -
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_LONGINT:C283($1; $lWindowRef)
C_BOOLEAN:C305($0)
C_TEXT:C284($tMethodName)

$lWindowRef:=$1

$tMethodName:=Get window title:C450($lWindowRef)
$0:=False:C215  //if all the cases pass then true will be returned

Case of 
		
	: (Not:C34(Window kind:C445($lWindowRef)=Regular window:K27:1))
		
	: (Not:C34(Window process:C446($lWindowRef)=<>lSDA_DesignPID))  //limit to windows in the design environment
		
	: (Not:C34(Position:C15(<>SDA_METHOD; $tMethodName)#0))  //the name of the window must contain "method"
		
	Else 
		$0:=True:C214
End case 
