//%attributes = {}
//******************************************************************************
//Method: SDA_util_IsValidWindowType(bCheckForMethodWindow;lWindowRef)
//Written by  Tod Gentille on 9/29/1998
//
//Purpose: Checks to see if a user is a regular window owned by the design process
//or a method editor window - operation determined by parameter
//
//$1 - boolean- if true window must be method editor window
//$2 - longint window reference to check
//$0 - return true if valid window type
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_BOOLEAN:C305($0; $1; $bLimitToMethodWindows)
C_LONGINT:C283($2; $lWindowRef)
$bLimitToMethodWindows:=$1
$lWindowRef:=$2
$0:=False:C215

If ($bLimitToMethodWindows)
	
	If (SDA_util_IsMethod($lWindowRef))
		$0:=True:C214
	Else   //already defaulted to false
	End if 
	
Else 
	
	Case of 
		: (Not:C34(Window kind:C445($lWindowRef)=Regular window:K27:1))
		: (Not:C34(Window process:C446($lWindowRef)=<>lSDA_DesignPID))  //limit to windows in the design environment
		Else 
			$0:=True:C214
	End case 
	
End if 
