//%attributes = {}
//******************************************************************************
//Method: SDA_util_OpenNextExplorerMethod
//Written by  Tod Gentille on 9/28/1998
//
//Purpose: Make sure the explorer window is frontmost and then open the next metho
//after the highlighted method in the list. Used when trying to operate on all met
//in a project or all that start with a certain sequence
//
//Copyright 1998 Syncor Systems, Inc.
//******************************************************************************
C_BOOLEAN:C305($0)

If (SDA_util_BringExplorerToFront)  //if Explorer window was brought to the front
	
	If (<>SDA_IN_WINDOWS)  //if this is running on Windows
		//requires special care under windows
		//methods are opened by posting the enter key this causes the
		//method list to lose focus (because the Edit key gets it from the enter key
		//so we have to tab three times to put the focus back on the method list area
		//ain't windows great? 
		SDA_util_PostKey(Tab key:K12:28; 0; False:C215)
		SDA_util_PostKey(Tab key:K12:28; 0; False:C215)
		
	Else   //running on Mac
	End if 
	
	SDA_util_PostKey(Down arrow key:K12:19; 0; False:C215)  //move to next item in the list; note that
	// if we are at the bottom of the list, the last method is reselected.
	$0:=SDA_util_OpenExplorerMethod  //try to open method and return true if successful
	
Else   //explorer did not come to front for some reason
	$0:=False:C215  //indicate unsuccessful opening method
End if 
