//%attributes = {}
//******************************************************************************
//Method: SDA_util_Parse(textToParse;pArraytoParseInto)
//Written by  Tod Gentille on 10/13/97
//
//Purpose: Parse the passed text into an array, one line per element
//
//$1 - text  - the text to parse
//$2 - pointer to array to parse text into
//
//Copyright 1997 Syncor Systems, Inc.
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/4/99
//Reason: enhanced readability; corrected code to avoid deleting last line
// because $iArraySize was not being incremented.
//******************************************************************************
C_TEXT:C284($1; $tStringToParse)
C_POINTER:C301($2; $ptArrayToFill)
_O_C_STRING:C293(1; $s1LineDelim)
C_LONGINT:C283($iPos; $iArraySize)

$tStringToParse:=$1
$ptArraytoFill:=$2  //for readability

$s1LineDelim:=Char:C90(Carriage return:K15:38)

Repeat 
	$iArraySize:=Size of array:C274($ptArrayToFill->)+1
	$iPos:=Position:C15($s1LineDelim; $tStringToParse)
	
	If ($iPos#0)
		INSERT IN ARRAY:C227($ptArraytoFill->; $iArraySize)  //insert at end of array
		$ptArrayToFill->{$iArraySize}:=Substring:C12($tStringToParse; 1; $iPos)
		$tStringToParse:=Substring:C12($tStringToParse; $iPos+1)  //reduce the string to what remains
	End if 
	
Until ($iPos=0)

//Get the last partial line
If (Length:C16($tStringToParse)>0)
	$iArraySize:=Size of array:C274($ptArrayToFill->)+1
	INSERT IN ARRAY:C227($ptArraytoFill->; $iArraySize)  //insert at end of array
	$ptArrayToFill->{$iArraySize}:=$tStringToParse
End if 
