//%attributes = {}
//*==============================================================================
//Project method : svn_methodDetokenize
// Public
//
//DESCRIPTION :
// This method is used to parse a CC4D resource (tokenized 4D code) and convert
//  it into a text array (one line of array per line of code)
//
//PARAMETERS :
//  $1 (BLOB) => CC4D resource content (tokenized 4D code)
//  $2 (POINTER) => array text pointer : array of detokenized method lines (modified)
//  
//NOTES : 
//
//EXAMPLE : 
//  svn_methodDetokenize
//  
//CREATION : Bruno LEGAY - 29/08/06, 20:22:09 - v1.00.00
//*===============================================================================

C_BLOB:C604($1)  //CC4D resource content
C_POINTER:C301($2)  //detokenized method lines array

C_BLOB:C604($vx_methodBlob)  //CC4D resource content
C_POINTER:C301($vp_methodLinesArrayPtr)  //detokenized method lines array

C_BLOB:C604($vx_LineTokens)
C_TEXT:C284($vt_lineText)

$vt_MethodText:=""

C_LONGINT:C283($vl_NbParam)
$vl_NbParam:=Count parameters:C259
If ($vl_NbParam>1)
	$vx_methodBlob:=$1
	$vp_methodLinesArrayPtr:=$2
	
	//Checking that the pointed variable is a Text array
	If (Type:C295($vp_methodLinesArrayPtr->)=Text array:K8:16)
		
		//Emptying the arrray
		_arr RESIZE($vp_methodLinesArrayPtr; 0)
		
		ARRAY TEXT:C222($tt_tempMethodLinesArray; 0)
		
		C_LONGINT:C283($vl_methodSize; $vl_offset; $vl_errCode; $vl_lineSize; $vl_arrayNewSize)
		
		$vl_methodSize:=BLOB size:C605($vx_methodBlob)-13
		$vl_offset:=10
		$vl_lineNum:=0
		$vl_errCode:=0
		
		While ($vl_offset<$vl_methodSize)
			$vl_lineNum:=$vl_lineNum+1
			
			//Reading the line size in bytes
			$vl_lineSize:=BLOB to integer:C549($vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
			$vl_offset:=$vl_offset+2
			
			//Reading the logical line size
			$vl_logicalLineSize:=BLOB to integer:C549($vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
			$vl_offset:=$vl_offset-4
			
			//Isolate a line of code in the tokenized blob and copy it to another local blob
			COPY BLOB:C558($vx_methodBlob; $vx_LineTokens; $vl_offset; 0; $vl_lineSize)
			$vl_offset:=$vl_offset+$vl_lineSize
			
			Case of 
				: ($vl_logicalLineSize<2)
					
					//This looks like an emty line
					//we are adding an empty line into our local text array
					$vl_arrayNewSize:=Size of array:C274($tt_tempMethodLinesArray)+1
					INSERT IN ARRAY:C227($tt_tempMethodLinesArray; $vl_arrayNewSize; 1)
					$tt_tempMethodLinesArray{$vl_arrayNewSize}:=""
					
				Else 
					//Detokeinzing the line
					
					//C_TEXT(vt_SVN_tempText)
					vt_SVN_tempText:=""
					$vl_errCode:=_mb4d_Detokenize($vx_LineTokens; ->vt_SVN_tempText)
					$vt_lineText:=vt_SVN_tempText
					
					If ($vl_errCode=0)
						
						//we are adding a line into our local text array
						//and writing the detokenized code into it 
						$vl_arrayNewSize:=Size of array:C274($tt_tempMethodLinesArray)+1
						INSERT IN ARRAY:C227($tt_tempMethodLinesArray; $vl_arrayNewSize; 1)
						$tt_tempMethodLinesArray{$vl_arrayNewSize}:=$vt_lineText
						
					Else   //In cas of an error, we will exit from the while loop     
						$vl_offset:=$vl_methodSize
					End if 
					
			End case 
			
		End while 
		
		If ($vl_errCode=0)  //If there was no error, we will copy the local array back into the variable pointed by $2
			COPY ARRAY:C226($tt_tempMethodLinesArray; $vp_methodLinesArrayPtr->)
		End if 
		
		//Clearing our local array
		ARRAY TEXT:C222($tt_tempMethodLinesArray; 0)
		
	Else 
		_info_ ALERT(Current method name:C684+" : $2 is not of the expected type (text array pointer was expected) !")
	End if 
	
Else 
	_info_ ALERT(Current method name:C684+" : not enough parameters !")
End if 
