//%attributes = {}
// ----------------------------------------------------
// User name (OS): pate
// Date and time: 07.10.08, 22:32:04
// ----------------------------------------------------
// Method: _mb4d_MethodCreate
// Description
// (PM) 4D_SetMethodCode
// This method will set the contents of the specified method
// It can also be used to create new methods, but you should re-open 
// the structure file to see the changes applied.
// With many thanks to Miloslav Bystricky for helping with the code
// 
// Parameters
// $1 = Method name
// $2 = Method text
// called from: _mb_code_ IMPORT
// ----------------------------------------------------
C_LONGINT:C283($0; $_mb4d_lErr)
C_TEXT:C284($1; $_mb4d_tMethodName; $2; $_mb4d_tMethodCode; $3; $_mb4d_tFolderName)
//C_BLOB($_mb4d_xMethodCode)
ARRAY LONGINT:C221($_mb4d_alProperties; 6)

$_mb4d_tMethodName:=$1
$_mb4d_tMethodCode:=$2
$_mb4d_tFolderName:=$3

//TEXT TO BLOB($_mb4d_tMethodCode; $_mb4d_xMethodCode; Mac C string)
//TEXT TO BLOB($_mb4d_tMethodCode;$_mb4d_xMethodCode;UTF8 C string )

$_mb4d_alProperties{1}:=1  //visible
$_mb4d_alProperties{2}:=0  //no: 4DACTION, 4DMETHOD and 4DSCRIPT
$_mb4d_alProperties{3}:=0  //no: Web Service
$_mb4d_alProperties{4}:=0  //no: Web Service & WSDL
If ((Substring:C12($_mb4d_tMethodName; 1; 1)="_") & (Substring:C12($_mb4d_tMethodName; 2; 1)#"_"))
	$_mb4d_alProperties{5}:=1  //yes: must be shared between components
Else 
	$_mb4d_alProperties{5}:=0  //no: must be shared between components
End if 
$_mb4d_alProperties{6}:=0  //no: method must be available via SQL

// v19fix, AP Create method: 4D Pack
//https://doc.4d.com/4Dv16/4D-Pack/16/4D-Pack-Introduction.300-3010631.en.html
METHOD SET CODE:C1194($_mb4d_tMethodName; $_mb4d_tMethodCode; *)
//METHOD SET ATTRIBUTE("myMeth";vInvisible;2;v4DAction;3;vWebService;4;vWSDL;5;vExported;7;vSQL;8;vRemote;1024;vFolderName;*)
//$_mb4d_lErr:=‘11999;46‘($_mb4d_tMethodName; $_mb4d_alProperties; $_mb4d_xMethodCode; $_mb4d_tFolderName)
//AP Create method (methodName;propertiesArray;methodCode{;folderName}) -> Longint
//Parameter Type Description
//methodName String(31)? Name of the method(31 chars)
//propertiesArray Longint Array ? Array of properties(6 elements)
//methodCode BLOB ? BLOB containing the method text
//folderName String ? Explorer folder in which the method will be created
//Function result Longint ? Error code(0=no error)

//The propertiesArray parameter allows defining the method properties. It must hav
//declared previously as a longint array and must contain 4 items:
//• pass 1 in propertiesArray{1}if the method must be visible and 0 if not.
//• pass 1 in propertiesArray{2}if the method must be available for 4DACTION, 4DMETHOD and
//4DSCRIPT, and 0 if not.
//• pass 1 in propertiesArray{3}if the method must be offered as a Web Service and 0 if not.
//• in case of propertiesArray{3}=1, pass 1 in propertiesArray{4}if the method must be published
//in WSDL and 0 for the other cases.
//• pass 1 in propertiesArray{5}if the method must be shared between components and the host
//database, and 0 in the opposite case.
//• pass 1 in propertiesArray{6}if the method must be available via SQL, and 0 in the opposite
//case.

Case of 
	: ($_mb4d_lErr=0)
		IDLE:C311  //ok
	: ($_mb4d_lErr=1)
		_info_ ALERT("1=A bad parameter type has been passed."+ksCR+Current method name:C684)
	: ($_mb4d_lErr=2)
		_info_ ALERT("2=The database is running in compiled mode."+ksCR+Current method name:C684)
	: ($_mb4d_lErr=3)
		_info_ ALERT("3=The method name is an empty string."+ksCR+Current method name:C684)
	Else 
		TRACE:C157
End case 
$0:=$_mb4d_lErr

