//%attributes = {}
// Method: _mb4d_ModuleCodeFromMethName 
// 06.10.12, 16:51:13 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
//*==============================================================================
//Project method : snv_getModuleCodeFromMethodName
// Public
//
//DESCRIPTION :
// This function will return a module code from a method name
// The naming convention says that a module code is the part before the first "_"
// For instantce for "snv_getModuleCodeFromMethodName", "svn" is the module code
//
//PARAMETERS :
//  $0 (TEXTE)  <= module code
//  $1 (ENTIER) => method or function name
//  
//NOTES : 
//
//EXAMPLE : 
//  
//CREATION : Bruno LEGAY (BLE) - 29/03/07, 07:03:49 - v1.00.00
//*===============================================================================

C_TEXT:C284($0)  //module code
C_TEXT:C284($1)  //method or function name

C_TEXT:C284($vt_methodModuleCode)  //module code
C_TEXT:C284($vt_methodName)  //method or function name

$vt_methodModuleCode:=""

C_LONGINT:C283($vl_nbParam; $vl_pos; $vl_posSpace; $_mb4d_lCharIndex)
$vl_nbParam:=Count parameters:C259
If ($vl_nbParam>0)
	$vt_methodName:=$1
	
	If (Substring:C12($vt_methodName; 1; 1)="(")
		//don't export deleted method
		$vt_methodModuleCode:=""
	Else 
		//removing "(" for deleted methods
		//$vt_methodName:=Replace string($vt_methodName;"(";"")
		$vl_posUnderscore:=Position:C15("_"; $vt_methodName)
		$vl_posSpace:=Position:C15(" "; $vt_methodName)
		$vl_pos:=$vl_posUnderscore
		Case of 
			: (($vl_posSpace>1) & ($vl_posSpace<$vl_pos))
				$vl_pos:=$vl_posSpace-1
			: (($vl_posSpace>1) & ($vl_pos=0))
				$vl_pos:=$vl_posSpace-1
			Else 
				$vl_pos:=$vl_pos
		End case 
		
		$vt_methodModuleCode:=""
		$_mb4d_lCharIndex:=1
		If ($vl_posUnderscore#1)
			While ($_mb4d_lCharIndex>0)
				If (Character code:C91(_str_ ToLower($vt_methodName[[$_mb4d_lCharIndex]]))=Character code:C91($vt_methodName[[$_mb4d_lCharIndex]]))
					$vt_methodModuleCode:=$vt_methodModuleCode+$vt_methodName[[$_mb4d_lCharIndex]]
				Else 
					$_mb4d_lCharIndex:=-1  //end loop
				End if 
				
				$_mb4d_lCharIndex:=$_mb4d_lCharIndex+1
				If ($_mb4d_lCharIndex>Length:C16($vt_methodName))
					$_mb4d_lCharIndex:=-1  //end loop
				End if 
			End while 
			
			If (Length:C16($vt_methodModuleCode)>0)
				If (Length:C16($vt_methodModuleCode)<$vl_pos)
					$vl_pos:=Length:C16($vt_methodModuleCode)
				End if 
			End if 
		End if 
		
		Case of 
			: ($vl_pos<1)
				
				If ((Length:C16($vt_methodModuleCode)<1) | (Length:C16($vt_methodModuleCode)>10))
					$vt_methodModuleCode:="_other"
				End if 
				
			: (Substring:C12($vt_methodName; 1; 2)="__")
				$vt_methodModuleCode:="__test"
			Else 
				If ($vt_methodName[[1]]="_")
					$vl_pos:=Position:C15("_"; $vt_methodName; 2)
				End if 
				$vl_posSpace:=Position:C15(" "; $vt_methodName)
				Case of 
					: (($vl_posSpace>1) & ($vl_posSpace<$vl_pos))
						$vl_pos:=$vl_posSpace-1
					: (($vl_posSpace>1) & ($vl_pos=0))
						$vl_pos:=$vl_posSpace-1
					Else 
						$vl_pos:=$vl_pos
				End case 
				Case of 
					: ($vl_pos>0)
						$vt_methodModuleCode:=Substring:C12($vt_methodName; 1; $vl_pos)
					: (Length:C16($vt_methodName)<=10)  //like "_bar"
						$vt_methodModuleCode:=$vt_methodName
					Else 
						TRACE:C157
				End case 
		End case 
	End if 
	
Else 
	_info_ ALERT(Current method name:C684+" : parameter $1 is missing.")
End if 
$0:=$vt_methodModuleCode
