//%attributes = {}
//_prli_GetAreaRef("AreaName";{Opts};{Left;Top;Right;Bottom})

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//This method tells PrintTwist where the PT Area is located within
//  the host form.  Keep in mind that the PT Area must be completely
//  enclosed in the Detail area of the Host form, as specified 
//  by _prli_SetHostFormBreaks.

//PARAMETERS:
//$1: String: AreaName.  If running in Wrapper mode, this should be the 
//    literal variable name of the PLP Pluggin Area.
//$2: Longint: Bitwise options parameter
//   +1: Run in Wrapper Mode
//   +2: Delayed Execution (in Wrapper mode)
//$3-$6: Longints: Left, Top, Right and Bottom coordinates of your PrintTwist
//  target print area on your host form.  These parameters are optional, and only
//   need to be passed if you have not placed a PrintTwist object on your host
//   form.



C_TEXT:C284($1; $_prli_AreaName)
C_LONGINT:C283($0; $2; $_prli_opts; $3; $4; $5; $6; $_prli_opts; $_prli_iFindArea; $_prli_iType)
C_LONGINT:C283(_prli_AreaCounter)
C_BOOLEAN:C305(_prli_bRunAsWrapper)

$_prli_AreaName:=$1
$_prli_opts:=0
If (Count parameters:C259>1)
	$_prli_opts:=$2
End if 

$_prli_RunAsWrapper:=($_prli_opts ?? 0)  //+1
$_prli_PL_DelayedExecution:=($_prli_opts ?? 1)  //+2`Execute PL commands as they are called, or later on?

If ($_prli_PL_DelayedExecution)
	$_prli_RunAsWrapper:=True:C214
End if 

_prli_bRunAsWrapper:=$_prli_RunAsWrapper
//

ARRAY POINTER:C280(_prli_aGroup; 0)

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aAreaName; ->_prli_alAreaRef; ->_prli_aRunAsWrapper; ->_prli_aDelayedExecution; ->_prli_aConstrainRightColWidth; ->_prli_aClearArraysWhenDone; ->_prli_aPasteWidthsToClipboard; ->_prli_aObjectsFormName)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aAreaLeftCoord; ->_prli_aAreaTopCoord; ->_prli_aAreaRightCoord; ->_prli_aAreaBottomCoord)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aHdrBackColorNum; ->_prli_aListBackColorNum)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aBreakFunction; ->_prli_aBreakHdrFunction; ->_prli_aPrintLastPageBreak; ->_prli_aRowCallbackProc)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aPrintHeaders; ->_prli_aSortOrder; ->_prli_aTableNum)

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aDiv_Col_Width; ->_prli_aDiv_Col_Ptrn; ->_prli_aDiv_Col_ColorNum)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aDiv_Row_Width; ->_prli_aDiv_Row_Ptrn; ->_prli_aDiv_Row_ColorNum)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aFrame_Width; ->_prli_aFrame_Ptrn; ->_prli_aFrame_ColorNum)

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aNumHdrLines; ->_prli_aHdrHeightPad; ->_prli_aNumRowLines; ->_prli_aRowHeightPad; ->_prli_aHideColumns; ->_prli_aLastVisibleColumn; ->_prli_aFirstHiddenColumn; ->_prli_aHideDetail; ->_prli_aPageProc; ->_prli_aColumnPadding)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aBrkDividerLine_Width; ->_prli_aBrkDividerLine_Pattern; ->_prli_aBrkDividerLine_ColorNum)


_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aArray; ->_prli_aHeader; ->_prli_aWidth; ->_prli_aFormat; ->_prli_aColJust; ->_prli_aHdrJust)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aColFontName; ->_prli_aColFontSize; ->_prli_aColFontStyle; ->_prli_aHdrColFontName; ->_prli_aHDRColFontSize; ->_prli_aHDRColFontStyle)  //2D Arrays

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aColHdrForeColorNum; ->_prli_aColListForeColorNum)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aRepeatValues)

//See Also: 
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aBrk_LevCol; ->_prli_aBrk_Text; ->_prli_aBrk_OverflowCols; ->_prli_aBrk_FontName; ->_prli_aBrk_FontSize; ->_prli_aBrk_FontStyle; ->_prli_aBrk_Justify; ->_prli_aBrk_ShowColDivider; ->_prli_aBrk_ColorNum; ->_prli_aBrk_BackColorNum)

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aBrkLevHeight_Level; ->_prli_aBrkLevHeight_Lines; ->_prli_aBrkLevHeight_Pad)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aBkHLevHeight_Level; ->_prli_aBkHLevHeight_Lines; ->_prli_aBkHLevHeight_Pad)

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aHdrLine_Width; ->_prli_aHdrLine_Ptrn; ->_prli_aHdrLine_ColorNum)

//See Also: _prli_Util_RowElementsSize
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aRowFontName; ->_prli_aRowFontSize; ->_prli_aRowFontStyle; ->_prli_aRowForeColorNum; ->_prli_aRowBackColorNum)

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aPageBreakLevel)  //_prli_SetPageBreak

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aBrkKeepSamePage_First; ->_prli_aBrkKeepSamePage_Last)


_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aCellStyle_ColumnRowFrom; ->_prli_aCellStyle_ColumnRowTo; ->_prli_aCellStyle_StyleSheet)
_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aCellColor_ColumnRowFrom; ->_prli_aCellColor_ColumnRowTo; ->_prli_aCellColor_ForeClr; ->_prli_aCellColor_BackClr)

_prli_Util_Ptr2Array(->_prli_aGroup; 1; ->_prli_aCodeQueue)

If (Type:C295(_prli_aArray)=Is undefined:K8:13)
	$_prli_Init:=True:C214
Else 
	$_prli_Init:=(Size of array:C274(_prli_aArray)=0)
End if 

If ($_prli_Init)
	//Items that are specific to a WHOLE PRINT AREA  
	ARRAY TEXT:C222(_prli_aAreaName; 0)
	ARRAY LONGINT:C221(_prli_alAreaRef; 0)
	ARRAY BOOLEAN:C223(_prli_aRunAsWrapper; 0)
	ARRAY BOOLEAN:C223(_prli_aDelayedExecution; 0)
	ARRAY BOOLEAN:C223(_prli_aConstrainRightColWidth; 0)
	ARRAY BOOLEAN:C223(_prli_aClearArraysWhenDone; 0)
	ARRAY BOOLEAN:C223(_prli_aPasteWidthsToClipboard; 0)
	ARRAY TEXT:C222(_prli_aObjectsFormName; 0)
	
	
	ARRAY LONGINT:C221(_prli_aAreaLeftCoord; 0)
	ARRAY LONGINT:C221(_prli_aAreaTopCoord; 0)
	ARRAY LONGINT:C221(_prli_aAreaRightCoord; 0)
	ARRAY LONGINT:C221(_prli_aAreaBottomCoord; 0)
	
	ARRAY LONGINT:C221(_prli_aHdrBackColorNum; 0)  //_prli_SetBackClr
	ARRAY LONGINT:C221(_prli_aListBackColorNum; 0)  //_prli_SetBackClr
	
	ARRAY TEXT:C222(_prli_aBreakFunction; 0)
	ARRAY TEXT:C222(_prli_aBreakHdrFunction; 0)
	ARRAY INTEGER:C220(_prli_aPrintLastPageBreak; 0)
	ARRAY TEXT:C222(_prli_aRowCallbackProc; 0)
	
	ARRAY INTEGER:C220(_prli_aPrintHeaders; 0)  //0 (dlft) don't print hdrs, 1 = Print 1st pg headers, 2 = Print on all pgs
	ARRAY TEXT:C222(_prli_aSortOrder; 0)
	ARRAY INTEGER:C220(_prli_aTableNum; 0)
	
	//-------DIVIDERS---------
	ARRAY INTEGER:C220(_prli_aDiv_Col_Width; 0)
	_O_ARRAY STRING:C218(11; _prli_aDiv_Col_Ptrn; 0)
	ARRAY INTEGER:C220(_prli_aDiv_Col_ColorNum; 0)
	
	ARRAY INTEGER:C220(_prli_aDiv_Row_Width; 0)
	_O_ARRAY STRING:C218(11; _prli_aDiv_Row_Ptrn; 0)
	ARRAY INTEGER:C220(_prli_aDiv_Row_ColorNum; 0)
	
	//---------FRAME---------------
	ARRAY INTEGER:C220(_prli_aFrame_Width; 0)
	_O_ARRAY STRING:C218(11; _prli_aFrame_Ptrn; 0)
	ARRAY INTEGER:C220(_prli_aFrame_ColorNum; 0)
	
	ARRAY INTEGER:C220(_prli_aHdrLine_Width; 0)
	_O_ARRAY STRING:C218(11; _prli_aHdrLine_Ptrn; 0)
	ARRAY INTEGER:C220(_prli_aHdrLine_ColorNum; 0)
	
	//------------------------------
	ARRAY INTEGER:C220(_prli_aNumHdrLines; 0)  //Dflt 1
	ARRAY INTEGER:C220(_prli_aHdrHeightPad; 0)  //Dflt 2
	ARRAY INTEGER:C220(_prli_aNumRowLines; 0)  //Dflt 1
	ARRAY INTEGER:C220(_prli_aRowHeightPad; 0)  //Dflt 0
	ARRAY INTEGER:C220(_prli_aHideColumns; 0)
	
	ARRAY POINTER:C280(_prli_aLastVisibleColumn; 0)
	ARRAY POINTER:C280(_prli_aFirstHiddenColumn; 0)
	
	ARRAY INTEGER:C220(_prli_aHideDetail; 0)
	ARRAY TEXT:C222(_prli_aPageProc; 0)
	ARRAY INTEGER:C220(_prli_aColumnPadding; 0)  //Default to 7
	
	
	ARRAY INTEGER:C220(_prli_aBrkDividerLine_Width; 0)
	_O_ARRAY STRING:C218(11; _prli_aBrkDividerLine_Pattern; 0)
	ARRAY INTEGER:C220(_prli_aBrkDividerLine_ColorNum; 0)
	
	
	//----------THIS GROUP IS PARALLEL IN THE 2ND DIM---
	//See Also: _prli_SetArraysPtr
	//Items here are COLUMN SPECIFIC
	ARRAY POINTER:C280(_prli_aArray; 0; 0)
	ARRAY TEXT:C222(_prli_aHeader; 0; 0)
	ARRAY INTEGER:C220(_prli_aWidth; 0; 0)
	ARRAY TEXT:C222(_prli_aFormat; 0; 0)
	ARRAY INTEGER:C220(_prli_aColJust; 0; 0)
	ARRAY INTEGER:C220(_prli_aHdrJust; 0; 0)
	
	ARRAY TEXT:C222(_prli_aColFontName; 0; 0)
	ARRAY INTEGER:C220(_prli_aColFontSize; 0; 0)
	ARRAY INTEGER:C220(_prli_aColFontStyle; 0; 0)
	
	ARRAY TEXT:C222(_prli_aHdrColFontName; 0; 0)
	ARRAY INTEGER:C220(_prli_aHDRColFontSize; 0; 0)
	ARRAY INTEGER:C220(_prli_aHDRColFontStyle; 0; 0)
	
	ARRAY INTEGER:C220(_prli_aColHdrForeColorNum; 0; 0)  //_prli_SetForeClr
	ARRAY INTEGER:C220(_prli_aColListForeColorNum; 0; 0)
	
	ARRAY INTEGER:C220(_prli_aRepeatValues; 0; 0)  //_prli_SetRepeatVal
	
	//----------------------------------------------
	//items here are BREAK LEVEL AND COLUMN SPECIFIC
	//See Also: _prli_SetBrkText, PL_SetBrkStyle
	//This block of 9 arrays are used for both Breaks and HdrBreaks.
	ARRAY LONGINT:C221(_prli_aBrk_LevCol; 0; 0)  //2nd dim holds joined Level*256 + Col.
	ARRAY TEXT:C222(_prli_aBrk_Text; 0; 0)  //Brk Text & Num cols to over flow
	ARRAY INTEGER:C220(_prli_aBrk_OverflowCols; 0; 0)
	ARRAY TEXT:C222(_prli_aBrk_FontName; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrk_FontSize; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrk_FontStyle; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrk_Justify; 0; 0)
	ARRAY BOOLEAN:C223(_prli_aBrk_ShowColDivider; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrk_ColorNum; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrk_BackColorNum; 0; 0)
	
	
	//------------------------------
	ARRAY INTEGER:C220(_prli_aBrkLevHeight_Level; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrkLevHeight_Lines; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrkLevHeight_Pad; 0; 0)
	
	ARRAY INTEGER:C220(_prli_aBkHLevHeight_Level; 0; 0)
	ARRAY INTEGER:C220(_prli_aBkHLevHeight_Lines; 0; 0)
	ARRAY INTEGER:C220(_prli_aBkHLevHeight_Pad; 0; 0)
	
	//------------------------------
	//Items here that are ROW SPECIFIC
	
	ARRAY TEXT:C222(_prli_aRowFontName; 0; 0)
	ARRAY INTEGER:C220(_prli_aRowFontSize; 0; 0)
	ARRAY INTEGER:C220(_prli_aRowFontStyle; 0; 0)
	ARRAY INTEGER:C220(_prli_aRowForeColorNum; 0; 0)
	ARRAY INTEGER:C220(_prli_aRowBackColorNum; 0; 0)
	
	//----------------------------------
	ARRAY INTEGER:C220(_prli_aPageBreakLevel; 0; 0)
	ARRAY INTEGER:C220(_prli_aBrkKeepSamePage_First; 0)
	ARRAY INTEGER:C220(_prli_aBrkKeepSamePage_Last; 0)
	
	//-----------------------------
	
	ARRAY LONGINT:C221(_prli_aCellStyle_ColumnRowFrom; 0; 0)
	ARRAY LONGINT:C221(_prli_aCellStyle_ColumnRowTo; 0; 0)  //Changed from Integer to Longint on 6/14/04
	ARRAY INTEGER:C220(_prli_aCellStyle_StyleSheet; 0; 0)
	
	ARRAY LONGINT:C221(_prli_aCellColor_ColumnRowFrom; 0; 0)
	ARRAY LONGINT:C221(_prli_aCellColor_ColumnRowTo; 0; 0)
	ARRAY INTEGER:C220(_prli_aCellColor_ForeClr; 0; 0)
	ARRAY INTEGER:C220(_prli_aCellColor_BackClr; 0; 0)
	
	//-----------------------------
	ARRAY TEXT:C222(_prli_aCodeQueue; 0; 0)  //Store the execution code for PL Delayed execution
End if 

$_prli_iFindArea:=Find in array:C230(_prli_aAreaName; $_prli_AreaName)


If ($_prli_iFindArea>-1)
	//If this area was already in memory, something crashed.  We need to clear out
	//  the prior contents, or it will mess up our current instance.
	For ($_prli_i; 1; Size of array:C274(_prli_aGroup))
		$_prli_Ptr:=_prli_aGroup{$_prli_i}
		DELETE FROM ARRAY:C228($_prli_Ptr->; $_prli_iFindArea)
	End for 
End if 


$_prli_iFindArea:=Size of array:C274(_prli_aAreaName)+1
_prli_Util_SizeArrayGroup($_prli_iFindArea; ->_prli_aGroup)
_prli_aAreaName{$_prli_iFindArea}:=$_prli_AreaName

_prli_aRunAsWrapper{$_prli_iFindArea}:=$_prli_RunAsWrapper
_prli_aDelayedExecution{$_prli_iFindArea}:=$_prli_PL_DelayedExecution

If ($_prli_RunAsWrapper & Not:C34($_prli_PL_DelayedExecution))
	
	C_LONGINT:C283($_prli_iAreaNum)
	$_prli_iAreaNum:=Num:C11($_prli_AreaName)
	If ($_prli_AreaName=String:C10($_prli_iAreaNum))  //Is AreaName a literal PLP object Reference number?
		_prli_alAreaRef{$_prli_iFindArea}:=$_prli_iAreaNum
	Else 
		
		//We will attempt to interpet the AreaName as a PrintList object variable
		error:=0
		$_prli_PriorErrorMethod:=Method called on error:C704
		ON ERR CALL:C155("_prli_Util_Pass")
		$_prli_Ptr:=Get pointer:C304($_prli_AreaName)
		ON ERR CALL:C155($_prli_PriorErrorMethod)
		
		If (error#0)
			_info_ ALERT($_prli_AreaName+" was passed to "+Current method name:C684+" as an Area Name, but is not a defined variable."+Char:C90(13)+"This parameter should be a Variable that is also a PrintList Pluggin object.")
			ABORT:C156
		End if 
		$_prli_iType:=Type:C295($_prli_Ptr->)
		If (($_prli_iType=Is integer:K8:5) | ($_prli_iType=Is longint:K8:6) | ($_prli_iType=Is real:K8:4))
			_prli_alAreaRef{$_prli_iFindArea}:=$_prli_Ptr->
		Else 
			_info_ ALERT($_prli_AreaName+" was passed to "+Current method name:C684+" as an Area Name, but is a numeric data type."+Char:C90(13)+"This parameter should be a Variable that is also a PrintList Pluggin object.")
			ABORT:C156
		End if 
	End if 
Else 
	_prli_AreaCounter:=_prli_AreaCounter+1
	_prli_alAreaRef{$_prli_iFindArea}:=_prli_AreaCounter
End if 

_prli_aConstrainRightColWidth{$_prli_iFindArea}:=False:C215
_prli_aClearArraysWhenDone{$_prli_iFindArea}:=False:C215
_prli_aPasteWidthsToClipboard{$_prli_iFindArea}:=False:C215
_prli_aNumHdrLines{$_prli_iFindArea}:=1
_prli_aHdrHeightPad{$_prli_iFindArea}:=2
_prli_aNumRowLines{$_prli_iFindArea}:=1
_prli_aBrkDividerLine_Width{$_prli_iFindArea}:=-1
_prli_aColumnPadding{$_prli_iFindArea}:=7

$0:=_prli_alAreaRef{$_prli_iFindArea}

If (Count parameters:C259>5)
	_prli_aAreaLeftCoord{$_prli_iFindArea}:=$3
	_prli_aAreaTopCoord{$_prli_iFindArea}:=$4
	_prli_aAreaRightCoord{$_prli_iFindArea}:=$5
	_prli_aAreaBottomCoord{$_prli_iFindArea}:=$6
End if 
// 