//%attributes = {}
//_prli_SetFormatPtr

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//(AreaRef;Format;ColumnJust;HeaderJust;Opts;->ColArrays1-N)

//$1: AreaRef longint PrintTwist Area Reference
//$2: Format string format to use
//$3: ColumnJust integer justification for column list items
//$4: HeaderJust integer justification for column header
//$5: Opts Parameter: Longint Bitwise
//   +1: UsePictHeight integer use the picture height in the row height calculatio
//$6-N: ColArrays: Pointers to the arrays for which you are setting formats.

//See Also: _prli_SetFormat

//Dates: To supress null dates, put a "-" at end of format
//Times: To display a int/longint/time row as time, begin format with: "&/"


//Time Formats:
//1     01:02:03 
//2     01:02 
//3     1 hour 2 minutes 3 seconds 
//4     1 hour 2 minutes 
//5     1:02 AM 

//Date Formats:
//0    4/19/05 (default) 
//1    4/19/05 
//2    Tue, Apr 19, 2005 
//3    Tuesday, April 16, 2005 
//4    04/19/2005 or 04/19/1905 
//5    April 19, 2005 
//6    Apr 19, 2005 

C_LONGINT:C283($1; $_prli_iAreaRef; $_prli_iFindArea; $3; $_prli_ColumnJust; $4; $_prli_HeaderJust; $5; $_prli_opts; $_prli_UsePictHeight; $_prli_ColumnCount; $_prli_i; $_prli_iFindCol)
C_TEXT:C284($2; $_prli_Format)
C_POINTER:C301($_prli_pColArray; ${6})
C_BOOLEAN:C305(_prli_bRunAsWrapper)

$_prli_iAreaRef:=$1
$_prli_iFindArea:=_prli_Util_FindAreaRef($_prli_iAreaRef; Current method name:C684)
If ($_prli_iFindArea>-1)
	
	$_prli_Format:=_str_ FormatChange($2)  // PM 2011-03-01
	$_prli_ColumnJust:=0
	$_prli_HeaderJust:=0
	$_prli_opts:=0
	
	If (Count parameters:C259>2)
		$_prli_ColumnJust:=$3
	End if 
	If (Count parameters:C259>3)
		$_prli_HeaderJust:=$4
	End if 
	If (Count parameters:C259>4)
		$_prli_opts:=$5
	End if 
	
	$_prli_UsePictHeight:=Num:C11($_prli_opts ?? 0)  //+1
	
	$_prli_ColumnCount:=Count parameters:C259-5
	
	For ($_prli_i; 1; $_prli_ColumnCount)
		
		$_prli_pColArray:=${5+$_prli_i}
		$_prli_iFindCol:=Find in array:C230(_prli_aArray{$_prli_iFindArea}; $_prli_pColArray)
		
		If ($_prli_iFindCol>-1)
			_prli_aFormat{$_prli_iFindArea}{$_prli_iFindCol}:=$_prli_Format
			_prli_aColJust{$_prli_iFindArea}{$_prli_iFindCol}:=$_prli_ColumnJust
			_prli_aHdrJust{$_prli_iFindArea}{$_prli_iFindCol}:=$_prli_HeaderJust
			
			If (_prli_bRunAsWrapper)
				$_prli_Execute:="_prli_SetFormat ("+_prli_Util_AreaRefString($_prli_iAreaRef)+";"+String:C10($_prli_iFindCol)+";"+Char:C90(34)+$_prli_Format+Char:C90(34)+";"+String:C10($_prli_ColumnJust)+";"+String:C10($_prli_HeaderJust)+";"+String:C10($_prli_opts)+")"
				_prli_Util_QueuePLCode($_prli_iAreaRef; $_prli_Execute)
			End if 
			
		Else 
			_info_ ALERT("Column: "+_prli_Util_PtrName($_prli_pColArray)+" Not Found."+Char:C90(13)+Current method name:C684)
		End if 
		
	End for 
End if 
