//%attributes = {}
//_prli_SetWidths2(Area;StartCol;ScalingFactor;{TextWidths};{Width1-N})


//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//--------------------------------PARAMETERS--------------------------------
//Similar to _prli_SetWidths, except for the following:
//$1: Longint: AreaRef
//$2: Longint: Starting columns, or Zero
//$3 is a percentage scaling factor: This number will scale the widths of all
//   columns passed in this call by X%.  100 is the default.  Zero is treated
//    as 100.
//If only 3 parameters are passed, and StartCol is zero, then the scaling
//      factor will be applied to all pre-defined columns.
//$4 is a text parameter: If $4="", then parameters $5 to $N will be used.
//   $4 can contain widths delimited by semi-colons, in which case you do
//   NOT pass $5-$n.


//--------------------------------REVISION HISTORY--------------------------------
//Rev: 07/30/07: Enable to re-scale columns if only 3 prms passed
//Rev 04/18/07: If $4 ends with ";" then don't count it as an error.


//--------------------------------------------------------------------------------
C_LONGINT:C283($1; $_prli_iAreaRef; $2; $_prli_iStartCol; $_prli_iNumCol)
C_REAL:C285($3; $_prli_rScaleFactor)
C_TEXT:C284($4)
C_LONGINT:C283(${5})
C_BOOLEAN:C305(_prli_bRunAsWrapper)

$_prli_iAreaRef:=$1
$_prli_iStartCol:=$2
$_prli_rScaleFactor:=$3

$_prli_ExecString:=""
If (_prli_bRunAsWrapper)
	ARRAY TEXT:C222($_prli_aExecText; 10)
	ARRAY INTEGER:C220($_prli_aExecColBeg; 10)
	ARRAY INTEGER:C220($_prli_aExecNumCols; 10)
	$_prli_iExecElement:=1
	$_prli_iExecCtr:=0
End if 

$_prli_iFindArea:=_prli_Util_FindAreaRef($_prli_iAreaRef; Current method name:C684)
If ($_prli_iFindArea>-1)
	If ((Count parameters:C259=3) & ($_prli_iStartCol=0))
		//If only 3 parameters are passed, and StartCol is zero, then the scaling
		//      factor will be applied to all pre-defined columns.
		For ($_prli_iCntArray; 1; Size of array:C274(_prli_aWidth{$_prli_iFindArea}))
			_prli_aWidth{$_prli_iFindArea}{$_prli_iCntArray}:=Round:C94(_prli_aWidth{$_prli_iFindArea}{$_prli_iCntArray}*$_prli_rScaleFactor/100; 2)
		End for 
	Else 
		If ($_prli_iStartCol=0)
			$_prli_iStartCol:=1
		End if 
		
		ARRAY LONGINT:C221($_prli_aWidths; 0)
		If (Count parameters:C259=4)
			ARRAY LONGINT:C221(_prli_aUtilLong1; 0)
			$_prli_Widths:=$4
			If (Length:C16($_prli_Widths)>0)
				If ($_prli_Widths[[Length:C16($_prli_Widths)]]=";")
					$_prli_Widths:=Substring:C12($_prli_Widths; 1; Length:C16($_prli_Widths)-1)
				End if 
			End if 
			_prli_Util_TextToArray($_prli_Widths; ->_prli_aUtilLong1; ";")
			COPY ARRAY:C226(_prli_aUtilLong1; $_prli_aWidths)
			ARRAY LONGINT:C221(_prli_aUtilLong1; 0)
		Else 
			ARRAY LONGINT:C221($_prli_aWidths; Count parameters:C259-4)
			For ($_prli_iPrmCtr; 5; Count parameters:C259)
				$_prli_aWidths{$_prli_iPrmCtr-4}:=${$_prli_iPrmCtr}
			End for 
		End if 
		
		$_prli_iNumCol:=Size of array:C274($_prli_aWidths)
		
		If ($_prli_rScaleFactor=0)
			$_prli_rScaleFactor:=100
		End if 
		
		If ($_prli_rScaleFactor#100)
			For ($_prli_i; 1; Size of array:C274($_prli_aWidths))
				$_prli_aWidths{$_prli_i}:=Round:C94($_prli_aWidths{$_prli_i}*$_prli_rScaleFactor/100; 0)
			End for 
		End if 
		
		
		If (($_prli_iStartCol+$_prli_iNumCol-1)>Size of array:C274(_prli_aArray{$_prli_iFindArea}))
			_info_ ALERT("More widths were passed than the number of columns that exist."+Char:C90(13)+Current method name:C684)
			$_prli_iNumCol:=Size of array:C274(_prli_aArray{$_prli_iFindArea})-$_prli_iStartCol
		End if 
		
		$_prli_iOldColCnt:=Size of array:C274(_prli_aWidth{$_prli_iFindArea})
		$_prli_iAddElements:=($_prli_iStartCol+$_prli_iNumCol-1)-$_prli_iOldColCnt
		If ($_prli_iAddElements>0)
			INSERT IN ARRAY:C227(_prli_aWidth{$_prli_iFindArea}; $_prli_iOldColCnt; $_prli_iAddElements)
		End if 
		
		For ($_prli_iCntArray; 1; $_prli_iNumCol)
			$_prli_iColNum:=$_prli_iStartCol+$_prli_iCntArray-1
			_prli_aWidth{$_prli_iFindArea}{$_prli_iColNum}:=$_prli_aWidths{$_prli_iCntArray}
			
			If (_prli_bRunAsWrapper)
				$_prli_iExecCtr:=$_prli_iExecCtr+1
				If ($_prli_iExecCtr>14)
					$_prli_iExecElement:=$_prli_iExecElement+1
					$_prli_iExecCtr:=0
					$_prli_aExecColBeg{$_prli_iExecElement}:=$_prli_iColNum
				End if 
				$_prli_aExecText{$_prli_iExecElement}:=$_prli_aExecText{$_prli_iExecElement}+String:C10($_prli_aWidths{$_prli_iCntArray})+";"
				$_prli_aExecNumCols{$_prli_iExecElement}:=$_prli_aExecNumCols{$_prli_iExecElement}+1
			End if 
			
		End for 
	End if 
End if 

If (_prli_bRunAsWrapper & ($_prli_iNumCol>0))
	$_prli_aExecColBeg{1}:=$_prli_iStartCol
	For ($_prli_iCtr; 1; $_prli_iExecElement)
		$_prli_Execute:="_prli_SetWidths ("+_prli_Util_AreaRefString($_prli_iAreaRef)+";"+String:C10($_prli_aExecColBeg{$_prli_iCtr})+";"+String:C10($_prli_aExecNumCols{$_prli_iCtr})+";"+Substring:C12($_prli_aExecText{$_prli_iCtr}; 1; Length:C16($_prli_aExecText{$_prli_iCtr})-1)+")"
		_prli_Util_QueuePLCode($_prli_iAreaRef; $_prli_Execute)
	End for 
End if 
