//%attributes = {}
//_prli_Util_InsertBreakElement(iFindArea;BreakLev;Column;Hdr)->ElementNumber

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

C_LONGINT:C283($1; $_prli_iFindArea; $2; $_prli_iBreakLevel; $3; $_prli_iColumn; $_prli_iKey; $0; $_prli_iHdrAdd)
C_BOOLEAN:C305($4)

//PARAMETERS
//$1: The index element of the PT Area
//$2: Break Level
//$3: Column number, can be zero
//$4: Hdr: boolean: true if setting a Break Header, False if setting a Break {ftr}

$_prli_iFindArea:=$1
$_prli_iBreakLevel:=$2
$_prli_iColumn:=$3

$_prli_iHdrAdd:=0
If (Count parameters:C259>3)
	If ($4)
		$_prli_iHdrAdd:=256
	End if 
End if 

If (False:C215)
	$_prli_pArray:=_prli_aArray{$_prli_iFindArea}{$_prli_iColumn}
	Case of 
		: ($_prli_iColumn=0)
			$_prli_IsVaid:=True:C214
			
		: (Is nil pointer:C315($_prli_pArray))
			$_prli_IsVaid:=False:C215
			_prli_Util_ErrorAlert("Column "+String:C10($_prli_iColumn)+" cannot be a break column: Nil"; "_prli_Util_InsertBreakElement")
			$_prli_iColumn:=0
			
		: (Is a variable:C294($_prli_pArray))
			$_prli_IsVaid:=_prli_Util_IsAnArray($_prli_pArray)
			If ($_prli_IsVaid=False:C215)
				_prli_Util_ErrorAlert("Column "+String:C10($_prli_iColumn)+" cannot be a break column: "+_prli_Util_PtrName($_prli_pArray); "_prli_Util_InsertBreakElement")
				$_prli_iColumn:=0
			End if 
			
		Else 
			//is a field
			$_prli_IsVaid:=True:C214
	End case 
End if 

$_prli_iKey:=($_prli_iBreakLevel*512)+$_prli_iHdrAdd+$_prli_iColumn

$_prli_iFindlevCol:=Find in array:C230(_prli_aBrk_LevCol{$_prli_iFindArea}; $_prli_iKey)
If ($_prli_iFindlevCol=-1)
	$_prli_iFindlevCol:=Size of array:C274(_prli_aBrk_LevCol{$_prli_iFindArea})+1
	
	INSERT IN ARRAY:C227(_prli_aBrk_LevCol{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_Text{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_OverflowCols{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_FontName{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_FontSize{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_FontStyle{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_Justify{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_ShowColDivider{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_ColorNum{$_prli_iFindArea}; $_prli_iFindlevCol)
	INSERT IN ARRAY:C227(_prli_aBrk_BackColorNum{$_prli_iFindArea}; $_prli_iFindlevCol)
	
	_prli_aBrk_LevCol{$_prli_iFindArea}{$_prli_iFindlevCol}:=$_prli_iKey
	_prli_aBrk_FontStyle{$_prli_iFindArea}{$_prli_iFindlevCol}:=-1
	_prli_aBrk_ShowColDivider{$_prli_iFindArea}{$_prli_iFindlevCol}:=False:C215
	
	
End if 
$0:=$_prli_iFindlevCol