//%attributes = {}
//_prli_Util_MyType(Ptr;Opts)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//FUNCTION: Return the data type of $1:  In particular, if $1
//  is a 2D array, then return the specific type.

//--------------------------------------------------------------------------------
//REVISION HISTORY 
//Rev: 07/27/07: Bug fix for pointers to 2D array local variables
//Rev: 07/27/07: Made provisions for nil, and ptr to a table
//Rev: 11/26/02: Renamed Variables
//Rev: 05/16/00: efficiency improvement

//--------------------------------------------------------------------------------

C_POINTER:C301($1; $_prli_Ptr2)
C_LONGINT:C283($2; $0; $_prli_iType; $_prli_iTableNum; $_prli_iFieldNum)
C_TEXT:C284($_prli_VarName)
C_BLOB:C604($_prli_Blob)

Case of 
	: (Is nil pointer:C315($1))
		$_prli_iType:=-1
		
	: (Is a variable:C294($1))
		$_prli_iType:=Type:C295($1->)
		
	: (Field:C253($1)>0)
		$_prli_iType:=Type:C295($1->)
		
	Else 
		
		$_prli_iType:=-2  //Pointer to a table    
		
End case 

If ($_prli_iType=Array 2D:K8:24)
	RESOLVE POINTER:C394($1; $_prli_VarName; $_prli_iTableNum; $_prli_iFieldNum)
	If ($_prli_iTableNum=-1)  //$iTableNum=-1 indicates the 1st dimension of a 2d array: not allowed here.
		//The type remains "Array 2D"
	Else 
		If ($_prli_VarName#"$@")  //07/20/2007
			$_prli_Ptr2:=Get pointer:C304($_prli_VarName)
			If (Size of array:C274($_prli_Ptr2->)<$_prli_iTableNum)
				_prli_Util_ErrorAlert("Tried to reference array "+String:C10($_prli_iTableNum)+" of "+$_prli_VarName+" which had only "+String:C10(Size of array:C274($_prli_Ptr2->))+" arrays."+Char:C90(13)+"The Array was added."; "MyType")
				INSERT IN ARRAY:C227($_prli_Ptr2->; Size of array:C274($_prli_Ptr2->)+1; $_prli_iTableNum-Size of array:C274($_prli_Ptr2->))  //Add the necessary arrays.
			End if 
		End if 
		VARIABLE TO BLOB:C532($1->{0}; $_prli_Blob)
		$_prli_iType:=$_prli_Blob{4}
		Case of 
			: ($_prli_iType=Is integer:K8:5)
				$_prli_iType:=Integer array:K8:18
				
			: ($_prli_iType=Is longint:K8:6)
				$_prli_iType:=LongInt array:K8:19
				
			: ($_prli_iType=Is real:K8:4)
				$_prli_iType:=Real array:K8:17
				
			: ($_prli_iType=Is text:K8:3)
				$_prli_iType:=Text array:K8:16
				
			: ($_prli_iType=Is string var:K8:2)
				$_prli_iType:=String array:K8:15
				
			: ($_prli_iType=Is date:K8:7)
				$_prli_iType:=Date array:K8:20
				
			: ($_prli_iType=Is boolean:K8:9)
				$_prli_iType:=Boolean array:K8:21
				
			: ($_prli_iType=Is picture:K8:10)
				$_prli_iType:=Picture array:K8:22
				
			: ($_prli_iType=Is pointer:K8:14)
				$_prli_iType:=Pointer array:K8:23
				
		End case 
	End if 
End if 
$0:=$_prli_iType
