//%attributes = {}
//_prli_Util_PrintBreaks

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//Two main columns are important here:
//1: The column of the sort break array
//2: The column we will be printing in

//See Also: 
//   _prli_SetBrkText 
//   _prli_SetBkHText 

//Rev History:
//08/14/07: convert all "\@" to $Bkslash
//11/20/06: added support for formats using "4DMehtod;@"
//09/28/05: Protect against sorting on column zero
//03/03/05: Added \FirstValue and \LastValue

C_LONGINT:C283($_prli_iLevel; $_prli_iBeginRow; $_prli_iEndRow; $_prli_iBrkColumn; $_prli_iMaxTextHeight; $_prli_iFindHeight; $_prli_iNumBrkLines; $_prli_iFindBrkCol; $_prli_iPrintCol; $_prli_iColType; $_prli_iSumCtr; $_prli_iBrkValueType)
C_LONGINT:C283($_prli_iOverFlowCols; $_prli_iFontSize; $_prli_iFontStyle; $_prli_iJustify; $_prli_iLeftCol; $_prli_iRightCol; $_prli_iTotalWidth; $_prli_iFontHeight; $_prli_iFindColZero; $_prli_iSizeArray)
C_LONGINT:C283($_prli_iTestBrkLevelCtr)
C_TEXT:C284($_prli_FontName)

C_LONGINT:C283(_prli_BreakLevel; _prli_iBrkPadHeight)
C_POINTER:C301($_prli_pBrkArray; $_prli_pColumnArray)

If (_prli_bHdrBreak)
	$_prli_iLevel:=_prli_aSortBrkLev{_prli_iPrintingRow-1}
Else 
	$_prli_iLevel:=_prli_aSortBrkLev{_prli_iPrintingRow}  //Get the current sort break level
End if 

_O_C_STRING:C293(1; $_prli_Bkslash)
$_prli_Bkslash:=Char:C90(92)  //Backslask

$_prli_AnyBreakPrinted:=False:C215
If ($_prli_iLevel#-1)
	
	If (_prli_bHdrBreak)
		$_prli_iLoopFrom:=$_prli_iLevel
		$_prli_iLoopTo:=Size of array:C274(_prli_aSortLevelColumn)
		$_prli_iLoopStep:=1
	Else 
		$_prli_iLoopFrom:=Size of array:C274(_prli_aSortLevelColumn)
		$_prli_iLoopTo:=$_prli_iLevel
		$_prli_iLoopStep:=-1
	End if 
	
	
	//--------------------------------------------------------------------------------
	//See if we need to make a page break here to keep a break level together
	For (_prli_BreakLevel; $_prli_iLoopFrom; $_prli_iLoopTo; $_prli_iLoopStep)
		If (_prli_bHdrBreak)
			
			C_BOOLEAN:C305(_prli_CountingRowHeights)
			$_prli_LevelMatch:=(_prli_BreakLevel=1) | (_prli_BreakLevel=2)
			If ((_prli_BreakLevel>0) & ((_prli_BreakLevel>=_prli_aBrkKeepSamePage_First{_prli_iFindArea}) & (_prli_BreakLevel<=_prli_aBrkKeepSamePage_Last{_prli_iFindArea})) & (_prli_CountingRowHeights=False:C215))  // & (a_prli_BrkKeepSamePage{_prli_iFindArea}=_prli_BreakLevel)
				
				
				$_prli_iBeginRow:=_prli_iPrintingRow
				$_prli_iEndRow:=Size of array:C274(_prli_aSortBrkLev)
				For ($_prli_iCtr; _prli_iPrintingRow; Size of array:C274(_prli_aSortBrkLev))
					If (_prli_aSortBrkLev{$_prli_iCtr}<=_prli_BreakLevel) & (_prli_aSortBrkLev{$_prli_iCtr}>=0)
						$_prli_iEndRow:=$_prli_iCtr
						$_prli_iCtr:=Size of array:C274(_prli_aSortBrkLev)
					End if 
				End for 
				
				$_prli_TotalBreakAndDetailHeigh:=0
				For ($_prli_iCtr; $_prli_iBeginRow; $_prli_iEndRow)
					$_prli_TotalBreakAndDetailHeigh:=$_prli_TotalBreakAndDetailHeigh+_prli_aRowPreHeight{_prli_iFindArea}{$_prli_iCtr}+_prli_aRowHeight{_prli_iFindArea}{$_prli_iCtr}+_prli_aRowPostHeight{_prli_iFindArea}{$_prli_iCtr}
				End for 
				
				If ($_prli_TotalBreakAndDetailHeigh>0)
					_prli_Util_PrintPageBreak(0; $_prli_TotalBreakAndDetailHeigh+1)  //Add one (slop) pixel for a possible break row divider            
				End if 
				
				
			End if   //((a_prli_BrkKeepSamePage{_prli_iFindArea}>=_prli_BreakLevel) & (_prli_CountingRowHeights=Fal
			
		End if 
	End for 
	//--------------------------------------------------------------------------------
	
	
	For (_prli_BreakLevel; $_prli_iLoopFrom; $_prli_iLoopTo; $_prli_iLoopStep)
		
		$_prli_TotalBreakAndDetailHeigh:=0
		If (_prli_bHdrBreak)
			$_prli_PrintThisBreak:=_prli_PrintBreakLevelHdr ?? _prli_BreakLevel
		Else 
			$_prli_PrintThisBreak:=_prli_PrintBreakLevelFtr ?? _prli_BreakLevel
		End if 
		
		If ($_prli_PrintThisBreak)
			
			If (_prli_BreakLevel=0)
				$_prli_iBeginRow:=1
				$_prli_iEndRow:=Size of array:C274(_prli_aSortBrkLev)
			Else 
				
				If (_prli_bHdrBreak)
					$_prli_iBeginRow:=_prli_iPrintingRow
					$_prli_iEndRow:=Size of array:C274(_prli_aSortBrkLev)
					For ($_prli_iCtr; _prli_iPrintingRow; Size of array:C274(_prli_aSortBrkLev))
						If (_prli_aSortBrkLev{$_prli_iCtr}<=_prli_BreakLevel) & (_prli_aSortBrkLev{$_prli_iCtr}>=0)
							$_prli_iEndRow:=$_prli_iCtr
							$_prli_iCtr:=Size of array:C274(_prli_aSortBrkLev)
						End if 
					End for 
					
				Else 
					$_prli_iBeginRow:=1
					$_prli_iEndRow:=_prli_iPrintingRow
					For ($_prli_iCtr; _prli_iPrintingRow-1; 1; -1)
						If (_prli_aSortBrkLev{$_prli_iCtr}<=_prli_BreakLevel) & (_prli_aSortBrkLev{$_prli_iCtr}>=0)
							$_prli_iBeginRow:=$_prli_iCtr+1
							$_prli_iCtr:=0
						End if 
					End for 
				End if 
				
				$_prli_iBrkColumn:=Abs:C99(_prli_aSortLevelColumn{_prli_BreakLevel})
				$_prli_pBrkArray:=_prli_aHiddenArray{$_prli_iBrkColumn}
				
				Case of 
					: (Is nil pointer:C315($_prli_pBrkArray))
						$_prli_iBrkValueType:=-1
					: (_prli_aIsArrayOrField{$_prli_iBrkColumn}=False:C215)
						$_prli_iBrkValueType:=-1
					Else 
						$_prli_iBrkValueType:=Type:C295($_prli_pBrkArray->)
						If ($_prli_iBrkValueType=Array 2D:K8:24)
							$_prli_iBrkValueType:=_prli_Util_MyType($_prli_pBrkArray)
						End if 
				End case 
			End if 
			
			//--------------------------------------    
			$_prli_iMaxTextHeight:=0
			
			$_prli_iNumBrkLines:=1
			_prli_iBrkPadHeight:=0
			If (_prli_bHdrBreak)
				$_prli_iFindHeight:=Find in array:C230(_prli_aBkHLevHeight_Level{_prli_iFindArea}; _prli_BreakLevel)
				If ($_prli_iFindHeight>-1)
					$_prli_iNumBrkLines:=_prli_aBkHLevHeight_Lines{_prli_iFindArea}{$_prli_iFindHeight}
					_prli_iBrkPadHeight:=_prli_aBkHLevHeight_Pad{_prli_iFindArea}{$_prli_iFindHeight}
				End if 
			Else 
				$_prli_iFindHeight:=Find in array:C230(_prli_aBrkLevHeight_Level{_prli_iFindArea}; _prli_BreakLevel)
				If ($_prli_iFindHeight>-1)
					$_prli_iNumBrkLines:=_prli_aBrkLevHeight_Lines{_prli_iFindArea}{$_prli_iFindHeight}
					_prli_iBrkPadHeight:=_prli_aBrkLevHeight_Pad{_prli_iFindArea}{$_prli_iFindHeight}
				End if 
			End if 
			//--------------------------------------    
			
			//Store all the break text in an array, so that any functions will only be
			//   calculated once.
			ARRAY TEXT:C222(_prli_aBreakColumnText; 0)
			ARRAY TEXT:C222(_prli_aBreakColumnText; _prli_iVisibleCols)
			ARRAY INTEGER:C220(_prli_aBreakColumnStylSht; 0)
			ARRAY INTEGER:C220(_prli_aBreakColumnStylSht; _prli_iVisibleCols)
			
			For ($_prli_iFindBrkCol; 1; Size of array:C274(_prli_aBrk_LevCol{_prli_iFindArea}))
				$_prli_bHdrFooter:=((_prli_aBrk_LevCol{_prli_iFindArea}{$_prli_iFindBrkCol} ?? 8)=_prli_bHdrBreak)
				If ((_prli_aBrk_LevCol{_prli_iFindArea}{$_prli_iFindBrkCol}\512=_prli_BreakLevel) & $_prli_bHdrFooter)  //Right Break Level & Not a Hdr Brk
					$_prli_iPrintCol:=_prli_aBrk_LevCol{_prli_iFindArea}{$_prli_iFindBrkCol}%256
					If (($_prli_iPrintCol>0) & ($_prli_iPrintCol<=_prli_iVisibleCols))
						$_prli_AnyBreakPrinted:=True:C214
						$_prli_pColumnArray:=_prli_aHiddenArray{$_prli_iPrintCol}
						
						If (True:C214)  //_prli_Util_IsAnArray ($pColumnArray))
							
							$_prli_iColType:=_prli_Util_MyType($_prli_pColumnArray)
							
							
							$_prli_BrkText:=_prli_aBrk_Text{_prli_iFindArea}{$_prli_iFindBrkCol}
							$_prli_iOverFlowCols:=_prli_aBrk_OverflowCols{_prli_iFindArea}{$_prli_iFindBrkCol}
							
							//--------------------------------FONT/SIZE/STYLE------------------
							$_prli_FontName:=""
							$_prli_iFontSize:=0
							$_prli_iFontStyle:=-1
							
							$_prli_iFindZeroCol:=(_prli_BreakLevel*512)+(Num:C11(_prli_bHdrBreak)*256)
							$_prli_iFindColZero:=Find in array:C230(_prli_aBrk_LevCol{_prli_iFindArea}; $_prli_iFindZeroCol)
							
							If ($_prli_iFindColZero>-1)
								If (Length:C16(_prli_aBrk_FontName{_prli_iFindArea}{$_prli_iFindColZero})>0)
									$_prli_FontName:=_prli_aBrk_FontName{_prli_iFindArea}{$_prli_iFindColZero}
								End if 
								If (_prli_aBrk_FontSize{_prli_iFindArea}{$_prli_iFindColZero}#0)
									$_prli_iFontSize:=_prli_aBrk_FontSize{_prli_iFindArea}{$_prli_iFindColZero}
								End if 
								If (_prli_aBrk_FontStyle{_prli_iFindArea}{$_prli_iFindColZero}#-1)
									$_prli_iFontStyle:=_prli_aBrk_FontStyle{_prli_iFindArea}{$_prli_iFindColZero}
								End if 
							End if 
							
							
							If (Length:C16(_prli_aBrk_FontName{_prli_iFindArea}{$_prli_iFindBrkCol})>0)
								$_prli_FontName:=_prli_aBrk_FontName{_prli_iFindArea}{$_prli_iFindBrkCol}
							End if 
							If (_prli_aBrk_FontSize{_prli_iFindArea}{$_prli_iFindBrkCol}#0)
								$_prli_iFontSize:=_prli_aBrk_FontSize{_prli_iFindArea}{$_prli_iFindBrkCol}
							End if 
							If (_prli_aBrk_FontStyle{_prli_iFindArea}{$_prli_iFindBrkCol}#-1)
								$_prli_iFontStyle:=_prli_aBrk_FontStyle{_prli_iFindArea}{$_prli_iFindBrkCol}
							End if 
							
							
							If (Length:C16($_prli_FontName)=0)
								If (_prli_iPlatform=Mac OS:K25:2)
									$_prli_FontName:="Arial"  // "Geneva"
								Else 
									$_prli_FontName:="Arial"
								End if 
							End if 
							
							If ($_prli_iFontSize=0)
								$_prli_iFontSize:=9
							End if 
							
							If ($_prli_iFontStyle=-1)
								$_prli_iFontStyle:=0
							End if 
							
							_prli_aBreakColumnStylSht{$_prli_iPrintCol}:=_prli_Util_GetStyleSheetID($_prli_FontName; $_prli_iFontSize; $_prli_iFontStyle)
							
							//--------------------------------
							
							$_prli_Format:=_prli_aFormat{_prli_iFindArea}{$_prli_iPrintCol}
							If (Length:C16($_prli_Format)=0)
								If ($_prli_iColType=Real array:K8:17)
									$_prli_Format:="#,###,###,##0.00"
								End if 
							End if 
							
							//--------------------------------------    
							//Calculate Count, Sum, Min, Max for the break.
							C_LONGINT:C283(_prli_BreakCount)
							C_REAL:C285($_prli_iBreakSum; _prli_BreakMin; _prli_BreakMax)
							_prli_BreakCount:=0
							$_prli_iBreakSum:=0
							_prli_BreakMin:=0
							_prli_BreakMax:=0
							$_prli_iSizeArray:=0
							If ($_prli_iColType=Integer array:K8:18) | ($_prli_iColType=LongInt array:K8:19) | ($_prli_iColType=Real array:K8:17)
								$_prli_iSizeArray:=Size of array:C274($_prli_pColumnArray->)
								If ($_prli_iSizeArray>=$_prli_iBeginRow)
									_prli_BreakMin:=$_prli_pColumnArray->{$_prli_iBeginRow}
								End if 
								_prli_BreakMax:=_prli_BreakMin
							End if 
							For ($_prli_iSumCtr; $_prli_iBeginRow; $_prli_iEndRow)
								_prli_BreakCount:=_prli_BreakCount+1
								If ($_prli_iSumCtr<=$_prli_iSizeArray)
									If (($_prli_iColType=Integer array:K8:18) | ($_prli_iColType=LongInt array:K8:19) | ($_prli_iColType=Real array:K8:17))
										$_prli_iBreakSum:=$_prli_iBreakSum+$_prli_pColumnArray->{$_prli_iSumCtr}
										If (_prli_BreakMin<$_prli_pColumnArray->{$_prli_iSumCtr})
											_prli_BreakMin:=$_prli_pColumnArray->{$_prli_iSumCtr}
										End if 
										If (_prli_BreakMax>$_prli_pColumnArray->{$_prli_iSumCtr})
											_prli_BreakMax:=$_prli_pColumnArray->{$_prli_iSumCtr}
										End if 
									End if 
								End if 
							End for 
							
							If ($_prli_iColType=Integer array:K8:18) | ($_prli_iColType=LongInt array:K8:19)
								$_prli_iBreakSum:=Round:C94($_prli_iBreakSum; 0)
								_prli_BreakMin:=Round:C94(_prli_BreakMin; 0)
								_prli_BreakMax:=Round:C94(_prli_BreakMax; 0)
							End if 
							//--------------------------------------
							
							
							//Sum,Average,Minimum,Maximum,Count,BreakValue,Function
							
							
							If (True:C214)
								If (($_prli_iColType=Integer array:K8:18) | ($_prli_iColType=LongInt array:K8:19) | ($_prli_iColType=Real array:K8:17))
									//11/20/06: Put this on hold: We may have a break column of a different
									//  data type than the column it's self: This could spell trouble.              
									$_prli_BrkText:=_prli_Util_PrintBreaks_Fmt($_prli_BrkText; $_prli_Bkslash+"SUM"; $_prli_iBreakSum; $_prli_Format)
									If (_prli_BreakCount=0)
										$_prli_BrkText:=_prli_Util_PrintBreaks_Fmt($_prli_BrkText; $_prli_Bkslash+"Average"; 0; $_prli_Format)
									Else 
										$_prli_BrkText:=_prli_Util_PrintBreaks_Fmt($_prli_BrkText; $_prli_Bkslash+"Average"; $_prli_iBreakSum/_prli_BreakCount; $_prli_Format)
									End if 
									$_prli_BrkText:=_prli_Util_PrintBreaks_Fmt($_prli_BrkText; $_prli_Bkslash+"Minimum"; _prli_BreakMin; $_prli_Format)
									$_prli_BrkText:=_prli_Util_PrintBreaks_Fmt($_prli_BrkText; $_prli_Bkslash+"Maximum"; _prli_BreakMax; $_prli_Format)
								End if 
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"Count"; String:C10(_prli_BreakCount))
							Else 
								
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"SUM"; String:C10($_prli_iBreakSum; $_prli_Format))
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"Average"; String:C10($_prli_iBreakSum/_prli_BreakCount; $_prli_Format))
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"Minimum"; String:C10(_prli_BreakMin; $_prli_Format))
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"Maximum"; String:C10(_prli_BreakMax; $_prli_Format))
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"Count"; String:C10(_prli_BreakCount))
							End if 
							
							$_prli_BrkValText:=""  //Break Level Zero: No Breaking array
							Case of 
								: (_prli_BreakLevel=0)
									
								: ($_prli_iBrkValueType=-1)  //Nil array, perhaps column zero.
									
								: (Size of array:C274($_prli_pBrkArray->)<_prli_iPrintingRow)  //Protect against bad code: This should NOT happen.
									
								: ($_prli_iBrkValueType=Integer array:K8:18) | ($_prli_iBrkValueType=LongInt array:K8:19)
									$_prli_BrkValText:=String:C10($_prli_pBrkArray->{_prli_iPrintingRow}; $_prli_Format)
									
								: ($_prli_iBrkValueType=Real array:K8:17)
									$_prli_BrkValText:=String:C10($_prli_pBrkArray->{_prli_iPrintingRow}; $_prli_Format)
									
								: ($_prli_iBrkValueType=Date array:K8:20)
									$_prli_BrkValText:=_prli_Util_DateString($_prli_pBrkArray->{_prli_iPrintingRow}; $_prli_Format)
									
								: ($_prli_iBrkValueType=String array:K8:15) | ($_prli_iBrkValueType=Text array:K8:16)
									$_prli_BrkValText:=$_prli_pBrkArray->{_prli_iPrintingRow}
									
							End case 
							$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"BreakValue"; $_prli_BrkValText)
							
							If (Position:C15($_prli_Bkslash+"Function"; $_prli_BrkText)>0)
								
								If (_prli_bHdrBreak)
									$_prli_MethodName:=_prli_aBreakHdrFunction{_prli_iFindArea}
								Else 
									$_prli_MethodName:=_prli_aBreakFunction{_prli_iFindArea}
								End if 
								
								If (Length:C16($_prli_MethodName)>0)
									//BrkLevel;Column;Format;StartRow;EndRow
									
									C_TEXT:C284(_prli_UtilityText)
									_prli_UtilityText:=""
									$_prli_UtilVarName:=_prli_Util_PtrName(->_prli_UtilityText)
									$_prli_String:=$_prli_UtilVarName+":="+$_prli_MethodName+"("+String:C10(_prli_BreakLevel)+";"+String:C10($_prli_iPrintCol)+";"+Char:C90(34)+$_prli_Format+Char:C90(34)+";"+String:C10($_prli_iBeginRow)+";"+String:C10($_prli_iEndRow)+")"
									
									_prli_Util_Execute($_prli_String; $_prli_MethodName)
									
									$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"Function"; _prli_UtilityText)
									_prli_UtilityText:=""
									
								End if 
							End if 
							
							
							If (Position:C15($_prli_Bkslash+"FirstValue"; $_prli_BrkText)>0)
								$_prli_FirstValueTxt:=""
								Case of 
									: (Size of array:C274($_prli_pColumnArray->)<$_prli_iBeginRow)  //Protect against bad code: This should NOT happen.
										
									: ($_prli_iColType=Integer array:K8:18) | ($_prli_iColType=LongInt array:K8:19)
										$_prli_FirstValueTxt:=String:C10($_prli_pColumnArray->{$_prli_iBeginRow})
										
									: ($_prli_iColType=Real array:K8:17)
										$_prli_FirstValueTxt:=String:C10($_prli_pColumnArray->{$_prli_iBeginRow}; $_prli_Format)
										
									: ($_prli_iColType=Date array:K8:20)
										$_prli_FirstValueTxt:=_prli_Util_DateString($_prli_pColumnArray->{$_prli_iBeginRow}; ($_prli_Format))
										
									: ($_prli_iColType=String array:K8:15) | ($_prli_iColType=Text array:K8:16)
										$_prli_FirstValueTxt:=$_prli_pColumnArray->{$_prli_iBeginRow}
										
								End case 
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"FirstValue"; $_prli_FirstValueTxt)
							End if 
							
							
							If (Position:C15($_prli_Bkslash+"LastValue"; $_prli_BrkText)>0)
								$_prli_LastValueTxt:=""
								Case of 
									: (Size of array:C274($_prli_pColumnArray->)<$_prli_iEndRow)  //Protect against bad code: This should NOT happen.
										
									: ($_prli_iColType=Integer array:K8:18) | ($_prli_iColType=LongInt array:K8:19)
										$_prli_LastValueTxt:=String:C10($_prli_pColumnArray->{$_prli_iEndRow})
										
									: ($_prli_iColType=Real array:K8:17)
										$_prli_LastValueTxt:=String:C10($_prli_pColumnArray->{$_prli_iEndRow}; $_prli_Format)
										
									: ($_prli_iColType=Date array:K8:20)
										$_prli_LastValueTxt:=_prli_Util_DateString($_prli_pColumnArray->{$_prli_iEndRow}; ($_prli_Format))
										
									: ($_prli_iColType=String array:K8:15) | ($_prli_iColType=Text array:K8:16)
										$_prli_LastValueTxt:=$_prli_pColumnArray->{$_prli_iEndRow}
										
								End case 
								$_prli_BrkText:=Replace string:C233($_prli_BrkText; $_prli_Bkslash+"LastValue"; $_prli_LastValueTxt)
							End if 
							
							
							_prli_aBreakColumnText{$_prli_iPrintCol}:=$_prli_BrkText
							
							
							If ($_prli_iNumBrkLines=0)
								//Calculate the number of lines of text          
								If ($_prli_iColType=Integer array:K8:18) | ($_prli_iColType=LongInt array:K8:19) | ($_prli_iColType=Real array:K8:17)
									$_prli_iJustify:=3
								Else 
									$_prli_iJustify:=1
								End if 
								
								If (_prli_aColJust{_prli_iFindArea}{$_prli_iPrintCol}#0)
									$_prli_iJustify:=_prli_aColJust{_prli_iFindArea}{$_prli_iPrintCol}
								End if 
								
								If ($_prli_iOverFlowCols>0)
									Case of 
										: ($_prli_iJustify=1)  //Left
											$_prli_iLeftCol:=$_prli_iPrintCol
											$_prli_iRightCol:=$_prli_iPrintCol+$_prli_iOverFlowCols
											
										: ($_prli_iJustify=2)  //Center
											$_prli_iLeftCol:=$_prli_iPrintCol-$_prli_iOverFlowCols
											$_prli_iRightCol:=$_prli_iPrintCol+$_prli_iOverFlowCols
											
										: ($_prli_iJustify=3)  //Right
											$_prli_iLeftCol:=$_prli_iPrintCol-$_prli_iOverFlowCols
											$_prli_iRightCol:=$_prli_iPrintCol
											
									End case 
									
									If ($_prli_iLeftCol<1)
										$_prli_iLeftCol:=1
									End if 
									If ($_prli_iRightCol>_prli_iVisibleCols)
										$_prli_iRightCol:=_prli_iVisibleCols
									End if 
									$_prli_iLeftSpace:=0
									$_prli_iTotalWidth:=0
									For ($_prli_iWidthCtr; $_prli_iLeftCol; $_prli_iRightCol)
										If (_prli_aWidth{_prli_iFindArea}{$_prli_iWidthCtr}>0)  //-1 = hide column
											If ($_prli_iWidthCtr<$_prli_iLeftCol)
												$_prli_iLeftSpace:=$_prli_iLeftSpace+_prli_aWidth{_prli_iFindArea}{$_prli_iWidthCtr}
											Else 
												$_prli_iTotalWidth:=$_prli_iTotalWidth+_prli_aWidth{_prli_iFindArea}{$_prli_iWidthCtr}
											End if 
										End if 
									End for 
									
								Else 
									$_prli_iLeftSpace:=0
									For ($_prli_iWidthCtr; 1; $_prli_iPrintCol-1)
										If (_prli_aWidth{_prli_iFindArea}{$_prli_iWidthCtr}>-1)
											$_prli_iLeftSpace:=$_prli_iLeftSpace+_prli_aWidth{_prli_iFindArea}{$_prli_iWidthCtr}
										End if 
									End for 
									If (_prli_aWidth{_prli_iFindArea}{$_prli_iPrintCol}=-1)
										$_prli_iTotalWidth:=0
									Else 
										$_prli_iTotalWidth:=_prli_aWidth{_prli_iFindArea}{$_prli_iPrintCol}
									End if 
								End if   //($iOverFlowCols>0)
								
								If (_prli_aBrk_ShowColDivider{_prli_iFindArea}{$_prli_iFindBrkCol})
									$_prli_iTotalWidth:=$_prli_iTotalWidth-1
								End if 
								
								
								
								Case of 
									: ($_prli_iLeftSpace-1>=_prli_iAreaWidth)  //Is this cell completly out of the printable bounds?
										$_prli_iTotalWidth:=0
										
									: ($_prli_iLeftSpace+$_prli_iTotalWidth-1>=_prli_iAreaWidth)  //Is the cell extending beyond printable bounds?
										$_prli_iTotalWidth:=_prli_iAreaWidth-$_prli_iLeftSpace  //If so, make it narrower
										
								End case 
								
								If ($_prli_iTotalWidth>1)
									$_prli_CountLines:=_prli_Util_CountLines($_prli_BrkText; $_prli_iTotalWidth; $_prli_FontName; $_prli_iFontSize; $_prli_iFontStyle)
									
								Else 
									$_prli_CountLines:=0
								End if 
								
							Else 
								$_prli_CountLines:=$_prli_iNumBrkLines
							End if   //($iNumBrkLines=0)
							
							$_prli_iFontHeight:=_prli_Util_GetFontHeight($_prli_FontName; $_prli_iFontSize)
							$_prli_iHeight:=$_prli_CountLines*$_prli_iFontHeight
							If ($_prli_iHeight>$_prli_iMaxTextHeight)
								$_prli_iMaxTextHeight:=$_prli_iHeight
							End if 
							
						End if   //(_prli_Util_IsAnArray ($pColumnArray))
					End if   //(($iPrintCol>0) & ($iPrintCol<=_prli_iVisibleCols))
				End if   //((a_prli_Brk_LevCol{_prli_iFindArea}{$iFindBrkCol}\512=_prli_BreakLevel) & $bHdrFooter)
			End for   //$iFindBrkCol
			
			_prli_Util_PrintPageBreak(0; $_prli_iMaxTextHeight+1)  //Add one (slop) pixel for a possible break row divider
			
			If (True:C214)
				//See Also: _prli_Util_PrintBreaksInForm
				_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; $_prli_iMaxTextHeight+_prli_iBrkPadHeight; _prli_iCountPagesDontPrint; "Break")
				//Print for break level _prli_BreakLevel
			End if 
			
			ARRAY TEXT:C222(_prli_aBreakColumnText; 0)
			ARRAY INTEGER:C220(_prli_aBreakColumnStylSht; 0)
			
		End if   //$PrintThisBreak
		
		
		If (Not:C34(_prli_bHdrBreak))
			//HAS THE DEVELOPER CONFIGURED A PAGE BREAK AT THIS LEVEL?
			$_prli_iFindPageBreak:=Find in array:C230(_prli_aPageBreakLevel{_prli_iFindArea}; _prli_BreakLevel)
			If ($_prli_iFindPageBreak>-1)
				
				$_prli_PrintThePageBreak:=True:C214
				If (_prli_iPrintingRow>=_prli_iRowCount)  //Are we at the end of the report?
					//Find out if we will be printing any other break at any level closer to zero.
					//  If we will not be printing any other break, then SKIP this page break.
					$_prli_PrintThePageBreak:=False:C215
					
					If (_prli_aPrintLastPageBreak{_prli_iFindArea}=1)  //Has the developer configured to force the page break on the end of the report?
						
						For ($_prli_iTestBrkLevelCtr; _prli_BreakLevel-1; 0; -1)
							$_prli_PrintThisBreak:=False:C215
							For ($_prli_iFindBrkCol; 1; Size of array:C274(_prli_aBrk_LevCol{_prli_iFindArea}))
								If (_prli_aBrk_LevCol{_prli_iFindArea}{$_prli_iFindBrkCol}\512=$_prli_iTestBrkLevelCtr)  //Right Break Level & Not a Hdr Brk
									If (Length:C16(_prli_aBrk_Text{_prli_iFindArea}{$_prli_iFindBrkCol})>0)  //Is there actually something to print?
										If ((_prli_aBrk_LevCol{_prli_iFindArea}{$_prli_iFindBrkCol} ?? 8)=False:C215)  //Is this a Footer Break (vs a header brk)?
											$_prli_PrintThePageBreak:=True:C214
											$_prli_iFindBrkCol:=10000000  //exit this loop
										End if 
									End if 
								End if 
							End for 
						End for 
						
					End if   // (a_prli_PrintLastPageBreak{_prli_iFindArea}=1)
					
				End if   //(_prli_iPrintingRow>=_prli_iRowCount)
				
				If ($_prli_PrintThePageBreak)
					_prli_Util_PrintPageBreak(0; _prli_iPageHeight)  //Force a page break right now
				End if   //$PrintThePageBreak
				
			End if   //($iFindPageBreak>-1)
		End if   //not(_prli_bHdrBreak)      
		
		
	End for   //_prli_BreakLevel
	
	
	//Moved to _prli_Util_PrintBreakDividers
	If ($_prli_AnyBreakPrinted)
		If (_prli_bHdrBreak)
			
			//Header Breaks
			
			If (_prli_aDiv_Row_Width{_prli_iFindArea}>0)
				//See Also: _prli_Util_PrintBreaksInForm
				_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; 1; _prli_iCountPagesDontPrint; "RowDivider")
			End if 
			
		Else 
			
			//Footer Breaks
			
		End if   //_prli_bHdrBreak
	End if   //$AnyBreakPrinted
	
End if 
