//%attributes = {}
//_prli_Util_PrintPageBreak(Opts;IfEnoughSpaceForPixels)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//FUNCTION
//When printing stuff, IF we are about to run out of space on the current
//  page to print the next thing, then print a Report Form Footer,
//  a Page Break, the next header, and a possible PrintArea Header

//Rev: 08/21/03: Fixed a range bug

C_LONGINT:C283($1; $_prli_opts; $2; $_prli_iAboutToPrintPixels; $_prli_iFrameHeight; $_prli_iBlankSpace; $_prli_iFooterHeight; $_prli_iOverflow)
$_prli_opts:=$1
$_prli_iAboutToPrintPixels:=$2

$_prli_iFooterHeight:=_prli_iFooterCoord-_prli_Break0

$_prli_iFrameHeight:=0
If (_prli_iFindArea>-1)
	If (_prli_aFrame_Width{_prli_iFindArea}>0)
		$_prli_iFrameHeight:=1
	End if 
End if 

If ((_prli_iPageHeight-$_prli_iFooterHeight-_prli_iGetPrintedHeight-$_prli_iFrameHeight)<$_prli_iAboutToPrintPixels)
	
	If (_prli_iFindArea>-1)
		If (_prli_aFrame_Width{_prli_iFindArea}>0)
			//See Also: _prli_ObjectsFormMethod
			_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; 1; _prli_iCountPagesDontPrint; "BottomFrame")
		End if 
	End if 
	
	
	$_prli_iBlankSpace:=_prli_iPageHeight-$_prli_iFooterHeight-_prli_iGetPrintedHeight
	_prli_Util_PrintBlankSpace($_prli_iBlankSpace-$_prli_iFooterHeight)
	
	
	If ($_prli_iFooterHeight>0) & (Length:C16(_prli_HostFormName)>0)
		$_prli_iOverflow:=-(_prli_iPageHeight-_prli_iGetPrintedHeight-$_prli_iFooterHeight)  //If all has gone right, Overflow will be EXACTLY zero.
		If ($_prli_iOverflow>0)
			//An error has happened.  We have printed too far.  We will now trim off the 
			//  top of the footer to compensate.
			//Most likely, Overflow is one pixel: we need to improve our calculation when
			//   frames exist.
		End if 
		_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; _prli_Break0+$_prli_iOverflow; _prli_iFooterCoord; _prli_iCountPagesDontPrint; "Footer")
	End if 
	
	If (_prli_iCountPagesDontPrint#1)
		$_prli_PrevErrorMethod:=Method called on error:C704
		error:=0
		ON ERR CALL:C155("_prli_Util_Pass")
		PAGE BREAK:C6(>)
		If (error#0)
			_prli_UserCancelPrint:=True:C214
		End if 
		error:=0
		ON ERR CALL:C155($_prli_PrevErrorMethod)
	End if 
	
	If (_prli_iFindArea>-1)  //08/21/2003
		If (Length:C16(_prli_aPageProc{_prli_iFindArea})>0)
			$_prli_String:=_prli_aPageProc{_prli_iFindArea}+"("+String:C10(_prli_AreaRef)+";"+String:C10(_prli_iLastRowPrinted)+")"
			_prli_Util_Execute($_prli_String; _prli_aPageProc{_prli_iFindArea})
		End if 
	End if 
	
	_prli_iGetPrintedHeight:=0
	_prli_iRowsPrintedThisPage:=0
	_prli_iPrintingPage:=_prli_iPrintingPage+1
	
	If (_prli_UserCancelPrint=False:C215)
		If (_prli_iFormHdrCoord>0) & (Length:C16(_prli_HostFormName)>0)
			_prli_Util_PrintForm(_prli_pHostFormTable; _prli_HostFormName; 0; _prli_iFormHdrCoord; _prli_iCountPagesDontPrint; "Header")
		End if 
		
		If (_prli_iFindArea>-1)
			
			If (_prli_aFrame_Width{_prli_iFindArea}>0)
				//See Also: _prli_ObjectsFormMethod
				_prli_Util_PrintForm(<>_prli_pObjectsFormTable; _prli_ObjectsFormName; 0; 1; _prli_iCountPagesDontPrint; "TopFrame")
			End if 
			
			
			If (_prli_aPrintHeaders{_prli_iFindArea}=2)
				_prli_Util_PrintAreaHdr
			End if 
		End if 
	End if   //(_prli_UserCancelPrint=false)    
	
End if 
