//%attributes = {}
// Method: _rct_BlobSend 
// 26.04.12, 19:22:24 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// _tcp_ BlobSend
// see: _rct_BLOB_SEND, _rct_BlobReceive, _rc_ CALL -> ,_rc_OnePacketReceive, _tcp_ BlobSend, _tcp_ BlobReceive, _zmq_ BlobSend, _zmq_ BlobReceive
// ------------------------------------------------------------
If (<>_rc_fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 
C_POINTER:C301($1; $_rc_pBlob)
C_LONGINT:C283($0; $2; $_rc_lBytesSentTotal; $3; $_rc_lBytesToSend; $_rc_lBytesSentTotalPrev; $_rc_lLoopCount; $_rc_lErr)
C_LONGINT:C283($_rc_lBytesLeftToCopy; $_rc_lTimeout)

//COMPILER__tcp_, COMPILER__tcp_ip, COMPILER__rc_

$_rc_pBlob:=$1
$_rc_lBytesSentTotal:=$2  // = send offset at the same time
$_rc_lBytesToSend:=$3  //BLOB size($_rc_pBlob->)  // usually BLOB size($_rc_pBlob->)
$_rc_lTimeout:=Milliseconds:C459+<>_rc_lBlobSendTimeoutMs
$_rc_lLoopCount:=0

Repeat 
	
	$_rc_lBytesSentTotalPrev:=$_rc_lBytesSentTotal
	$_rc_lBytesLeftToCopy:=$_rc_lBytesToSend-$_rc_lBytesSentTotal
	If ($_rc_lBytesLeftToCopy<1)
		_err MESSAGE(_lang Current("No bytes to send")+": "+String:C10($_rc_lBytesLeftToCopy); Current method name:C684; kFalse)
	End if 
	
	If (<>_rc_fProfile)
		_info_ CALL_PROFILE(kStart; Current method name:C684+": MA_TCP_SendBlob")
	End if 
	//TRACE
	$_rc_lErr:=MA_TCP_SendBlob(_rc_lSocket; $_rc_pBlob->; $_rc_lBytesSentTotal; $_rc_lBytesLeftToCopy)  // $_rc_lBytesSentTotal = send offset at the same time, will grow
	If (<>_rc_fProfile)
		_info_ CALL_PROFILE(kStop; Current method name:C684+": MA_TCP_SendBlob")
	End if 
	$_rc_lLoopCount:=$_rc_lLoopCount+1  // just for trace
	
	Case of 
		: ($_rc_lErr>=0)  // $_rc_lErr>=0, nothing or something sent, ok
			// IDLE
		: ($_rc_lErr=-730035)  // 730035: A non-blocking socket operation could not be completed immediately.
			$_rc_lErr:=0  // do resend until timeup
		: ($_rc_lErr=-70007)
			$_rc_lErr:=0  // do resend until timeup
		: ($_rc_lErr=-35)  // resouce temporarily unavailable = send again
			$_rc_lErr:=0  // do resend until timeup
			//_rct_TCP_ERROR (_rc_lSocket;$_rc_lErr;"MA_TCP_SendBlob";Current method name)  // is this needed?
		Else   // : ($_rc_lErr<0)  //real error
			_rct_TCP_ERROR(_rc_lSocket; $_rc_lErr; "MA_TCP_SendBlob"; Current method name:C684)
	End case 
	
	Case of 
		: ($_rc_lBytesSentTotal>=$_rc_lBytesToSend)
			// all ok, exit now without delay
		: ($_rc_lBytesSentTotal>$_rc_lBytesSentTotalPrev)  // something sent
			$_rc_lTimeout:=Milliseconds:C459+<>_rc_lBlobSendTimeoutMs
			IDLE:C311
		Else   // nothing was sent on this loop, do resend until timeup
			DELAY PROCESS:C323(Current process:C322; 0)  // delay a little
	End case 
	
Until (($_rc_lErr<0) | ($_rc_lBytesSentTotal>=$_rc_lBytesToSend) | (Milliseconds:C459>$_rc_lTimeout))

//If ($_rc_lLoopCount>50)
//If (_usr Designer =kTrue)
//C_TEXT($_rc_tPlgError)
//$_rc_tPlgError:=MA_TCP_GetLastErrorText (_rc_lSocket)
//_err MESSAGE ("_rct_BlobSend done in many loops: "+String($_rc_lLoopCount)+" loops / "+String($_rc_lBytesToSend;"|byte")+", error: "+$_rc_tPlgError;Current method name;kFalse)
//End if 
//End if 

$0:=$_rc_lBytesSentTotal
Case of 
	: ($_rc_lBytesSentTotal=$_rc_lBytesToSend)
		// all ok!
	: ($_rc_lBytesSentTotal>$_rc_lBytesToSend)
		_err MESSAGE(_lang Current("Bytes sent was more than blob size"); Current method name:C684; kFalse)
		_rct_TCP_ERROR(_rc_lSocket; $_rc_lErr; "MA_TCP_SendBlob"; Current method name:C684)
	: (($_rc_lBytesSentTotal<$_rc_lBytesToSend) & ($_rc_lErr<0))
		_err MESSAGE(_lang Current("Bytes sent was less than blob size"); Current method name:C684; kFalse)
		_rct_TCP_ERROR(_rc_lSocket; $_rc_lErr; "MA_TCP_SendBlob"; Current method name:C684)
		$0:=$_rc_lErr
	: (($_rc_lBytesSentTotal<$_rc_lBytesToSend) & (Milliseconds:C459>$_rc_lTimeout))
		_err MESSAGE(_lang Current("Send timeout, bytes sent was less than blob size"); Current method name:C684; kFalse)
	Else 
		TRACE:C157  // ?
		$0:=$_rc_lBytesSentTotal
End case 

If (<>_rc_fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 