//%attributes = {"publishedSql":true}
// Method: _sql_4D_TBL_STRUCT_CREATE
// 2005.12.28-00:58:47 / Pasi Mankinen
// © Copyright 2005 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

COMPILER__sql_

// (PM) PgSQL_CreateTable
// Creates a PostgreSQL table from a 4D table
// $1 = _sql_connection
// $2 = Table pointer

C_LONGINT:C283($1; $Connection_vl; $TableNr_vl; $FieldNr_vl; $FieldType_vl; $FieldLength_vl; $Result_vl)
C_POINTER:C301($2; $Table_vp; $Field_vp)
C_BOOLEAN:C305($Indexed_vb; $Unique_vb)
C_TEXT:C284($TableName_vt; $FieldName_vt; $SQL_vt; $Keys_vt; $Index_vt)
ARRAY TEXT:C222($Indices_at; 0)

If (False:C215)
	$Connection_vl:=$1
	$Table_vp:=$2
	$TableNr_vl:=Table:C252($Table_vp)
	
	// Table names and fieldnames are case-sensitive in PostgreSQL, so we convert to l
	$TableName_vt:=_str_ ToLower(Table name:C256($Table_vp))
	
	$SQL_vt:="CREATE TABLE public."+$TableName_vt+" ("+Char:C90(Carriage return:K15:38)  //or: CREATE TABLE "public"."tbl name" (
	$Keys_vt:=""
	
	// Loop through the fields
	For ($FieldNr_vl; 1; Get last field number:C255($Table_vp))
		
		$Field_vp:=Field:C253($TableNr_vl; $FieldNr_vl)
		$FieldName_vt:=_str_ ToLower(Field name:C257($Field_vp))
		GET FIELD PROPERTIES:C258($Field_vp; $FieldType_vl; $FieldLength_vl; $Indexed_vb; $Unique_vb)
		
		// Create the SQL depending on the field type
		$SQL_vt:=$SQL_vt+Char:C90(Double quote:K15:41)+$FieldName_vt+Char:C90(Double quote:K15:41)
		Case of 
			: ($FieldType_vl=Is alpha field:K8:1)
				$SQL_vt:=$SQL_vt+" varchar("+String:C10($FieldLength_vl)+") NOT NULL default '', "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is text:K8:3)
				$SQL_vt:=$SQL_vt+" text NOT NULL default '', "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is boolean:K8:9)
				$SQL_vt:=$SQL_vt+" boolean NOT NULL default '0', "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is integer:K8:5)
				$SQL_vt:=$SQL_vt+" smallint NOT NULL default 0, "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is longint:K8:6)
				$SQL_vt:=$SQL_vt+" integer NOT NULL default 0, "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is real:K8:4)
				$SQL_vt:=$SQL_vt+" double precision NOT NULL default 0, "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is date:K8:7)
				$SQL_vt:=$SQL_vt+" date, "+Char:C90(Carriage return:K15:38)
				// PostgreSQL does not support dates like !00-00-00!
				// (which the plugin treats as NULL)
			: ($FieldType_vl=Is time:K8:8)
				$SQL_vt:=$SQL_vt+" time NOT NULL default '00:00:00', "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is picture:K8:10)
				$SQL_vt:=$SQL_vt+" bytea, "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is BLOB:K8:12)
				$SQL_vt:=$SQL_vt+" bytea, "+Char:C90(Carriage return:K15:38)
			: ($FieldType_vl=Is subtable:K8:11)
				//$SQL_vt:=$SQL_vt+" bytea, "+Char(Carriage return )
		End case 
		
		// Add the keys (indices)
		Case of 
			: ($Unique_vb & (Position:C15("PRIMARY KEY"; $Keys_vt)=0))  // Assume the first unique field is the primary key
				$Keys_vt:=$Keys_vt+"PRIMARY KEY ("+$FieldName_vt+"), "+Char:C90(Carriage return:K15:38)
			: ($Unique_vb)
				$Keys_vt:=$Keys_vt+"UNIQUE ("+$FieldName_vt+"), "+Char:C90(Carriage return:K15:38)
			: ($Indexed_vb)
				$Index_vt:="CREATE INDEX "+$TableName_vt+"_"+$FieldName_vt+" ON "+$TableName_vt+" ("+$FieldName_vt+")"
				//APPEND TO ARRAY($Indices_at;$Index_vt)
		End case 
		
	End for 
	
	// Finish the statement
	$SQL_vt:=$SQL_vt+$Keys_vt
	$SQL_vt:=Substring:C12($SQL_vt; 1; Length:C16($SQL_vt)-3)
	$SQL_vt:=$SQL_vt+Char:C90(Carriage return:K15:38)+")"
	
	// $Result_vl:=_sql_Execute ($Connection_vl;"DROP TABLE \""+$TableName_vt+"\"")
	
	// Create the new table
	$Result_vl:=_sql_ DirectCursorExecute($Connection_vl; $SQL_vt)
	
	// Create the indices
	For ($Index_vl; 1; Size of array:C274($Indices_at))
		$Index_vt:=$Indices_at{$Index_vl}
		$Result_vl:=_sql_ DirectCursorExecute($Connection_vl; $Index_vt)
	End for 
	
End if 
