//%attributes = {"publishedSql":true}
// Method: _sql_4D_TBL_TO_SQL_COPY
// 2005.12.28-00:55:30 / Pasi Mankinen
// © Copyright 2005 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------

// (PM) // PgSQL_CloneDatabase
// Clones all records of all tables to a PostgreSQL database
// $1 = PostgreSQL connection
// (PM) // PgSQL_CloneTable
// Clones all records from a single table to a PostgreSQL database
// $1 = // PgSQL connection
// $2 = Table pointer

C_LONGINT:C283($1; $Connection_vl; $TableNr_vl; $FieldNr_vl; $Statement_vl; $Record_vl; $RecordCount_vl; $FieldType_vl; $Result_vl)
C_POINTER:C301($2; $Table_vp; $Field_vp)
C_TEXT:C284($TableName_vt; $FieldName_vt; $SQL_vt)

$Connection_vl:=$1
$Table_vp:=$2
$TableNr_vl:=Table:C252($Table_vp)
$TableName_vt:=_str_ ToLower(_sql_TblFldNameClean(Table name:C256($Table_vp)))

// Build the insert statement for this table
$SQL_vt:="INSERT INTO "+$TableName_vt+" ( "
For ($FieldNr_vl; 1; Get last field number:C255($Table_vp))
	$FieldName_vt:=_str_ ToLower(_sql_TblFldNameClean(Field name:C257($TableNr_vl; $FieldNr_vl)))
	$SQL_vt:=$SQL_vt+$FieldName_vt+", "
End for 

// Add the values clause
$SQL_vt:=Substring:C12($SQL_vt; 1; Length:C16($SQL_vt)-2)
$SQL_vt:=$SQL_vt+" ) VALUES ( "
$SQL_vt:=$SQL_vt+("?, "*Get last field number:C255($Table_vp))
$SQL_vt:=Substring:C12($SQL_vt; 1; Length:C16($SQL_vt)-2)
$SQL_vt:=$SQL_vt+" )"

// $Statement_vl:=// PgSQL New SQL Statement ($Connection_vl;$SQL_vt)

ALL RECORDS:C47($Table_vp->)
$RecordCount_vl:=Records in selection:C76($Table_vp->)

// Loop through all records
For ($Record_vl; 1; $RecordCount_vl)
	
	// Insert the field values in the SQL statement
	$FieldCount:=Get last field number:C255($Table_vp)
	For ($FieldNr_vl; 1; $FieldCount)
		
		$Field_vp:=Field:C253($TableNr_vl; $FieldNr_vl)
		GET FIELD PROPERTIES:C258($Field_vp; $FieldType_vl)
		
		Case of 
			: ($FieldType_vl=Is alpha field:K8:1)
				// PgSQL Set String In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is text:K8:3)
				// PgSQL Set Text In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is boolean:K8:9)
				// PgSQL Set Boolean In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is integer:K8:5)
				// PgSQL Set Integer In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is longint:K8:6)
				// PgSQL Set Longint In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is integer 64 bits:K8:25)
				TRACE:C157
				// PgSQL Set Longint In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is real:K8:4)
				// PgSQL Set Real In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is date:K8:7)
				// PgSQL Set Date In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is time:K8:8)
				// PgSQL Set Time In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is picture:K8:10)
				// PgSQL Set Picture In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is BLOB:K8:12)
				// PgSQL Set Blob In SQL ($Statement_vl;$FieldNr_vl;$Field_vp->)
			: ($FieldType_vl=Is subtable:K8:11)
				// PgSQL Set Text In SQL ($Statement_vl;$FieldNr_vl;"NULL")  // Not supported
		End case 
		
	End for 
	
	// Insert the record and move on to the next
	// $Result_vl:=PgSQL Execute ($Connection_vl;"";$Statement_vl)
	If ($Result_vl#1)
		TRACE:C157
		$Record_vl:=$RecordCount_vl+1  // exit failed table
	End if 
	NEXT RECORD:C51($Table_vp->)
	
End for 

// PgSQL Delete SQL Statement ($Statement_vl)
