//%attributes = {"publishedSql":true}
// Method: _tcp_SERVER_LISTENER - this is for NTK+MA_TCP plugin
// 2007.12.28-03:19:35 / Pasi Mankinen
// © Copyright 2007 Manage Applications
// Purpose: 
// This process listens for incoming connections and pass
// them to the "delivery" processes
// ------------------------------------------------------------
// - Keep-Alive support directly in HTTP_Master ???
// - _http__socket sleeping mode
// see also: _rem_SERVER_LISTENER_ZMQ, _rem_BIND_PRS, _tcp_SERVER_socket_HANDLER_ITK (old: _tcp_SERVER_LISTENER_ITK)
// called from:  _tcp_SERVER_START 
// ------------------------------------------------------------
_prs NEW_INIT


// _rem_ TRACE("method start";Current method name)

If (<>_tcp_lServerProfile=kTrue)
	If (<>_info_ fProfile)
		_info_ CALL_PROFILE(kStart; Current method name:C684+" - start")
	End if 
End if 

C_LONGINT:C283($_tcp_lIndex; $_tcp_lLoopCount; $_tcp_lStatus; $_tcp_lPrevStatus; $_tcp_lSmallDelay; $_tcp_lPrevSmallDelayTime)
C_LONGINT:C283($_tcp_lClientSocket; State; $_tcp_lSocketBufferSize; $_tcp_lSocketCount)
C_LONGINT:C283($_tcp_lCount; $_tcp_lNewIndex; $_tcp_lPort; $_tcp_lServerIndex)
C_TEXT:C284($_tcp_tStatus)

COMPILER__tcp_  // COMPILER__tcp_ip
COMPILER__rem_
_tcp_ PLUGIN_TYPE_SERVER_SET
//COMPILER__http_
_tcp_lReceiveTimeout:=<>_tcp_lReceiveTimeoutServer  //<>_tcp_lReceiveTimeout

If (<>_tcp_lListenerPrs#Current process:C322)
	TRACE:C157
End if 

// _rem_ TRACE("_rem_ PortNumToListen";Current method name)

_tcp_lRemotePort:=<>_tcp_lLocalPortNumToListenRem
If (_rem_ ServerType ?? 0x0000)
	_tcp_lRemSocketCount:=1
Else 
	_tcp_lRemSocketCount:=0
End if 
_tcp_lHttpSocketCount:=<>_tcp_lSocketCountHttp
$_tcp_lSocketCount:=_tcp_lRemSocketCount+_tcp_lHttpSocketCount

// _rem_ TRACE("_rem_ PortNumToListen after";Current method name)

If ($_tcp_lSocketCount>0)  // v12
	
	If (_tcp_lHttpSocketCount>0)
		<>_tcp_lLogPrs:=New process:C317("_http_SERVER_LOG"; _prs_kMemStack; "$_tcp_ServerLog"; *)
		//<>_tcp_lLogPrs:=New process("_http_SERVER_LOG";_prs_kMemStack;"_tcp_ServerLog";*)
		If (<>_tcp_lLogPrs<1)
			$_tcp_tMsg:=_lang Current("Tcp server log process could not be started")
			_err MESSAGE($_tcp_tMsg; Current method name:C684; kFalse)
		End if 
		
		<>_tcp_lLogSavePrs:=New process:C317("_http_SERVER_LOG_SAVE"; _prs_kMemStack; "$_tcp_ServerLogSave"; *)
		//<>_tcp_lLogSavePrs:=New process("_http_SERVER_LOG_SAVE";_prs_kMemStack;"_tcp_ServerLogSave";*)
		If (<>_tcp_lLogSavePrs<1)
			$_tcp_tMsg:=_lang Current("Tcp server log save process could not be started")
			_err MESSAGE($_tcp_tMsg; Current method name:C684; kFalse)
		End if 
	End if 
	
	// _rem_ TRACE("after If ($_tcp_lSocketCount>0) ";Current method name)
	
	If (_tcp_lHttpSocketCount>0)
		//start request handle processes
		_tcp_ tTcpPrsState:="starting http request handle processes"
		_tcp_lRequestPrsCount:=<>_tcp_lRequestPrsCount
		ARRAY LONGINT:C221(_tcp_alHttpHandlerPrs; 0)
		For ($_tcp_lIndex; 1; _tcp_lRequestPrsCount)  // Launch the delivery processes
			_tcp_SERVER_REQUEST_PRS_ADD
			DELAY PROCESS:C323(Current process:C322; 12)  // 0,2 sec, give new prs some time to launch
		End for 
	End if 
	
	_tcp_ tTcpPrsState:="starting listening socket"
	$_tcp_lSleep:=kFalse
	
	//start listening sockets
	If (_tcp_lHttpSocketCount>0)
		$_tcp_lPort:=<>_tcp_lLocalPortNumToListenHttp
		_tcp_SERVER_SOCKET_OPEN($_tcp_lPort)
	End if 
	
	If (_tcp_lRemSocketCount>0)
		$_tcp_lPort:=<>_tcp_lLocalPortNumToListenRem
		_tcp_SERVER_SOCKET_OPEN($_tcp_lPort)
	End if 
	
	_tcp_ SERVER_START_TIME_SET
	
	//wait all http request handler prs to start
	If (_tcp_lHttpSocketCount>0)
		$_tcp_lLoopCount:=0
		Repeat 
			$_tcp_lSmallDelay:=kFalse
			$_tcp_lLoopCount:=$_tcp_lLoopCount+1
			$_tcp_lCount:=Size of array:C274(_tcp_alHttpHandlerPrs)
			For ($_tcp_lIndex; 1; $_tcp_lCount)  //wait for the launch of delivery processes
				If (Process state:C330(_tcp_alHttpHandlerPrs{$_tcp_lIndex})#Paused:K13:6)
					_time WAIT(0.2)  //give new prs some time to launch
					$_tcp_lSmallDelay:=kTrue
				End if 
			End for 
		Until (($_tcp_lSmallDelay=kFalse) | ($_tcp_lLoopCount>=<>_tcp_lRequestWaitMaxLoop))
	End if 
	
	//main loop
	_tcp_ tTcpPrsState:="start main loop"
	$_tcp_lSmallDelay:=kTrue
	$_tcp_lPrevSmallDelayTime:=Tickcount:C458
	$_tcp_lResumeCloser:=kFalse  //update closer info - not in use?
	
	If (<>_tcp_lServerProfile=kTrue)
		If (<>_info_ fProfile)
			_info_ CALL_PROFILE(kStop; Current method name:C684+" - start")
		End if 
		If (<>_info_ fProfile)
			_info_ CALL_PROFILE(kStart; Current method name:C684+" - run")
		End if 
	End if 
	
	Repeat 
		
		// _rem_ TRACE("Repeat start, delays";Current method name)
		
		$_tcp_lSocketCount:=Size of array:C274(<>_tcp_pLastSocketArr->)
		If ($_tcp_lSocketCount>0)  // sleep
			$_tcp_lIndex:=1
			If ($_tcp_lSmallDelay=kTrue)
				_tcp_ tTcpPrsState:="delay small"
				<>_tcp_atSocketState{$_tcp_lIndex}:="listening: "+_tcp_ tTcpPrsState
				If (<>_tcp_lServerProfile=kTrue)
					If (<>_info_ fProfile)
						_info_ CALL_PROFILE(kStop; Current method name:C684+" - run")
					End if 
				End if 
				DELAY PROCESS:C323(Current process:C322; <>_tcp_lDelaySmall)  //delay
				If (<>_tcp_lServerProfile=kTrue)
					If (<>_info_ fProfile)
						_info_ CALL_PROFILE(kStart; Current method name:C684+" - run")
					End if 
				End if 
				$_tcp_lSmallDelay:=kFalse
				$_tcp_lPrevSmallDelayTime:=Tickcount:C458
			Else 
				If ((Tickcount:C458-$_tcp_lPrevSmallDelayTime)>=<>_tcp_lDelaySmallToNormal)  //>5 secs * 60 tics = 300 tics
					_tcp_ tTcpPrsState:="delay normal"
					<>_tcp_atSocketState{$_tcp_lIndex}:="listening: "+_tcp_ tTcpPrsState
					If (<>_tcp_lServerProfile=kTrue)
						If (<>_info_ fProfile)
							_info_ CALL_PROFILE(kStop; Current method name:C684+" - run")
						End if 
					End if 
					DELAY PROCESS:C323(Current process:C322; <>_tcp_lDelayNormal)  //delay    
					If (<>_tcp_lServerProfile=kTrue)
						If (<>_info_ fProfile)
							_info_ CALL_PROFILE(kStart; Current method name:C684+" - run")
						End if 
					End if 
				Else 
					_tcp_ tTcpPrsState:="delay small 2"
					<>_tcp_atSocketState{$_tcp_lIndex}:="listening: "+_tcp_ tTcpPrsState
					If (<>_tcp_lServerProfile=kTrue)
						If (<>_info_ fProfile)
							_info_ CALL_PROFILE(kStop; Current method name:C684+" - run")
						End if 
					End if 
					DELAY PROCESS:C323(Current process:C322; <>_tcp_lDelaySmall)  //delay      
					If (<>_tcp_lServerProfile=kTrue)
						If (<>_info_ fProfile)
							_info_ CALL_PROFILE(kStart; Current method name:C684+" - run")
						End if 
					End if 
				End if 
			End if 
		End if 
		
		// _rem_ TRACE("while loop start";Current method name)
		
		While (($_tcp_lIndex>0) & ($_tcp_lSocketCount>0) & (<>_tcp_lServerQuit#kTrue))  // We test the status of each socket
			
			Case of 
					//: ($_tcp_lIndex>Size of array(<>_tcp_pLastSocketArr->))
					//IDLE
					//: ($_tcp_lIndex>Size of array(<>_tcp_pFirstSocketArr->))
					//IDLE
				: (<>_tcp_alSocketType{$_tcp_lIndex}#1)  // 1=tcp, 2=zmq, 3=ops
					//IDLE
				Else 
					_tcp_lSocket:=<>_tcp_alSocket{$_tcp_lIndex}
					$_tcp_lStatus:=<>_tcp_alSocketStatus{$_tcp_lIndex}
					$_tcp_lPrevStatus:=$_tcp_lStatus
					If (<>_tcp_alSocketRequestPrs{$_tcp_lIndex}=<>_tcp_lListenerPrs)
						$_tcp_lStatus:=_tcp_ StatusGet(_tcp_lSocket)  // only listening server socket status
					Else 
						//$_tcp_lStatus:=_tcp_ StatusGet (_tcp_lSocket)  ` only serving or outgoing socket status
					End if 
					<>_tcp_alSocketStatus{$_tcp_lIndex}:=$_tcp_lStatus
					
					If (<>_tcp_alSocketPrevStatus{$_tcp_lIndex}#$_tcp_lStatus)
						If ($_tcp_lStatus>=0)
							<>_tcp_alSocketPrevStatus{$_tcp_lIndex}:=$_tcp_lStatus  //set server socket previous state      
						End if 
					End if 
					
					Case of   //-30, -20, -10 has been set in _tcp_ socket_CLOSE
							//: (<>_tcp_alSocketStatus{$_tcp_lIndex}=-5)  // http serveing prs want this to be closed   
							//$_tcp_lStatus:=_tcp_ StatusGet ($_tcp_lSocket)
							//If (_tcp_ CloseNeeded ($_tcp_lStatus)=kTrue)
							//_tcp_ SOCKET_CLOSE (_tcp_lSocket;Current method name)
							//<>_tcp_atSocketState{$_tcp_lIndex}:="needs closing"  //closed
							//Else 
							//<>_tcp_alSocketStatus{$_tcp_lIndex}:=-20
							//<>_tcp_atSocketState{$_tcp_lIndex}:="listener closed"  //closed
							//End if 
							
						: ($_tcp_lStatus=-30)  //TCP server listening socket closed       
							<>_tcp_atSocketState{$_tcp_lIndex}:="listening: closed"  //closed   
						: ($_tcp_lStatus=-20)  //TCP server serving socket closed in listener process
							<>_tcp_atSocketState{$_tcp_lIndex}:="serving: closed"  //closed       
						: ($_tcp_lStatus=-10)  //TCP server serving socket closed in some other than listener process         
							If (<>_tcp_alSocketRequestPrs{$_tcp_lIndex}<0)
								<>_tcp_atSocketState{$_tcp_lIndex}:="outgoing: closed"  //closed      
							Else 
								<>_tcp_atSocketState{$_tcp_lIndex}:="serving: closed"  //closed       
							End if 
						: ($_tcp_lStatus=0)  //TCP Connection Closed 
							//never remove socket array elements
							<>_tcp_atSocketState{$_tcp_lIndex}:="closed"
						: ($_tcp_lStatus=-1)  //TCP Connection Closed 
							//never remove socket array elements
							<>_tcp_atSocketState{$_tcp_lIndex}:="closed in serving process"
							
						: ($_tcp_lStatus=2)  //TCP Listening  
							If ((<>_tcp_alSocketRequestPrs{$_tcp_lIndex}#<>_tcp_lListenerPrs) & (<>_tcp_alSocketRequestPrs{$_tcp_lIndex}#0))
								//is a server socket (<>_tcp_lListenerPrs) or just opened socket (0)
								<>_tcp_alSocketRequestPrs{$_tcp_lIndex}:=<>_tcp_lListenerPrs
							Else 
								//handle server socket    
								Repeat 
									$_tcp_lClientSocket:=_tcp_ Accept(_tcp_lSocket)  // new connection coming?
									If ($_tcp_lClientSocket=0)
										IDLE:C311
										//no connection here, loop to next socket
										//comes always here for ITK
									Else   //for NTK add a new client socket, old one stays listening
										<>_tcp_atSocketState{$_tcp_lIndex}:="listening: add a new socket"
										$_tcp_lSmallDelay:=kTrue  //to handle next connection faster
										<>_tcp_alSocketHitCount{$_tcp_lIndex}:=<>_tcp_alSocketHitCount{$_tcp_lIndex}-1  // negative for server hits
										$_tcp_lNewIndex:=_tcp_ ServerSocketAdd($_tcp_lIndex; $_tcp_lClientSocket)  // will set status
										If ($_tcp_lNewIndex=$_tcp_lIndex)
											_err MESSAGE("_tcp_ ServerSocketAdd error"; Current method name:C684; kFalse)
										Else 
											If ($_tcp_lNewIndex>0)
												_tcp_SERVER_CONNECTED($_tcp_lNewIndex)
												If (($_tcp_lNewIndex<0) | ($_tcp_lNewIndex>Size of array:C274(<>_tcp_alSocketStatus)))
													TRACE:C157
													_err MESSAGE("Remote socket index error"; Current method name:C684; kFalse)
												Else 
													<>_tcp_alSocketStatus{$_tcp_lNewIndex}:=_tcp_ StatusGet($_tcp_lClientSocket)
													<>_tcp_atSocketState{$_tcp_lIndex}:="listening: new socket added"
													<>_tcp_atSocketId{$_tcp_lNewIndex}:="tcp"
												End if 
											End if 
										End if 
										
									End if 
								Until ($_tcp_lClientSocket=0)
								
							End if 
							//handle server socket - end
						Else   //<>_tcp_lConnectionEstablished        
							//handle client socket here
							
							
							If ((<>_tcp_alSocketLocalPort{$_tcp_lIndex}=_tcp_lRemotePort) & (<>_rem_lBindPrsEndWait<0))
								IDLE:C311
							Else 
								//delete these???
								//        If (($_tcp_lStatus#8) & (<>_tcp_alSocketRequestPrs{$_tcp_lIndex}#0))
								//          <>_tcp_alSocketRequestPrs{$_tcp_lIndex}:=0
								//        End if         
								
								$_tcp_lStatus:=_tcp_ StatusGet(_tcp_lSocket)  // only serving or outgoing socket status
								//If ($_tcp_lStatus#8)
								//$_tcp_tStatus:=_tcp_ LastErrorText (_tcp_lSocket)
								//◊_tcp_atSocketState{$_tcp_lIndex}:="serving: "+$_tcp_tStatus
								//End if 
								
								Case of 
									: ($_tcp_lStatus=8)  //still connected, should we wake up handler prs?
										
										Case of 
											: (<>_tcp_alSocketRequestPrs{$_tcp_lIndex}<0)
												<>_tcp_atSocketState{$_tcp_lIndex}:="outgoing: open"
												
												//outgoing client socket, let it handle itself
												
											: (<>_tcp_alSocketRequestPrs{$_tcp_lIndex}=0)  //newly added socket
												<>_tcp_atSocketState{$_tcp_lIndex}:="serving: orphan connection"
												
											Else   //(◊_tcp_alSocketRequestPrs{$_tcp_lIndex}>0)
												State:=Process state:C330(<>_tcp_alSocketRequestPrs{$_tcp_lIndex})
												
												Case of 
													: ((State=Paused:K13:6) | (State=Delayed:K13:2))  //wake up prs
														//$_tcp_lStatus:=_tcp_ StatusGet (_tcp_lSocket)  ` only serving or outgoing socket status
														If ($_tcp_lStatus=8)  //is it still open, do we need to wake up remote process?
															//<>_tcp_atSocketState{$_tcp_lIndex}:="serving: check buffer size" // status set in _tcp_FORM_SOCKET_UPDATE
															$_tcp_lSocketBufferSize:=_tcp_ BufferSize(_tcp_lSocket; 0)  //Returns the number of bytes available in the receive buffer of a TCP socket
															Case of 
																: ($_tcp_lSocketBufferSize=0)
																	//nothing coming, all ok  NO IDLE HERE!
																	//◊_tcp_atSocketState{$_tcp_lIndex}:="serving: idle"
																: ((_tcp_lTcpPlugInType=-1) & ($_tcp_lSocketBufferSize<0))  //ma_tcp -1 = closed socket
																	//<>_tcp_atSocketState{$_tcp_lIndex}:="serving: closed" // status set in _tcp_FORM_SOCKET_UPDATE
																	
																	If (<>_tcp_lInvalidSocketClose>0)  // Modified by: MG_PM (2011-11-15T17:32:08)
																		If (<>_tcp_alSocketStatus{$_tcp_lIndex}>=0)
																			If (<>_tcp_alSocketRequestPrs{$_tcp_lIndex}>0)
																				_rem_ BIND_PRS_STOP(<>_tcp_alSocketRequestPrs{$_tcp_lIndex})  // will close the socket later id is a rem_ prs
																				If (_rem_ RemotePrsIs(<>_tcp_alSocketRequestPrs{$_tcp_lIndex})=kFalse)
																					_tcp_ SOCKET_CLOSE(_tcp_lSocket; Current method name:C684)
																				End if 
																			End if 
																		End if 
																	End if 
																	
																	//_tcp_ socket_CLOSE (_tcp_lSocket;Current method name)
																: ($_tcp_lSocketBufferSize<0)  //not open socket - it is quite possible - happened after _tcp_ StatusToArr
																	_err MESSAGE("_tcp_ BufferSize error: "+String:C10($_tcp_lSocketBufferSize); Current method name:C684; kFalse)
																Else   //something has come here, usually a remote call
																	If (<>_tcp_alSocketLocalPort{$_tcp_lIndex}=_tcp_lRemotePort)
																		//<>_tcp_atSocketState{$_tcp_lIndex}:="serving: resume remote" // status set in _tcp_FORM_SOCKET_UPDATE
																		RESUME PROCESS:C320(<>_tcp_alSocketRequestPrs{$_tcp_lIndex})  //resume remote prs
																		DELAY PROCESS:C323(Current process:C322; <>_tcp_lDelayResumeRemote)  // give process some time to wake up effectively     
																		$_tcp_lSmallDelay:=kTrue  //to handle next connection faster 
																		_tcp_ lHitCount:=_tcp_ lHitCount+1
																		<>_tcp_lTotalHitCount:=<>_tcp_lTotalHitCount+1
																		$_tcp_lServerIndex:=Find in array:C230(<>_tcp_alSocketRequestPrs; <>_tcp_lListenerPrs)
																		If ($_tcp_lServerIndex>0)  // may be http OR tcp spcket, add to first
																			<>_tcp_alSocketHitCount{$_tcp_lServerIndex}:=<>_tcp_alSocketHitCount{$_tcp_lServerIndex}-1  // negative for server
																		End if 
																		//<>_tcp_atSocketState{$_tcp_lIndex}:="serving: remote" // status set in _tcp_FORM_SOCKET_UPDATE
																	Else 
																		<>_tcp_atSocketState{$_tcp_lIndex}:="serving: resume http"
																		RESUME PROCESS:C320(<>_tcp_alSocketRequestPrs{$_tcp_lIndex})  //resume http process
																		DELAY PROCESS:C323(Current process:C322; <>_tcp_lDelayResumeHttp)
																		$_tcp_lSmallDelay:=kTrue  //to handle next connection faster
																		_tcp_ lHitCount:=_tcp_ lHitCount+1
																		<>_tcp_lTotalHitCount:=<>_tcp_lTotalHitCount+1
																		//_tcp_SERVER_CONNECTED ($_tcp_lIndex)  `something has come here              
																		$_tcp_lServerIndex:=Find in array:C230(<>_tcp_alSocketRequestPrs; <>_tcp_lListenerPrs)
																		If ($_tcp_lServerIndex>0)  // may be http OR tcp spcket, add to first
																			<>_tcp_alSocketHitCount{$_tcp_lServerIndex}:=<>_tcp_alSocketHitCount{$_tcp_lServerIndex}-1  // negative for server
																		End if 
																		
																		If (False:C215)  //this is normal
																			_err MESSAGE("socket request for non-remote process, index "+String:C10($_tcp_lIndex)+", status "+String:C10($_tcp_lStatus); Current method name:C684; kFalse)
																		End if 
																		<>_tcp_atSocketState{$_tcp_lIndex}:="serving: http"  // status set in _tcp_FORM_SOCKET_UPDATE
																	End if 
															End case 
														End if 
														
													: (State<Executing:K13:4)  //kill connection - maybe we should answer more politely?
														<>_tcp_alSocketRequestPrs{$_tcp_lIndex}:=0  //will set handle prs on next round
														<>_tcp_atSocketState{$_tcp_lIndex}:="serving: socket handler process has died"
														_err MESSAGE("socket handler process has died"; Current method name:C684; kFalse)
													: (State>=0)
														//IDLE  `not Paused=5 --> executing somehow (Executing, Waiting for user event, Waiting for internal flag...) 
														//all ok - prs is still handling this socket
													Else   //(State>=Executing ) 
														TRACE:C157  //hmm?
												End case 
												
										End case   //(<>_tcp_alSocketRequestPrs{$_tcp_lIndex}>0)
										
										
										
									: ($_tcp_lStatus<=0)
										//socket waiting or opening, bad thing
										//If ($_tcp_lStatus#$_tcp_lPrevStatus)
										//_err MESSAGE ("socket status not open, index "+String($_tcp_lIndex)+", status "+String($_tcp_lStatus);Current method name;kFalse )
										//End if 
										If ($_tcp_lStatus<0)  // Modified by: MG_PM (8.6.2011)
											If (<>_tcp_alSocketStatus{$_tcp_lIndex}>=0)
												$_tcp_lStatus:=_tcp_ StatusGet($_tcp_lSocket)
												If (_tcp_ CloseNeeded($_tcp_lStatus)=kTrue)
													_tcp_ SOCKET_CLOSE(_tcp_lSocket; Current method name:C684)
												End if 
											End if 
										End if 
										
									: (($_tcp_lStatus>0) & ($_tcp_lStatus<8))
										//socket waiting or opening, all ok
										<>_tcp_atSocketState{$_tcp_lIndex}:="serving: opening"
										_err MESSAGE("socket status in opening-state, index "+String:C10($_tcp_lIndex)+", status "+String:C10($_tcp_lStatus); Current method name:C684; kFalse)
										
									: (($_tcp_lStatus>8) & ($_tcp_lStatus<=20))  // status>8, socket close started, wake up closer
										//_err MESSAGE ("socket status in closing-state, index "+String($_tcp_lIndex)+", status "+String($_tcp_lStatus);Current method name;kFalse )
										<>_tcp_atSocketState{$_tcp_lIndex}:="serving: closing"
										_tcp_ SOCKET_CLOSE(_tcp_lSocket; Current method name:C684)
										
									Else 
										<>_tcp_atSocketState{$_tcp_lIndex}:="serving: unknown status "+String:C10($_tcp_lStatus)
										_err MESSAGE("Unknown socket status, index "+String:C10($_tcp_lIndex)+", status "+String:C10($_tcp_lStatus); Current method name:C684; kFalse)
								End case 
								//handle client socket here - end
							End if   // ((<>_tcp_alSocketLocalPort{$_tcp_lIndex}=_tcp_lRemotePort) & (<>_rem_lBindPrsEndWait<0))
							
					End case   //(_tcp_alsocketRequestPrs{$_tcp_lIndex}=<>_tcp_lListenerPrs)
					
			End case   // zmq socket
			
			// next socket in the array
			$_tcp_lIndex:=$_tcp_lIndex+1
			
			While (<>_tcp_lResizeSocketArray>0)
				DELAY PROCESS:C323(Current process:C322; 1)  // delay and wait for arrays to be resized
				$_tcp_lIndex:=-1
			End while 
			
			$_tcp_lSocketCount:=Size of array:C274(<>_tcp_pLastSocketArr->)
			If ($_tcp_lIndex>$_tcp_lSocketCount)
				$_tcp_lIndex:=-1
			End if 
			
		End while   //Testing the status of each socket
		
	Until (<>_tcp_lServerQuit=kTrue)
	
	If (<>_tcp_lServerProfile=kTrue)
		If (<>_info_ fProfile)
			_info_ CALL_PROFILE(kStop; Current method name:C684+" - run")
		End if 
		If (<>_info_ fProfile)
			_info_ CALL_PROFILE(kStart; Current method name:C684+" - stop")
		End if 
	End if 
	
	// <>_tcp_alTcpPrs is not same array as socket, but we need to close all tcp server prs too
	$_tcp_lCount:=Size of array:C274(<>_tcp_alTcpPrs)  // <><>_tcp_alSocketRequestPrs or <>_tcp_alSocketPrs?
	For ($_tcp_lIndex; 1; $_tcp_lCount)
		RESUME PROCESS:C320(<>_tcp_alTcpPrs{$_tcp_lIndex})
	End for 
	_tcp_ tTcpPrsState:="quitting - closing sockets"
	_tcp_SERVER_ALL_SOCKETS_CLOSE
	_tcp_ tTcpPrsState:="quit"
	
End if 

<>_tcp_lListenerPrs:=0
_prs_ NEW_QUIT

// _rem_ TRACE("method end";Current method name)

If (<>_tcp_lServerProfile=kTrue)
	If (<>_info_ fProfile)
		_info_ CALL_PROFILE(kStop; Current method name:C684+" - stop")
	End if 
End if 
