//%attributes = {}
// Project Method: Calendar_BannerDrag

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft.

// Called by the [Calendar].Calendar form method during On Timer events while the 
//   user is dragging a banner end to modify its duration.

C_LONGINT:C283($cal_mouseX; $cal_mouseY; $cal_mouseButton)

GET MOUSE:C468($cal_mouseX; $cal_mouseY; $cal_mouseButton)
If ($cal_mouseButton#0)
	// SET CURSOR(cal_lCursorResize)`PM: 2005-11-09 returns always to default cursor
	// bad blinking redraw effect
	If (cal_lDragPosition=kStart)  // We're changing the start date.
		cal_lDragBannerLeft:=$cal_mouseX-cal_lDragBannerOffset
		Case of 
			: (cal_lDragBannerLeft>(cal_lDragBannerRight-10))
				cal_lDragBannerLeft:=cal_lDragBannerRight-10
			: (cal_lDragBannerLeft<cal_lLeftMargin)
				cal_lDragBannerLeft:=cal_lLeftMargin
		End case 
	Else   // We're changing the end date.
		cal_lDragBannerRight:=$cal_mouseX+cal_lDragBannerOffset
		Case of 
			: (cal_lDragBannerRight<(cal_lDragBannerLeft+10))
				cal_lDragBannerRight:=cal_lDragBannerLeft+10
			: (cal_lDragBannerRight>cal_lDragRightLimit)  // We set <>Cal_DragRightLimit in Calendar_DragBttnObjectMethod.
				cal_lDragBannerRight:=cal_lDragRightLimit
		End case 
	End if 
	
	// Move the banner as the user drags the mouse.
	OBJECT MOVE:C664(cal_pDragBannerPtr->; cal_lDragBannerLeft; cal_lDragBannerTop; cal_lDragBannerRight; cal_lDragBannerBottom; *)
	
	// We also need to move the invisible button, because its position is used to  
	//   highlight the end of the banner, and we're also going to redraw the selection
	//   objects.
	If (cal_lDragPosition=kStart)
		OBJECT MOVE:C664(cal_pDragBttnPtr->; cal_lDragBannerLeft; cal_lDragBannerTop; cal_lDragBannerLeft+cal_lDragAreaWidth; cal_lDragBannerBottom; *)
	Else 
		OBJECT MOVE:C664(cal_pDragBttnPtr->; cal_lDragBannerRight-cal_lDragAreaWidth; cal_lDragBannerTop; cal_lDragBannerRight; cal_lDragBannerBottom; *)
	End if 
	
	// Finally, move the selection rectangle.
	cal_OBJECT_SELECT(cal_pDragBannerPtr)
	
	
Else   // This gets called when the mouse button is released.
	SET TIMER:C645(0)
	// SET CURSOR(kCursorNormal )
	If (cal_pDragBannerPtr#cal_pNilPtr)
		cal_BANNER_RECALC(cal_pDragBannerPtr)
		cal_OBJECT_SELECT(cal_pDragBannerPtr)
		cal_EVENTS_PLACE
		cal_pDragBannerPtr:=cal_pNilPtr
	End if 
End if 
