//%attributes = {}
// Project Method: Calendar_PlaceBannerObject ({start date})

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft

// If the optional start Date parameter is passed, it is used instead of the 
//   event's actual start date. This allows us to call this method recursively to 
//   place banners that span multiple rows.

// Assumes a [Calendar] record of type "Banner" is loaded.

C_DATE:C307($cal_startDate; $1; $cal_endDate; $2; $cal_lastDatePlaced)

Case of 
	: (cal_lBannerObjectCount<1)
	: (cal_lBannerObjectCount>cal_lMaxBannerObjects)
	Else 
		_O_C_STRING:C293(31; $cal_varObjectName)
		C_POINTER:C301($cal_varPtr; $cal_dragObjPtr)
		C_LONGINT:C283($cal_boxNumber; $cal_startBoxNumber; $cal_endBoxNumber; $cal_firstBoxBottom; $cal_bannerLevel; $cal_bannerBottom; $cal_bannerTop)
		C_LONGINT:C283($cal_ignore; $cal_boxLeft; $cal_boxTop; $cal_boxRight; $cal_boxBottom; $cal_endBoxRight; $cal_bannerLeft; $cal_bannerRight)
		C_BOOLEAN:C305($cal_beginningOfBanner)
		
		If (Count parameters:C259=2)
			$cal_startDate:=$1
			$cal_endDate:=$2
		Else 
			$cal_startDate:=do_adDate_{cal_lEventIndex}
			$cal_endDate:=do_adEnd_Date{cal_lEventIndex}  //$cal_startDate+-1
		End if 
		
		$cal_beginningOfBanner:=(Count parameters:C259=0)
		
		// Our start and end dates may not be represented on this calendar. Modify them so
		//   we don't bother plotting banners offscreen.
		If ($cal_startDate<cal_dFirstBoxDate)
			$cal_startDate:=cal_dFirstBoxDate
			$cal_beginningOfBanner:=False:C215
		End if 
		
		If ($cal_endDate>cal_dLastBoxDate)
			$cal_endDate:=cal_dLastBoxDate
		End if 
		
		If (($cal_startDate<=cal_dLastBoxDate) & ($cal_endDate>=cal_dFirstBoxDate))
			$cal_varObjectName:="cal_tBanner"+String:C10(cal_lBannerObjectCount)  // Yes, this works on Mac too.
			cal_TRACKING_ELEM_ADD($cal_varObjectName)  // Update the arrays that let us track which record the object is associated with.
			
			// Get a pointer to the variable object.
			$cal_varPtr:=Get pointer:C304($cal_varObjectName)
			
			// Set the object's text.
			$cal_varPtr->:=cal_EventDisplayFormat
			
			// Set the object's color.
			cal_OBJECT_COLOR_SET($cal_varPtr)
			
			$cal_startBoxNumber:=$cal_startDate-cal_dFirstBoxDate+1
			$cal_endBoxNumber:=$cal_startBoxNumber+($cal_endDate-$cal_startDate)
			
			$cal_boxNumber:=$cal_startBoxNumber
			OBJECT GET COORDINATES:C663(*; "Box"+String:C10($cal_boxNumber); $cal_boxLeft; $cal_boxTop; $cal_boxRight; $cal_boxBottom)
			$cal_firstBoxBottom:=$cal_boxBottom
			$cal_endBoxRight:=$cal_boxRight
			$cal_lastDatePlaced:=$cal_startDate
			
			If ($cal_boxNumber>Size of array:C274(cal_alBoxBannerLevel))
				_err MESSAGE("Box Number > Banner Level Array"; Current method name:C684; kFalse)
				IDLE:C311
			Else 
				$cal_bannerLevel:=cal_alBoxBannerLevel{$cal_boxNumber}+1  // This is the stacking level we'll use for this banner. We start at level 1.
				cal_alBoxBannerLevel{$cal_boxNumber}:=$cal_bannerLevel
			End if 
			// Continue until we're done with the event, or we're at the last box in the 
			//   current row.
			While (($cal_boxNumber<$cal_endBoxNumber) & ($cal_boxBottom=$cal_firstBoxBottom))
				$cal_boxNumber:=$cal_boxNumber+1
				OBJECT GET COORDINATES:C663(*; "Box"+String:C10($cal_boxNumber); $cal_ignore; $cal_ignore; $cal_boxRight; $cal_boxBottom)
				If ($cal_boxBottom=$cal_firstBoxBottom)
					$cal_lastDatePlaced:=$cal_lastDatePlaced+1
					$cal_endBoxRight:=$cal_boxRight
					If (cal_alBoxBannerLevel{$cal_boxNumber}>=$cal_bannerLevel)
						$cal_bannerLevel:=$cal_bannerLevel+1
					End if 
					cal_alBoxBannerLevel{$cal_boxNumber}:=$cal_bannerLevel
				End if 
			End while 
			
			$cal_bannerLeft:=$cal_boxLeft
			$cal_bannerRight:=$cal_endBoxRight
			$cal_bannerTop:=$cal_firstBoxBottom-((cal_lTextHeight+3)*$cal_bannerLevel)
			
			// Don't allow the banner to creep out of the box that contains it. 
			If ($cal_bannerTop<($cal_boxTop+3))
				$cal_bannerTop:=$cal_boxTop+3
			End if 
			
			$cal_bannerBottom:=$cal_bannerTop+cal_lBannerHeight
			
			// This code starts the left side of the banner 3 pixels from the edge of the
			//   box if it's the first banner piece we're drawing for this event.  It also 
			//   moves an invisible button (used for resizing the banner) to the beginning of 
			//   the banner.
			If ($cal_beginningOfBanner)
				$cal_bannerLeft:=$cal_bannerLeft+3
				$cal_varObjectName:="cal_lDragBttnL"+String:C10(cal_lBannerObjectCount)  // The invisible button next to the banner.
				cal_TRACKING_ELEM_ADD($cal_varObjectName)
				$cal_dragObjPtr:=Get pointer:C304($cal_varObjectName)
				OBJECT MOVE:C664($cal_dragObjPtr->; $cal_bannerLeft; $cal_bannerTop; $cal_bannerLeft+cal_lDragAreaWidth; $cal_bannerBottom; *)
			End if 
			
			// This does the same thing for the right side of the banner.
			If ($cal_lastDatePlaced=do_adEnd_Date{cal_lEventIndex})  //([To_Do]Date_+-1))
				$cal_bannerRight:=$cal_bannerRight-3
				$cal_varObjectName:="cal_lDragBttnR"+String:C10(cal_lBannerObjectCount)
				cal_TRACKING_ELEM_ADD($cal_varObjectName)
				$cal_dragObjPtr:=Get pointer:C304($cal_varObjectName)
				OBJECT MOVE:C664($cal_dragObjPtr->; $cal_bannerRight-cal_lDragAreaWidth; $cal_bannerTop; $cal_bannerRight; $cal_bannerBottom; *)
			End if 
			
			OBJECT MOVE:C664($cal_varPtr->; $cal_bannerLeft; $cal_bannerTop; $cal_bannerRight; $cal_bannerBottom; *)
			
			If ($cal_lastDatePlaced<$cal_endDate)
				If (cal_lBannerObjectCount>=cal_lMaxBannerObjects)
					cal_tError:=_lang Current("There are more banner events this month than can be displayed on this calendar")+ksPeriod
				Else 
					cal_lBannerObjectCount:=cal_lBannerObjectCount+1
					cal_BANNER_PLACE($cal_lastDatePlaced+1; $cal_endDate)
				End if 
			End if 
		End if 
End case 
