//%attributes = {}
// Project Method: Calendar_BoxObjectMethod

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft

// This method is called by the box object methods.  It's also called by the 
//   object methods of the variables that display the numbers on top of the boxes,
//   since these objects are on top of the boxes and might get clicked on.


C_LONGINT:C283($0; $cal_lSrcElement; $cal_lSrcProcess; $cal_lRecsInSel; $cal_lDateOffset; $cal_lBox)
C_POINTER:C301($1; $cal_pObject; $cal_pSrcObjectPtr)
C_DATE:C307($cal_dThisBoxDate)

$cal_pObject:=$1
$0:=0

Case of 
	: (Form event code:C388=On Clicked:K2:4)
		cal_OBJECT_DESELECT(cal_pSelectedObjectPtr)
		cal_dDateClicked:=cal_BoxDateGet(cal_ObjectNumberGet($cal_pObject))
		cal_DAY_CLICKED($cal_pObject)
		
	: (Form event code:C388=On Double Clicked:K2:5)
		cal_dDateClicked:=cal_BoxDateGet(cal_ObjectNumberGet($cal_pObject))
		cal_DOUBLE_CLICKED($cal_pObject)
		
	: (Form event code:C388=On Drag Over:K2:13)
		_O_DRAG AND DROP PROPERTIES:C607($cal_pSrcObjectPtr; $cal_lSrcElement; $cal_lSrcProcess)
		cal_lEventIndex:=cal_AssociatedEventIndexGet($cal_pSrcObjectPtr)
		$cal_dThisBoxDate:=cal_BoxDateGet(cal_ObjectNumberGet($cal_pObject))
		If (Is nil pointer:C315(cal_pDragObject))
			cal_pDragObject:=$cal_pSrcObjectPtr
			// GET MOUSE($cal_lX;$cal_lY;$cal_lButton;*)
			$cal_lBox:=cal_ObjectNumberGet($cal_pObject)
			cal_dStartDragDate:=cal_BoxDateGet($cal_lBox)
		End if 
		If (do_adDate_{cal_lEventIndex}=$cal_dThisBoxDate)
			$0:=-1  // Don't allow a drop onto the date it's alread on.
		Else 
			$0:=0
		End if 
		
	: (Form event code:C388=On Drop:K2:12)
		$cal_dThisBoxDate:=cal_BoxDateGet(cal_ObjectNumberGet($cal_pObject))
		_O_DRAG AND DROP PROPERTIES:C607($cal_pSrcObjectPtr; $cal_lSrcElement; $cal_lSrcProcess)
		cal_lEventIndex:=cal_AssociatedEventIndexGet($cal_pSrcObjectPtr)
		$cal_lRecsInSel:=cal_EventLoad(cal_lEventIndex)
		If ($cal_lRecsInSel<1)
			_err MESSAGE(_lang Current("Calendar event was not found"); Current method name:C684; kFalse)
		Else 
			_tbl WRITE_STATE(do_kTbl; kTrue)
			If (Macintosh option down:C545)  // Duplicate the event.
				_rec DUPLICATE(do_kTbl)
			Else 
				_rec LOAD(do_kTbl)
			End if 
			
			// v12:
			If (_fld ValueDate(do_kEnd_Date)=!00-00-00!)
				_fld VALUE_DATE_SET(kSet; do_kDate_; $cal_dThisBoxDate)
			Else 
				// banner
				$cal_lDateOffset:=_fld ValueDate(do_kEnd_Date)-_fld ValueDate(do_kDate_)
				$cal_lDateOffset:=Abs:C99($cal_lDateOffset)
				
				_fld VALUE_DATE_SET(kSet; do_kDate_; $cal_dThisBoxDate)
				_fld VALUE_DATE_SET(kSet; do_kEnd_Date; $cal_dThisBoxDate+$cal_lDateOffset)
			End if 
			// old v67:
			//$cal_lDateOffset:=cal_dStartDragDate-do_adDate_{cal_lEventIndex}
			//If (do_adEnd_Date{cal_lEventIndex}#!00.00.00!)
			//[To_Do]End_Date:=$cal_dThisBoxDate+([To_Do]End_Date-[To_Do]Date_)-$cal_lDateOffset
			//End if 
			//[To_Do]Date_:=$cal_dThisBoxDate-$cal_lDateOffset
			
			
			
			cal_pDragObject:=cal_pNilPtr
			
			_rec SAVE(do_kTbl)
			_tbl WRITE_STATE(do_kTbl; kPrevious)
			cal_EVENTS_PLACE
		End if 
End case 
