//%attributes = {}
// Project Method: Calendar_PictPopupLoadPicts

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft.

// Reads the images from the files in the Images folder into a picture array.


C_LONGINT:C283($cal_docNum; $cal_element)
C_TEXT:C284($cal_dirSymbol; $cal_folderPath)
C_PICTURE:C286($cal_picture)

ARRAY PICTURE:C279(cal_agPictures; 0)  // This is the array this method is designed to populate.

$cal_dirSymbol:=_doc FolderSeparator

// If we're using 4D Client, look for the Images folder in the 4D Client folder.
//   Otherwise, assume it's just in the same folder as the structure file.
If (Application type:C494=4D Remote mode:K5:5)
	$cal_folderPath:=_doc LocalPath+"Images"+$cal_dirSymbol
	// You could instead use this code to find the Images folder in the Mac4DX or 
	//   Win4DX folder sent from 4D Server, but the 4D Server 6.7 betas didn't
	//   send this folder to the clients as expected, so I couldn't test it. - Dave
	//If ($platform=Windows )
	//  $folderPath:=Get 4D folder+"Win4DX\Images\"
	//Else 
	//  $folderPath:=Get 4D folder+"Mac4DX:Images:"
	//End if 
Else 
	$cal_folderPath:=_doc LocalPath+"Images"+$cal_dirSymbol
End if 

// Make sure the folder exists. If not, just continue without any errors.
If (Test path name:C476($cal_folderPath)=Is a folder:K24:2)
	ARRAY TEXT:C222($cal_aDocNames; 0)
	DOCUMENT LIST:C474($cal_folderPath; $cal_aDocNames)
	
	For ($cal_docNum; 1; Size of array:C274($cal_aDocNames))
		READ PICTURE FILE:C678($cal_folderPath+$cal_aDocNames{$cal_docNum}; $cal_picture)
		If (OK=1)
			$cal_element:=Size of array:C274(cal_agPictures)+1
			INSERT IN ARRAY:C227(cal_agPictures; $cal_element)
			cal_agPictures{$cal_element}:=$cal_picture
		End if 
	End for 
	
End if 
