//%attributes = {}
// Method: co_PRODUCT_GROUPS
// 2005.11.09-14:32:03 / ME
// © Copyright 2005 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
// Product groups are stored in Info field of Company
// Model: 
// Header:Group1+Group2+Group3;
// Header is 'Product Groups', in Finnish 'Tuoteryhmät'

C_LONGINT:C283($co_lArrSize; $co_lIndex; $co_lArrIndex; $co_lPosition; $co_lEndPosition; $co_lLength)
C_TEXT:C284($co_tInfo; $co_tHeader; $co_tGroups; $co_tGroup)

ARRAY TEXT:C222(<>co_atProductGroupName; 0)
ARRAY TEXT:C222(<>co_atProductGroupDesc; 0)
ARRAY LONGINT:C221(co_alSelectedRows; 0)
C_POINTER:C301($co_pTempPtrArr)

$co_tInfo:=[Company:10]Info:5
$co_tHeader:=_lang Current("Product Groups")+":"
$co_lLength:=Length:C16($co_tHeader)
$co_tGroups:=""

// search the header; are there product groups in info field?
$co_lPosition:=_str_ FirstIndexOf($co_tHeader; $co_tInfo; 1)
$co_lEndPosition:=_str_ FirstIndexOf(";"; $co_tInfo; $co_lPosition)
// if yes, separate the goup names
If (($co_lPosition>0) & ($co_lEndPosition>0))
	$co_tGroups:=Substring:C12($co_tInfo; $co_lPosition; $co_lEndPosition-$co_lPosition)
	$co_tInfo:=Delete string:C232($co_tInfo; $co_lPosition; $co_lEndPosition-$co_lPosition+1)
	$co_tGroups:=Delete string:C232($co_tGroups; 1; $co_lLength)
End if 

// read the group list from preferences
$co_pTempPtrArr:=_arr PtrToTmpArr(-><>co_atProductGroupDesc; -><>co_atProductGroupName)  // pointer to array-pointer array
_list LIST_TO_ARR("co_kProductGroup"; $co_pTempPtrArr)

// find the group names stored in info from the list
$co_lIndex:=1
$co_lPosition:=1
Repeat 
	$co_tGroup:=_str Parse($co_tGroups; "+"; $co_lIndex)
	If ($co_tGroup#"")
		$co_lPosition:=Find in array:C230(<>co_atProductGroupName; $co_tGroup)
		// insert the index into selected array
		If ($co_lPosition>0)
			INSERT IN ARRAY:C227(co_alSelectedRows; $co_lIndex)
			co_alSelectedRows{$co_lIndex}:=$co_lPosition
		End if 
		$co_lIndex:=$co_lIndex+1
	End if 
Until ($co_tGroup="")

// open the list dialog
_list SELECT_MANY($co_pTempPtrArr; _arr StrToTmpArr(_lang Current("Product Group")+":300"; _lang Current("Abbreviation")+":80"); ->co_alSelectedRows; ""; 1; 1)

// write the selected groups into info separated by +
If (OK=1)
	$co_lArrSize:=Size of array:C274(co_alSelectedRows)
	$co_tGroups:=""
	For ($co_lIndex; 1; $co_lArrSize)
		$co_lArrIndex:=co_alSelectedRows{$co_lIndex}
		If ($co_tGroups#"")
			$co_tGroups:=$co_tGroups+"+"+<>co_atProductGroupName{$co_lArrIndex}
		Else 
			$co_tGroups:=<>co_atProductGroupName{$co_lArrIndex}
		End if 
	End for 
	If ($co_tGroups#"")
		$co_tGroups:=_lang Current("Product Groups")+":"+$co_tGroups+";"
		If (_str End($co_tInfo; 1)=ksCR)
			$co_tInfo:=$co_tInfo+$co_tGroups
		Else 
			$co_tInfo:=$co_tInfo+ksCR+$co_tGroups
		End if 
	End if 
	[Company:10]Info:5:=$co_tInfo
End if 

ARRAY TEXT:C222(<>co_atProductGroupName; 0)
ARRAY TEXT:C222(<>co_atProductGroupDesc; 0)
ARRAY LONGINT:C221(co_alSelectedRows; 0)