//%attributes = {}
// Method: fl_ColorDarknessChange
// 2004.11.05-16:59:40 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// fl_ColorDarknessChange( Color; -60 ) = 60% lighter color
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_LONGINT:C283($0; $1; $fl_lColor; $fl_lPartColorR; $fl_lPartColorG; $fl_lPartColorB)
C_LONGINT:C283($fl_lPartColorR2; $fl_lPartColorG2; $fl_lPartColorB2)
C_REAL:C285($2; $fl_rDarknessPercentage; $fl_rChange; $fl_rChangePercent)
$fl_lColor:=$1
$fl_rDarknessPercentage:=$2
//clBlack = 0x00000000 and clWhite = 0x00FFFFFF

$fl_lPartColorR:=($fl_lColor & 0x00FF0000) >> 16  //Red 
$fl_lPartColorG:=($fl_lColor & 0xFF00) >> 8  //Green 
$fl_lPartColorB:=$fl_lColor & 0x00FF  // Blue 

//PM: 2009-11-17
If ($fl_rDarknessPercentage<0)  //lighter -> move to 255
	
	$fl_rChangePercent:=Abs:C99($fl_rDarknessPercentage/100)
	
	$fl_rChange:=(255-$fl_lPartColorR)*$fl_rChangePercent
	$fl_lPartColorR2:=Round:C94($fl_lPartColorR+$fl_rChange; 0)
	
	$fl_rChange:=(255-$fl_lPartColorG)*$fl_rChangePercent
	$fl_lPartColorG2:=Round:C94($fl_lPartColorG+$fl_rChange; 0)
	
	$fl_rChange:=(255-$fl_lPartColorB)*$fl_rChangePercent
	$fl_lPartColorB2:=Round:C94($fl_lPartColorB+$fl_rChange; 0)
	
	If ($fl_lPartColorR2>255)  // 0x00FF=255
		$fl_lPartColorR2:=255
	End if 
	If ($fl_lPartColorG2>255)  // 0x00FF=255
		$fl_lPartColorG2:=255
	End if 
	If ($fl_lPartColorB2>255)  // 0x00FF=255
		$fl_lPartColorB2:=255
	End if 
	
Else   //darker -> move to 0
	
	$fl_rChangePercent:=$fl_rDarknessPercentage/100
	
	$fl_rChange:=($fl_lPartColorR)*$fl_rChangePercent
	$fl_lPartColorR2:=Round:C94($fl_lPartColorR-$fl_rChange; 0)
	
	$fl_rChange:=($fl_lPartColorG)*$fl_rChangePercent
	$fl_lPartColorG2:=Round:C94($fl_lPartColorG-$fl_rChange; 0)
	
	$fl_rChange:=($fl_lPartColorB)*$fl_rChangePercent
	$fl_lPartColorB2:=Round:C94($fl_lPartColorB-$fl_rChange; 0)
	
	If ($fl_lPartColorR2<0)  // 0x00FF=255
		$fl_lPartColorR2:=0
	End if 
	If ($fl_lPartColorG2<0)  // 0x00FF=255
		$fl_lPartColorG2:=0
	End if 
	If ($fl_lPartColorB2<0)  // 0x00FF=255
		$fl_lPartColorB2:=0
	End if 
	
End if 

$fl_lColor:=($fl_lPartColorR2 << 16)+($fl_lPartColorG2 << 8)+$fl_lPartColorB2
$0:=$fl_lColor

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 