//%attributes = {}
// Method: ld_WorkEndCalculate
// 2004.01.20-01:44:50 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// find first free place for work
// fix also: ld_calc_FirstFreePlaceCalculate
// ------------------------------------------------------------
C_LONGINT:C283($1; $ld_lWorkIndex; $2; $ld_lCalculationType)
C_LONGINT:C283($4; $ld_lCalcLoadFromCriticalDate; $ld_lIndex; $ld_lLastWorkIndex; $ld_lLastWorkEndCapIndex; $ld_lLastCapIndex; $ld_lCapIndex)
C_REAL:C285($0; $3; $ld_rWorkEnd; $ld_rCapacityStartCumulativeFree; $ld_rWorkLengthRemaining; $ld_rMultiplier)
//C_DATE($4;$ld_dCapacityStartDate)
//C_TIME($5;$ld_hCapacityStartTime)

//COMPILER_ld_ 
//COMPILER_ldc_   `load capasity
//COMPILER_ldf_   `fine load

$ld_lWorkIndex:=$1
$ld_lCalculationType:=$2
$ld_rMinLengthNeeded:=$3
$ld_lCalcLoadFromCriticalDate:=$4

ld_wlg_ARR_LOAD

$ld_rWorkEnd:=0
If ($ld_lWorkIndex>0)
	$ld_rWorkLengthRemaining:=ld_work_arSetup_Time{$ld_lWorkIndex}+ld_work_arWork_Time{$ld_lWorkIndex}
	$ld_lLastWorkIndex:=_arr MaxIndex(->ld_work_adEnd_Date)
	$ld_lLastWorkEndCapIndex:=ldcap_IndexFirst(ld_work_asWork_Load_Group_id{$ld_lLastWorkIndex}; ld_work_adEnd_Date{$ld_lLastWorkIndex})
	$ld_lCapIndex:=-1
	$ld_lLastCapIndex:=ldcap_IndexLast(ld_work_asWork_Load_Group_id{$ld_lLastWorkIndex})  //AK: 2006-01-05 parameter was missing
	$ld_lFirstCapIndex:=ldcap_IndexFirst(ld_work_asWork_Load_Group_id{$ld_lLastWorkIndex}; $ld_dCapacityStartDate)
	Case of 
		: ($ld_lCalculationType=1)
			
			//recalculate and remove this work from cumulative and free capacity
			//      ldcap_FREE_CACLULATE (ld_work_asWork_Load_Group_id{$ld_lLastWorkIndex};$
			//~ld_lWorkIndex;kFalse )
			ldcap_FREE_CACLULATE(ld_work_asWork_Load_Group_id{$ld_lLastWorkIndex}; $ld_lWorkIndex; $ld_lCalcLoadFromCriticalDate)
			
			If (ld_work_asWork_Load_Group_id{$ld_lWorkIndex}#ld_work_asWork_Load_Group_id{$ld_lWorkIndex})
				TRACE:C157  //error here in old code
				If (_usr Admin=kTrue)
					_err MESSAGE(_lang Current("Capacity load group is not correct")+": "+ldcap_tCapacityName+ksSpace+ld_work_asWork_Load_Group_id{$ld_lWorkIndex}; Current method name:C684; kFalse)
				End if 
			End if 
			//        ldcap_FREE_CACLULATE (ld_work_asWork_Load_Group_id{$ld_lWorkIndex};$ld
			//~_lWorkIndex;$ld_lCalcLoadFromCriticalDate)
			
			//if cumulative free is negative in last work index there is no point doing 
			//backwards find, instead calculate forward from last work index (done in else loo
			If (ldcap_arCumulativeFree{$ld_lLastWorkEndCapIndex}>=$ld_rMinLengthNeeded)
				//find backwards last work index where cumulative free is _not_ less than need
				For ($ld_lIndex; $ld_lLastWorkEndCapIndex; $ld_lFirstCapIndex; -1)
					If (ldcap_arCumulativeFree{$ld_lIndex}<$ld_rMinLengthNeeded)
						$ld_lCapIndex:=$ld_lIndex+1  //back to next one
						$ld_lIndex:=0  //break loop
					End if 
				End for 
			Else 
				//find forward from last work index where cumulative free is _not_ less than need
				For ($ld_lIndex; $ld_lLastWorkEndCapIndex; $ld_lLastCapIndex)
					If (ldcap_arCumulativeFree{$ld_lIndex}>=$ld_rMinLengthNeeded)
						$ld_lCapIndex:=$ld_lIndex  //this one
						$ld_lIndex:=$ld_lLastCapIndex  //break loop
					End if 
				End for 
			End if 
			//now we have found cap index where culmulative >= $ld_rMinLengthNeeded           
			
			If ($ld_lCapIndex<$ld_lFirstCapIndex)
				$ld_lCapIndex:=$ld_lFirstCapIndex
			End if 
			
			If (ldcap_arCumulativeFree{$ld_lCapIndex}<(ld_work_arSetup_Time{$ld_lWorkIndex}+ld_work_arWork_Time{$ld_lWorkIndex}))
				//if not enough cumulative is found then loop from start to end
				//where first cumulative free >= work time (may be bigger than need) 
				For ($ld_lIndex; $ld_lFirstCapIndex; $ld_lLastCapIndex)
					If (ldcap_arCumulativeFree{$ld_lIndex}>=(ld_work_arSetup_Time{$ld_lWorkIndex}+ld_work_arWork_Time{$ld_lWorkIndex}))
						$ld_lCapIndex:=$ld_lIndex  //this one
						$ld_lIndex:=$ld_lLastCapIndex  //break loop
					End if 
				End for 
			End if 
			
			Case of 
				: ($ld_lCapIndex>$ld_lLastCapIndex)
					$ld_tErr:=_lang Current(", load group: ")+ld_work_asWork_Load_Group_id{$ld_lLastWorkIndex}
					_err MESSAGE(_lang Current("Capacity not found, work start date is bigger than capacity last date, capacity")+": "+ldcap_tCapacityName+ksSpace+$ld_tErr; Current method name:C684; kFalse)
					//err here! - after capacity
				Else 
					$ld_rMultiplier:=ldcap_PhaseTimeMultiplier($ld_lCapIndex; ld_work_arLoadMultiplier{$ld_lWorkIndex}; ld_work_asWork_Load_Group_id{$ld_lWorkIndex})
					$ld_rCapacityStartCumulativeFree:=(ldcap_arCumulativeFree{$ld_lCapIndex}-ldcap_arCurrentFree{$ld_lCapIndex})
					If ($ld_rCapacityStartCumulativeFree#0)
						$ld_rWorkEnd:=ldcap_arStart{$ld_lCapIndex}+_dt HoursToReal(($ld_rWorkLengthRemaining-$ld_rCapacityStartCumulativeFree)/$ld_rMultiplier)  //AK: 2004-10-20
					Else 
						$ld_rWorkEnd:=ldcap_arEnd{$ld_lCapIndex}-_dt HoursToReal((ldcap_arCurrentFree{$ld_lCapIndex}-$ld_rWorkLengthRemaining)/$ld_rMultiplier)  //AK: 2004-10-20
					End if 
			End case 
		Else 
			TRACE:C157
	End case 
End if 
$0:=$ld_rWorkEnd
