//%attributes = {}
// Method: ldcap_ARR_LOAD_SAVE
// 2004.01.09-14:50:01 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($2; $ld_tLoadGroup; $ld_tPrfName; $ld_tPrfNameShort; $ld_tExtraTimeCapName; $ld_tLoadGroupOrig)  //$2=load group
C_LONGINT:C283($1; $ld_lIndex; $3; $ld_lForceLoad_Save)
C_LONGINT:C283($ldcap_lLoadType)
$ld_tLoadGroup:=$2
$ld_lForceLoad_Save:=$3

COMPILER_ldcap_
$ldcap_lLoadType:=cap_ ArrLoadType($ld_tLoadGroup)

// COMPILER_ld_, COMPILER_ld_cap_

Case of 
	: ($ld_tLoadGroup="@_machine") & (ldcap_ MachineDataLoadType=1)
		If (ldcap_dMachineStartDate=!00-00-00!)
			_err MESSAGE(_lang Current("Requested machine start date is !00.00.0000!"); Current method name:C684; kFalse)
			ldcap_dMachineStartDate:=_date Current(kTrue)
		End if 
		If (ldcap_dMachineEndDate=!00-00-00!)
			_err MESSAGE(_lang Current("Requested machine end date is !00.00.0000!"); Current method name:C684; kFalse)
			ldcap_dMachineEndDate:=ldcap_dMachineStartDate
		End if 
		$ld_tLoadGroupOrig:=$ld_tLoadGroup
		$ld_tLoadGroup:=Replace string:C233($ld_tLoadGroup; "_machine"; "")
		ldcap_ MACHINE_ARR_LOAD($ld_tLoadGroup; ldcap_dMachineStartDate; ldcap_dMachineEndDate)
		ldcap_tCapCurrentLoadGroup:=$ld_tLoadGroupOrig
		ldcap_tCapacityName:=$ld_tLoadGroupOrig
		
	: ($ldcap_lLoadType=1) & ($1=kLoad)
		cap_ ARR_LOAD($2; $3)  //use lua-calculation, save arrays to blobs & to preferences 
	: ($ldcap_lLoadType=2)  //use lua-calculation, collect all capacities to big process arrays  (not in use)
		cap_ ARR_LOAD_2($2; $3)
		
	: ($ldcap_lLoadType=0)  // old original loading
		ldcap_tExtraTimeCapName:=""
		If ((<>ld_lUseExtraTimeCapName=kTrue) & (ld_lWorkMoveExtra=kTrue))  //PM: 2009-02-10
			$ld_tExtraTimeCapName:=ld_wlg_ExtraTimeCapacityName($ld_tLoadGroup)
			If ($ld_tExtraTimeCapName#"")
				$ld_tLoadGroup:=$ld_tExtraTimeCapName
				ldcap_tExtraTimeCapName:=$ld_tLoadGroup
			End if 
		End if 
		
		If ($ld_tLoadGroup="")
			$ld_tPrfName:="ld_Capacity_Default"  //+_lang Current ("Default")
		Else 
			If ($ld_tLoadGroup#"ld_Capacity_@")
				$ld_tPrfName:="ld_Capacity_"+$ld_tLoadGroup
			Else 
				$ld_tPrfName:=$ld_tLoadGroup
			End if 
		End if 
		
		Case of 
			: ($1=kLoad)
				If (($ld_lForceLoad_Save=kTrue) | (ldcap_tCapCurrentLoadGroup#$ld_tLoadGroup))
					
					ldcap_lLoaded:=kTrue
					//ldcap_tCapacityPrfName:=$ld_tPrfName
					If (ldcap_BlobLoad($ld_tLoadGroup; $ld_tPrfName; $ld_lForceLoad_Save)=kFalse)
						
						If (<>_info_ fProfile)
							_info_ CALL_PROFILE(kStart; Current method name:C684+" - real load")
						End if 
						
						//was not found in previously loaded blob
						If (_prf_ Data(kLoad; ""; $ld_tPrfName; kFalse; ->ldcap_apCapArr)=kFalse)
							ldcap_tExtraTimeCapName:=""  //PM: 2009-02-10
							
							If ($ld_tPrfName=("ld_Capacity_Default"))
								ldcap_lLoaded:=kFalse  //do not load same twice
							Else 
								$ld_tPrfName:="ld_Capacity_Default"  //+_lang Current ("Default")  `load group not found, use default
								
								If (_prf_ Data(kLoad; ""; $ld_tPrfName; kFalse; ->ldcap_apCapArr)=kFalse)
									ldcap_lLoaded:=kFalse
								Else 
									_arr apSIZE_CHECK(->ldcap_apCapArr; kAdd; kTrue)
								End if 
								
							End if 
						End if 
						
						If (ldcap_lLoaded=kTrue)  //after load from disk
							
							$ld_tPrfNameShort:=ldcap_ PrfNameShort($ld_tPrfName)  // v12
							_arr FILL(->ldcap_atCapId; ->$ld_tPrfNameShort; 1; MAXLONG:K35:2)  // v12
							
							ldcap_tCapacityPrfName:=$ld_tPrfName
							ldcap_BLOB_SAVE($ld_tLoadGroup; $ld_tPrfName)
						End if 
						
						If (<>_info_ fProfile)
							_info_ CALL_PROFILE(kStop; Current method name:C684+" - real load")
						End if 
						$ld_lIndex:=ldcap_ArrCheck
						
					End if 
					
					If (ldcap_lLoaded=kFalse)
						_err MESSAGE(_lang Current("Capacity arrays could not be loaded from preferences")+": "+ksQuoteStart+$ld_tPrfName+ksQuoteEnd; Current method name:C684; kFalse)
						ldcap_tCapacityPrfName:=""
						ldcap_tCapCurrentLoadGroup:=""
						ldcap_tExtraTimeCapName:=""  //PM: 2009-02-10
					Else 
						ldcap_tCapCurrentLoadGroup:=$ld_tLoadGroup
					End if 
					C_TEXT:C284($ldcap_tPrefix)
					$ldcap_tPrefix:=ldcap_ PrfNamePrefix(ldcap_tCapCurrentLoadGroup)
					ldcap_tCapacityName:=Substring:C12(ldcap_tCapacityPrfName; Length:C16($ldcap_tPrefix)+1)
					
					//speed optimization - capacities MUST be sorted when saving, not when loading
					//so these are commented now
					//      $ld_lIndex:=Find in array(ld_apCapArr;->ld_arCapStart)
					//      $ld_tOrdArrNum:=String($ld_lIndex)+";"
					//      $ld_lIndex:=Find in array(ld_apCapArr;->ld_arCapEnd)
					//      $ld_tOrdArrNum:=$ld_tOrdArrNum+String($ld_lIndex)+";"
					//      $ld_lIndex:=Find in array(ld_apCapArr;->ld_arCapCapacity)
					//      $ld_tOrdArrNum:=$ld_tOrdArrNum+String($ld_lIndex)
					//      _arr apORD (->ld_apCapArr;$ld_tOrdArrNum)      
					
				End if 
			: ($1=kSave)
				If (False:C215)
					//everywhere before save there is a call to:
					$ld_lIndex:=ldcap_ArrCheck
				End if 
				//    If (ld_tCapacityPrfName="")
				//      ld_tCapacityPrfName:="ld_Capacity_"+_lang Current ("Default")
				//    End if     
				ldcap_tCapacityPrfName:=$ld_tPrfName
				If (_prf_ Data(kSave; ""; ldcap_tCapacityPrfName; kTrue; ->ldcap_apCapArr)=kFalse)
					_err MESSAGE(_lang Current("Capacity arrays could not be saved to preferences")+": "+ksQuoteStart+ldcap_tCapacityPrfName+ksQuoteEnd; Current method name:C684; kFalse)
				End if 
				
				If (True:C214)
					ldcap_ NEXT_LOAD_FORCE
				Else 
					ldcap_BLOB_SAVE(ldcap_tCapCurrentLoadGroup; ldcap_tCapacityPrfName)  //or $ld_tLoadGroup?
				End if 
				
				ld_ CRITICAL_DATE_CHANGE(0; 0; "ld_CriticalDatePhaseChange")  //PM: 2006-02-14
			Else 
				_err MESSAGE_PARAMETER("$1"; Current method name:C684; kFalse)
		End case 
		
	Else 
		_err MESSAGE_PARAMETER(_lang Current("Capacity array loading type")+": "+String:C10($ldcap_lLoadType); Current method name:C684; kTrue)
End case 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
