//%attributes = {}
// Method: ldcap_FreeHoursGet
// 2004.08.20-11:49:11 / Arto Kokkila
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_TEXT:C284($1; $ld_tLoadGroup)  //load group
C_REAL:C285($0; $ld_rFreeCapacity; $2; $ld_rDateTimeToCheck; $ld_rPhaseTimeRemaining; $ld_rMultiplier; $ld_rCapTimeUsed)
C_LONGINT:C283($3; $ld_lGetCumulativeFree; $4; $ld_lCalcLoadFromCriticalDate; $ld_lCapIndex; $ld_lFromStart)
$ld_tLoadGroup:=$1
$ld_rDateTimeToCheck:=$2
$ld_lGetCumulativeFree:=$3  //$3: cumulative free=kTrue, current free = kFalse
$ld_lCalcLoadFromCriticalDate:=$4  //PM: 2009-02-12

$ld_lFromStart:=kTrue
$ld_rFreeCapacity:=0

//ldcap_FREE_CACLULATE (ld_tLoad_Group_id;0;kFalse )
ld_wlg_ARR_LOAD
ldcap_FREE_CACLULATE(ld_tLoad_Group_id; 0; $ld_lCalcLoadFromCriticalDate)

$ld_lCapIndex:=ldcap_IndexFirst($ld_tLoadGroup; _dt RealToDate($ld_rDateTimeToCheck))
If ($ld_lCapIndex>0)
	
	If (ldcap_arCurrentFree{$ld_lCapIndex}=0)
		If ($ld_lGetCumulativeFree=kTrue)
			$ld_rFreeCapacity:=ldcap_arCumulativeFree{$ld_lCapIndex}
		Else 
			$ld_rFreeCapacity:=0  //current free 
		End if 
		
	Else 
		$ld_rDateTimeToCheck:=ldcap_TimeToCapacityMove($ld_lCapIndex; $ld_rDateTimeToCheck)  //;$ld_lFromStart)
		$ld_rCapTimeUsed:=_dt Difference($ld_rDateTimeToCheck; ldcap_arStart{$ld_lCapIndex})
		$ld_rMultiplier:=ldcap_PhaseTimeMultiplier($ld_lCapIndex; 0; $ld_tLoadGroup)
		$ld_rCapTimeUsed:=$ld_rCapTimeUsed*$ld_rMultiplier
		If ($ld_rCapTimeUsed>ldcap_arCurrentFree{$ld_lCapIndex})
			$ld_rCapTimeUsed:=ldcap_arCurrentFree{$ld_lCapIndex}
		End if 
		If ($ld_lGetCumulativeFree=kTrue)
			$ld_rFreeCapacity:=ldcap_arCumulativeFree{$ld_lCapIndex}-ldcap_arCurrentFree{$ld_lCapIndex}+$ld_rCapTimeUsed
		Else 
			$ld_rFreeCapacity:=$ld_rCapTimeUsed  //current free 
		End if 
		
	End if 
End if 
$0:=$ld_rFreeCapacity
