//%attributes = {}
// Method: pr_DynamicActionLimit
// 2008.04.04-03:27:34 / Pasi Mankinen
// © Copyright 2008 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_TEXT:C284($1; $pr_tProduct)
C_REAL:C285($0; $pr_rDynamicActionLimit; $2; $pr_rDynamEstimAvgNeed; $3; $pr_rDynamManufacturingCycle)
C_REAL:C285($pr_rEstimatedAverageNeed; $pr_rSafeStockNeed; $pr_rSafetyStockDuration; $pr_rSafeStock; $pr_rMinimumStock)
C_REAL:C285($pr_rNeed; $pr_rUnfinishedOrdersInWeeks; $pr_rNormalDeliveryLotSize; $pr_rDeliveryPrognosis)
C_LONGINT:C283($pr_lStockLimitCalcType; $pr_lUseDynamic)
C_REAL:C285($pr_rValueMin; $pr_rValueMax)

$pr_tProduct:=$1
$pr_rDynamEstimAvgNeed:=$2
$pr_rDynamManufacturingCycle:=$3

//dynamic action limit calculation

// HÄLYTYSRAJA [kpl]= Tuotanto-osuus [kpl] + 
//   Varaosaosuus [kpl] + Varmuusvarasto-osuus [kpl]

// Tuotanto-osuus [kpl] = Tarve [kpl] pyöristettynä ylöspäin 
//   seuraavaan "Toimituserään [kpl]". Jos tarve = 0 niin tuotantoennuste = 0
// Tarve [kpl] = ("Valm. kesto [vko]"  
//   - "Tilaukset sisällä [vko]") * Ka-menekki [kpl/vko]
// Ka-menekki [kpl/vko] = Tuotannon ka-menekki eri laskentaperiaatteilla:
// (1) Viikkoennuste + (varaosat) (ei toiminnassa) 
// (2) Vuosiennusteen mukaan:
// ka-menekki= "Tuotantomenekki [kpl/vuosi]" / 52
// (3) Toteutuneen menekin mukaan:
// ka-menekki= "Toteutunut ka-menekki [kpl/vko]" 

// Varaosaosuus [kpl] = "Varaosamenekki [kpl/vuosi]" / 52 
//   * ("Valm. kesto [vko]" ? "Tilaukset sisällä [vko]")

// Varmuusvarasto-osuus [kpl] = 
//   Valitaan suurempi seuraavista kahdesta:
// "Varmuusvaraston kesto [vko]" x (Ka-menekki [kpl/vko] 
//   + ("Varaosamenekki [kpl/vuosi]"/ 52))
// "Minimivarasto [kpl]"   


$pr_lStockLimitCalcType:=_fld ValueLong(pr_kStock_Limit_Calc_Type)
$pr_rMinimumStock:=_fld ValueReal(pr_kMinimum_Stock)
$pr_rSafetyStockDuration:=_fld ValueReal(pr_kSafety_Stock_Duration)
$pr_rUnfinishedOrdersInWeeks:=_fld ValueReal(pr_kUnfinished_Orders_In_Weeks)
$pr_rNormalDeliveryLotSize:=_fld ValueReal(pr_kNormal_Delivery_Lot_Size)

$pr_rEstimatedAverageNeed:=Round:C94($pr_rDynamEstimAvgNeed; <>pr_stlim_lRounding)
$pr_rSafeStockNeed:=pr_stlim_SafeStockNeedGet($pr_rSafetyStockDuration; $pr_rEstimatedAverageNeed)
$pr_rSafeStock:=pr_stlim_SafeStockGet($pr_rSafeStockNeed; $pr_rMinimumStock)

$pr_rNeed:=pr_stlim_NeedGet($pr_rDynamManufacturingCycle; $pr_rUnfinishedOrdersInWeeks; $pr_rDynamEstimAvgNeed)
$pr_rDeliveryPrognosis:=pr_stlim_DeliveryPrognosisGet($pr_rNeed; $pr_rNormalDeliveryLotSize)

$pr_rDynamicActionLimit:=pr_stlim_NewStockLimitGet($pr_rDeliveryPrognosis; $pr_rSafeStock)

$pr_lUseDynamic:=_fld ValueLong(pr_kDynamic_Act_Limit_In_Use)
If ($pr_lUseDynamic=kTrue)
	$pr_rValueMin:=_fld ValueReal(pr_kDynamic_Act_Limit_Min_Val)
	$pr_rValueMax:=_fld ValueReal(pr_kDynamic_Act_Limit_Max_Val)
	
	If (($pr_rValueMax=0) & ($pr_rValueMin>0))
		$pr_rValueMax:=MAXLONG:K35:2  //AK: 2008-04-30
	End if 
	
	If ($pr_rValueMin>$pr_rValueMax)
		_err MESSAGE(_lang Current("Product dynamic action limit minimum value is bigger than maximum value")+": "+ksQuoteStart+$pr_tProduct+ksQuoteEnd; Current method name:C684; kFalse)
	Else 
		If ($pr_rValueMin#0)
			If ($pr_rValueMin>$pr_rDynamicActionLimit)
				$pr_rDynamicActionLimit:=$pr_rValueMin
			End if 
		End if 
		If ($pr_rValueMax#0)
			If ($pr_rValueMax<$pr_rDynamicActionLimit)
				$pr_rDynamicActionLimit:=$pr_rValueMax
			End if 
		End if 
	End if 
End if 

$0:=Round:C94($pr_rDynamicActionLimit; <>pr_stlim_lRounding)