//%attributes = {}
// Method: wpa_AUTOMATIC_WPA_TIMES_GET 
// 13.03.12, 00:16:45 / MG_PM
// © Copyright Manage Applications
// Purpose: 
// calculate machine times to fields, MUST NOT change wpa_kTbl current record
//  called from: wpa_ AUTOMATIC_WPA_CREATE -> wpa_AutomaticWpaCreate
// see: wpa_AUTOMATIC_WPA_TIMES_SET, wpa_UnmannedEndTime, wpa_UnmannedMachineTime
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($1; $wpa_tPlateProgram; $2; $wpa_tJsonInfo; $5; $wpa_tLoadGroup)
C_TEXT:C284($wpa_tInfo; $wpa_tOperation; $wpa_tAmount; $wpa_tProductionLot; $wpa_tErrMessage)
C_DATE:C307($wpa_dEndDate; $wpa_dStartDate)
C_TIME:C306($wpa_hEndTime; $wpa_hStartTime)
C_REAL:C285($3; $wpa_rStart; $4; $wpa_rEnd; $6; $wpa_rAutomaticReceiptDelay; $wpa_rHours; $wpa_rUnmannedNotRunTime; $wpa_rUnmannedNotRunTimeTotal; $wpa_rMachineHours)
C_POINTER:C301($7; $wpa_pMachineHours; $8; $wpa_pHours)  // return values
C_REAL:C285($wpa_rCurrentAmount; $wpa_rTotalAmount; $wpa_rMultiplier)
C_LONGINT:C283($9; $wpa_lSetErrorToInfoField; $wpa_lCapIndex; $wpa_lCapIndexLast; $wpa_lInRunRatio; $wpa_lUnmannedShift)

COMPILER_wpa

$wpa_tPlateProgram:=$1
$wpa_tJsonInfo:=$2
//$wpa_tJsonInfo:=_json_ TextFromJsonText ($wpa_tJsonInfo;"FmsUnload")  // read tag "FmsUnload"
$wpa_rStart:=$3
$wpa_rEnd:=$4
$wpa_tLoadGroup:=$5
$wpa_tLoadGroupMachine:=$wpa_tLoadGroup+"_machine"
$wpa_rAutomaticReceiptDelay:=$6
$wpa_pMachineHours:=$7
$wpa_pHours:=$8
$wpa_lSetErrorToInfoField:=$9

$wpa_rMultiplier:=1

$wpa_lUnmannedShift:=4
_prf_ JSON(<>wpa_tAutomaticPrfName; "UnmannedShift"; ->$wpa_lUnmannedShift)

$wpa_dStartDate:=_dt RealToDate($wpa_rStart)
$wpa_hStartTime:=_dt RealToTime($wpa_rStart)
$wpa_dEndDate:=_dt RealToDate($wpa_rEnd)
$wpa_hEndTime:=_dt RealToTime($wpa_rEnd)
$wpa_rHours:=_dt Difference($wpa_rEnd; $wpa_rStart)
$wpa_rMachineHours:=0
$wpa_rUnmannedNotRunTime:=0
$wpa_rUnmannedNotRunTimeTotal:=0

If ($wpa_rHours#0)
	
	$wpa_tPlateProgram:=_str EndParse($wpa_tPlateProgram; ";"; 1)  // remove LOAD or UNLOAD
	If ($wpa_tPlateProgram#"")
		
		// calculate multiplier
		Case of 
			: (Position:C15("UNLOAD"; $wpa_tJsonInfo)>0)
				$wpa_tInfo:=_str EndParse($wpa_tJsonInfo; ";UNLOAD;"; 1)
			: (Position:C15("LOAD"; $wpa_tJsonInfo)>0)
				$wpa_tInfo:=_str EndParse($wpa_tJsonInfo; ";LOAD;"; 1)
			Else 
				$wpa_tInfo:=$wpa_tPlateProgram
		End case 
		Repeat 
			//$wpa_tInfo:=_str TabCrLfReplace
			//$wpa_tInfo:=Replace string($wpa_tInfo;ksQuoteDouble;"")  // remove "double quote"-chars
			//$wpa_tInfo:=_str Parse ($wpa_tInfo;"}";1)  // remove json end-char
			$wpa_tOperation:=_str Parse($wpa_tInfo; ";"; 1)
			$wpa_tAmount:=_str Parse($wpa_tInfo; ";"; 2)
			$wpa_tProductionLot:=_str Parse($wpa_tInfo; ";"; 3)
			If (($wpa_tOperation#"") & ($wpa_tAmount#"") & ($wpa_tProductionLot#""))
				If ($wpa_tPlateProgram=($wpa_tOperation+";"+$wpa_tAmount+";"+$wpa_tProductionLot))
					If ($wpa_rCurrentAmount=0)
						$wpa_rCurrentAmount:=Num:C11($wpa_tAmount)
					End if 
				End if 
				$wpa_rTotalAmount:=$wpa_rTotalAmount+Num:C11($wpa_tAmount)
			End if 
			$wpa_tInfo:=_str EndParse($wpa_tInfo; ";"; 3)  // next after 3 ";"
		Until ($wpa_tInfo="")
		
		If (($wpa_rCurrentAmount#0) & ($wpa_rTotalAmount#0))
			$wpa_rMultiplier:=$wpa_rCurrentAmount/$wpa_rTotalAmount  // for ex 1/4 = multiply by 0,25
		Else 
			
			If (($wpa_rCurrentAmount=0) & ($wpa_rTotalAmount#0))
				$wpa_tErrMessage:=_lang Current("Problems with amount calculation")
				If ($wpa_lSetErrorToInfoField=kFalse)
					_err MESSAGE($wpa_tErrMessage; Current method name:C684; kFalse)
				Else 
					$wpa_tInfo:=_str_ WithDelimeterAdd($wpa_tInfo; $wpa_tErrMessage; ksCR)
					_cron_ MESSAGE(kError; $wpa_tErrMessage)
					_fld VALUE_STR_SET(kSet; wpa_kInfo; $wpa_tInfo)
				End if 
			End if 
			
		End if 
		
	End if 
	
	
	// calculate machine and work hours
	COMPILER_ldcap_
	
	ldcap_ MACHINE_LOAD_DATE_SET($wpa_dStartDate; $wpa_dEndDate)
	
	wpa_TIME_PART_ARR_CREATE_INIT($wpa_tLoadGroup; $wpa_dStartDate; $wpa_dEndDate)
	ldcap_ARR_LOAD_SAVE(kLoad; $wpa_tLoadGroupMachine; kFalse)  // load machine data
	$wpa_lCapIndexLast:=ldcap_IndexLast($wpa_tLoadGroupMachine)
	$wpa_lCapIndex:=ldcap_ IndexFirstLoaded($wpa_tLoadGroupMachine; $wpa_dStartDate; $wpa_hStartTime)
	
	If ($wpa_lCapIndex<1)
		$wpa_lCapIndex:=-1  // no end found
		_err MESSAGE(_lang Current("No array index found for load group")+": "+$wpa_tLoadGroup; Current method name:C684; kFalse)
	Else 
		While ($wpa_lCapIndex>0)  // calculate run times, always loop all machine times
			IDLE:C311
			If (ldcap_arCapacity{$wpa_lCapIndex}>0)  // = end and start are the same?
				
				// calculate ldcap_InfoToBrushColor.json prf "ldcap_alBrushInRunRatio" array > 0 times to machine hours field
				$wpa_tInfo:=_str Parse(ldcap_atInfo{$wpa_lCapIndex}; ";"; 2)  // LOAD, CYCLE ON, ERROR and so on...
				$wpa_lInRunRatio:=Num:C11(ldcap_ InfoToBrushColor(3; "ldcap_InfoToBrushColor"; $wpa_tInfo))
				
				// calculate machine hours
				If ($wpa_lInRunRatio>0)
					Case of 
						: (($wpa_rStart>ldcap_arStart{$wpa_lCapIndex}) & ($wpa_rEnd<ldcap_arEnd{$wpa_lCapIndex}))
							//TRACE  // should never come here if wpa_ was created from this same capacity, but manual entrie may overlap
							$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference($wpa_rEnd; $wpa_rStart)  // all inside one machine capacity
							// should come here only once
						: ($wpa_rStart>ldcap_arStart{$wpa_lCapIndex})
							//TRACE  // should never come here if wpa_ was created from this same capacity, but manual entrie may overlap
							$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference(ldcap_arEnd{$wpa_lCapIndex}; $wpa_rStart)  // must be end-start
						: ($wpa_rEnd<ldcap_arEnd{$wpa_lCapIndex})
							//TRACE  // should never come here if wpa_ was created from this same capacity, but manual entrie may overlap
							$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference($wpa_rEnd; ldcap_arStart{$wpa_lCapIndex})  // must be end-start
						Else 
							//$wpa_rMachineHours:=$wpa_rMachineHours+_dt Difference (ldcap_arEnd{$wpa_lCapIndex};ldcap_arStart{$wpa_lCapIndex})  // =ldcap_arCapacity{$wpa_lCapIndex}  
							$wpa_rMachineHours:=$wpa_rMachineHours+ldcap_arCapacity{$wpa_lCapIndex}  // must be end-start
					End case 
				End if 
				
				// --- calculate UnmannedNotRunTimeTotal hours ---
				// wpa_AUTOMATIC_WPA_TIMES_SET, wpa_UnmannedEndTime, wpa_ UNPRODUCTIVE_WPA_CREATE 
				If ($wpa_lInRunRatio>0)  // may not be separate if???
					// run ratio >=1 will break previous UnmannedNotRunTime calculation
					// green work
					If ($wpa_rUnmannedNotRunTime>0)
						If ($wpa_rUnmannedNotRunTime-$wpa_rAutomaticReceiptDelay>0)
							$wpa_rUnmannedNotRunTimeTotal:=$wpa_rUnmannedNotRunTimeTotal+$wpa_rUnmannedNotRunTime
						End if 
					End if 
					$wpa_rUnmannedNotRunTime:=0
					
				Else 
					// non-green work
					// split capacity to part with load goup shift calendar and sum those parts
					If (ldcap_arEnd{$wpa_lCapIndex}>$wpa_rEnd)
						wpa_TIME_PART_ARR_CREATE($wpa_tLoadGroup; ldcap_arStart{$wpa_lCapIndex}; $wpa_rEnd)  // will fill wpa_lPartCount and wpa_arPart... -arrays
					Else 
						wpa_TIME_PART_ARR_CREATE($wpa_tLoadGroup; ldcap_arStart{$wpa_lCapIndex}; ldcap_arEnd{$wpa_lCapIndex})
					End if 
					For ($wpa_lPartIndex; 1; wpa_lPartCount)
						
						// _dt RealToDateTimeString(wpa_arPartEnd{$wpa_lPartIndex})
						Case of 
							: (wpa_arPartEnd{$wpa_lPartIndex}<=$wpa_rStart)
								IDLE:C311  // skip part
							: (wpa_arPartStart{$wpa_lPartIndex}>=$wpa_rEnd)
								$wpa_lPartIndex:=wpa_lPartCount+1  // end part loop, SHOULD end whole loop
								
							Else 
								
								If (wpa_arPartEnd{$wpa_lPartIndex}>$wpa_rEnd)
									wpa_arPartEnd{$wpa_lPartIndex}:=$wpa_rEnd
								End if 
								If (($wpa_lInRunRatio>0) | ((wpa_alPartShift{$wpa_lPartIndex}>=1) & (wpa_alPartShift{$wpa_lPartIndex}#$wpa_lUnmannedShift)))
									// shift is normal work shift will break previous UnmannedNotRunTime calculation
									If ($wpa_rUnmannedNotRunTime>0)
										If ($wpa_rUnmannedNotRunTime-$wpa_rAutomaticReceiptDelay>0)
											$wpa_rUnmannedNotRunTimeTotal:=$wpa_rUnmannedNotRunTimeTotal+$wpa_rUnmannedNotRunTime
										End if 
									End if 
									$wpa_rUnmannedNotRunTime:=0
									
								Else 
									// non productive work shift, non-green work
									$wpa_rUnmannedNotRunTime:=$wpa_rUnmannedNotRunTime+_dt Difference(wpa_arPartEnd{$wpa_lPartIndex}; wpa_arPartStart{$wpa_lPartIndex})
								End if 
								
						End case 
						
					End for   // ($wpa_lPartIndex;1;wpa_lPartCount)
					
				End if 
				// --- calculate work hours end ---
				
			End if 
			
			// check for loop end
			Case of 
				: ($wpa_lCapIndex>=$wpa_lCapIndexLast)
					$wpa_lCapIndex:=-1  // end loop
				: (ldcap_arStart{$wpa_lCapIndex+1}>=$wpa_rEnd)
					$wpa_lCapIndex:=-1  // end loop
				Else 
					$wpa_lCapIndex:=$wpa_lCapIndex+1  // continue loop
			End case 
		End while 
	End if 
	
	If ($wpa_rUnmannedNotRunTime>0)  // last unmanned check
		If ($wpa_rUnmannedNotRunTime-$wpa_rAutomaticReceiptDelay>0)
			$wpa_rUnmannedNotRunTimeTotal:=$wpa_rUnmannedNotRunTimeTotal+$wpa_rUnmannedNotRunTime
		End if 
	End if 
	
End if 

$wpa_rMachineHours:=$wpa_rMachineHours*$wpa_rMultiplier  // no roundig
$wpa_pMachineHours->:=$wpa_rMachineHours

$wpa_rHours:=$wpa_rHours-$wpa_rUnmannedNotRunTimeTotal
$wpa_rHours:=$wpa_rHours*$wpa_rMultiplier  // no roundig
$wpa_pHours->:=$wpa_rHours

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 