// Object Method: so_lbPickUpReceive
// 2005.07.08-13:10:33 / Arto Kokkila
// © Copyright 2005 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_LONGINT:C283($so_lOK; $w_lSoFound)
// in xml definitions: *** add values to sor_ -field-arrays ***
COMPILER_sor_xml_arr(0)
// sor_atXml_Order_Row_Partial_Num
// sor_atXml_Sales_Order_id
// sor_alXml_Row_Number
// sor_alXml_Partial_Delivery_Num
// sor_arXml_Delivered_Quantity
// sor_alXml_Picked

_bc_ READER(kReceive; "")  // receive the data from barcode reader
_time WAIT(3)  // wait so the barcode program has time to write the file

C_LONGINT:C283($so_lRow)
C_TEXT:C284($so_tId)
// get the sales order id of the currently selected row
// it is used to select the default file to open
$so_lRow:=_alp Row(so_lplgPickUpSoArea)
If ($so_lRow>0)
	$so_tId:=so_pick_atSoSales_Order_id{$so_lRow}
Else 
	$so_tId:=""
End if 

// select the result file from a list and read it
$so_lOK:=xml Receive(<>sor_sDeliveryXmlPreference; kFalse; $so_tId)  //in_easygen_receive_SALES

If ($so_lOK=kTrue)
	_tbl WRITE_STATE(so_kTbl; kTrue)
	_tbl WRITE_STATE(sor_kTbl; kTrue)
	C_LONGINT:C283($so_lIndex; $so_lArrSize; $so_lCancelled)
	_set EMPTY_CREATE(sor_kTbl; "sor_Received")
	$so_lArrSize:=Size of array:C274(sor_atXml_Sales_Order_id)
	ARRAY TEXT:C222(sor_atXml_Order_Row_Partial_Num; $so_lArrSize)
	_thm OPEN($so_lArrSize; _lang Current("Collecting sales order rows..."); _lang Current("Receive"); True:C214)
	
	For ($so_lIndex; 1; $so_lArrSize)
		_thm UPDATE($so_lIndex)
		If (_thm Cancelled=kTrue)
			$so_lIndex:=$so_lArrSize
		Else 
			sor_atXml_Order_Row_Partial_Num{$so_lIndex}:=sor_atXml_Sales_Order_id{$so_lIndex}+"/"+String:C10(sor_alXml_Row_Number{$so_lIndex}; "000")+"#"+String:C10(sor_alXml_Partial_Delivery_Num{$so_lIndex}; "000")
			
			//find sales order row       
			_qry Fld(sor_kTbl; sor_kSales_Order_id; "="; ->sor_atXml_Sales_Order_id{$so_lIndex}; "*"; kFalse)
			_qry Fld(sor_kTbl; sor_kRow_Number; "="; ->sor_alXml_Row_Number{$so_lIndex}; "&*"; kFalse)
			_qry Fld(sor_kTbl; sor_kPartial_Delivery_Number; "="; ->sor_alXml_Partial_Delivery_Num{$so_lIndex}; "&"; kFalse)
			//
			If (_sel RecsInSel(sor_kTbl)<=0)
				_err MESSAGE(_lang Current("Sales order row was not found")+": "+sor_atXml_Order_Row_Partial_Num{$so_lIndex}; Current method name:C684; kFalse)
				
				//        SET QUERY DESTINATION(Into variable ;$w_lSorCount)
				//        _qry Fld (sor_kTbl ;sor_kSales_Order_id ;"=";->sor_atXml_Sales_Order_i
				//~d{$so_lIndex};"";kFalse )
				//        SET QUERY DESTINATION(Into current selection )
				
				$w_lSoFound:=_qry Fld(so_kTbl; so_kSales_Order_ID; "="; ->sor_atXml_Sales_Order_id{$so_lIndex}; ""; kFalse)
				Case of 
					: ($w_lSoFound=0)
						_err MESSAGE(_lang Current("Sales order was not found")+": "+sor_atXml_Sales_Order_id{$so_lIndex}; Current method name:C684; kFalse)
					: ($w_lSoFound>1)
						_err MESSAGE(_lang Current("More than one Sales order was found")+": "+sor_atXml_Sales_Order_id{$so_lIndex}; Current method name:C684; kFalse)
					Else 
						//Create new sales order row if something was collected
						If (sor_atXml_Collected_Amount{$so_lIndex}#"") & (sor_atXml_Collected_Amount{$so_lIndex}#"0")
							C_LONGINT:C283($so_lRowNumber)
							// find all rows for getting row num 
							_qry Fld(sor_kTbl; sor_kSales_Order_id; "="; ->sor_atXml_Sales_Order_id{$so_lIndex}; ""; kFalse)
							$so_lRowNumber:=_sel Max(sor_kRow_Number)+1
							_rec CREATE(sor_kTbl)
							xapp TblRun(sor_kTbl; sor_kTbl; kNoEvent)
							// product id
							$w_lSoFound:=_qry Fld(pr_kTbl; pr_kEAN_Code; "="; ->sor_atXml_Product_id{$so_lIndex}; ""; kFalse)
							If ($w_lSoFound<1)
								$w_lSoFound:=_qry Fld(pr_kTbl; pr_kProduct_ID; "="; ->sor_atXml_Product_id{$so_lIndex}; ""; kFalse)
							End if 
							Case of 
								: ($w_lSoFound=0)
									_err MESSAGE(_lang Current("Product was not found")+": code "+sor_atXml_Product_id{$so_lIndex}; Current method name:C684; kFalse)
								: ($w_lSoFound>1)
									_err MESSAGE(_lang Current("More than one Product was found")+": EAN code "+sor_atXml_Product_id{$so_lIndex}; Current method name:C684; kFalse)
								Else 
									_fld VALUE_STR_SET(kSet; sor_kProduct_id; _fld ValueStr(pr_kProduct_ID))  //set field value
									xapp TblRun(sor_kProduct_id; sor_kTbl; kNoEvent)  //run field script
									// row number
									_fld VALUE_LONG_SET(kSet; sor_kRow_Number; $so_lRowNumber)
									xapp TblRun(sor_kRow_Number; sor_kTbl; kNoEvent)
									// ordered amount
									_fld VALUE_REAL_SET(kSet; sor_kOrdered_Amount; Num:C11(sor_atXml_Collected_Amount{$so_lIndex}))
									xapp TblRun(sor_kOrdered_Amount; sor_kTbl; kNoEvent)
									// waiting for delivery
									_fld VALUE_REAL_SET(kSet; sor_kWaiting_For_Delivery; Num:C11(sor_atXml_Collected_Amount{$so_lIndex}))
									xapp TblRun(sor_kWaiting_For_Delivery; sor_kTbl; kNoEvent)
									// amount to collect
									_fld VALUE_STR_SET(kSet; sor_kAmount_To_Collect; sor_atXml_Collected_Amount{$so_lIndex})
									xapp TblRun(sor_kAmount_To_Collect; sor_kTbl; kNoEvent)
									// collected amount
									_fld VALUE_STR_SET(kSet; sor_kCollected_Amount; sor_atXml_Collected_Amount{$so_lIndex})
									xapp TblRun(sor_kCollected_Amount; sor_kTbl; kNoEvent)
									
									_rec SAVE(sor_kTbl)
									_rec NEXT(sor_kTbl)
							End case 
						End if 
				End case 
			Else 
				//update collected amounts to sales order row
				
				_rec LOCKED_WAIT(sor_kTbl; kTrue)
				If (OK=1)
					// if the product has not been picked at all, collected amount will be zero
					// if 0 is collected, nothing is left and collected amount is blank
					_fld VALUE_STR_SET(kSet; sor_kCollected_Amount; sor_atXml_Collected_Amount{$so_lIndex})
					xapp TblRun(sor_kCollected_Amount; sor_kTbl; kNoEvent)
					
					//*** aseta kentät tässä ***            
					_rec SAVE(sor_kTbl)
					_rec UNLOAD(sor_kTbl)
				End if 
				
			End if 
		End if 
	End for 
	_thm CLOSE
	
	COMPILER_sor_xml_arr(0)
	_tbl WRITE_STATE(so_kTbl; kPrevious)
	_tbl WRITE_STATE(sor_kTbl; kPrevious)
	_rec NEXT(so_kTbl)
	_rec NEXT(sor_kTbl)
	
	//get new values to lower area 
	so_PICKUP_SO_SELECT
End if 