//%attributes = {}
//******************************************************************************
//Method: SDA_Clipboards
//Written by  Tod Gentille on 9/25/1998
//
//Purpose: Handle the popup for cut copy and pasting from the five clipboards
//can easily be extended for more clipboards by adding a new 
//clipboard variable and the three case statements to handle that clipboard
//
//$1 - pointer to the clipboard popup menu
//
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************
C_POINTER:C301($1; $pPopupMenu)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)

C_LONGINT:C283(<>lSDA_DecideByContents)

$pPopupMenu:=$1

$iSelItem:=$pPopupMenu->  //Find out which item was selected in the popup
$tChoice:=$pPopupMenu->{$iSelItem}  //Get the selected item
If ($iSelItem>0)
	//4D BUG WORKAROUND  
	//There seems to be a bug in the Num function for 6.0.5r7 where any
	//of the strings that contain the word paste return the value 0
	//so as a workaround just start at the 7th character to get past the word paste
	//in any of the choices
	<>lSDA_DecideByContents:=Num:C11(Substring:C12($tChoice; 7))  //extract the clipboard number from the choice string
	//Now find out if the choice has cut, copy or paste
	$tChoice:=_str_ ToLower($tChoice)
	Case of 
			
		: (Position:C15(<>SDA_CUT; $tChoice)#0)
			SDA_ClipboardOps(<>SDA_CUT; -><>lSDA_DecideByContents)
			
		: (Position:C15(<>SDA_COPY; $tChoice)#0)
			SDA_ClipboardOps(<>SDA_COPY; -><>lSDA_DecideByContents)
			
		: (Position:C15(<>SDA_PASTE; $tChoice)#0)
			SDA_ClipboardOps(<>SDA_PASTE; -><>lSDA_DecideByContents)
			
		Else 
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; "Method: SDA_Clipboards"; $tChoice)
	End case 
	
End if 
