//%attributes = {}
//******************************************************************************
//Method: SDA_SwapSides
//
//Written by  Tod Gentille on 12/4/97
//
//Purpose: Swap what is on the right side of the := operator with what is on the 
//left. Only does anything on lines that have a := operator before a comment
//character. If the line has no := or is a comment nothing happens to that line
//This allows you to select a wider range of lines in a single operation
//NOTE: You must select the ENTIRE line, this routine assumes each 
//line ends with a CR character, make sure to get all of the last line
//or the last character will be stripped when swapping
//
//Copyright 1997 Syncor Systems, Inc.
//******************************************************************************
C_LONGINT:C283($i; $iArraySize; $lFindAssignment; $lFindComment)
C_TEXT:C284($tLeftSide; $tRightSide; $tSource)
C_TEXT:C284(<>tSDA_Scrap)  //delcare it here again just to be safe in case user extracts this routine
//for some other use

ARRAY TEXT:C222(<>atSDA_SourceLine; 0)  //These two arrays are only to be used locally
//other routines now use them, don't rely on their contents being preserved 
ARRAY TEXT:C222(<>atSDA_DestLine; 0)

SDA_ClipboardOps(<>SDA_COPY; -><>tSDA_Scrap)
SDA_util_Parse(<>tSDA_Scrap; -><>atSDA_SourceLine)
$iArraySize:=Size of array:C274(<>atSDA_SourceLine)
ARRAY TEXT:C222(<>atSDA_DestLine; $iArraysize)

For ($i; 1; $iArraysize)  //for each line in selection
	$tSource:=<>atSDA_SourceLine{$i}
	$lFindAssignment:=Position:C15(<>SDA_ASSIGNMENT; $tSource)  //Search for 4Ds gets (:=) operator
	
	If ($lFindAssignment>0)  //If assignment operator found
		$lFindComment:=Position:C15(<>SDA_COMMENT_CHAR; $tSource)  //search for 4Ds comment character
		
		If (($lFindComment=0) | ($lFindComment>$lFindAssignment))  //if comment character not found or found after the assignment character
			$tLeftSide:=Substring:C12($tSource; 1; $lFindAssignment-1)
			$tRightSide:=Substring:C12($tSource; $lFindAssignment+2)
			//when selecting lines the entire line must be highlighted because
			//the routine assumes the last character is a CR on every line incl the last line
			$tRightSide:=Substring:C12($tRightSide; 1; Length:C16($tRightSide)-1)  //strip off the CR
			<>atSDA_DestLine{$i}:=$tRightSide+":="+$tLeftside+Char:C90(Carriage return:K15:38)
			
		Else   //an assignment statement was found in a comment, ignore it
			<>atSDA_DestLine{$i}:=$tSource
		End if   //    If (($lFindComment=0) | ($lFindComment>$lFindAssignment))  `if comment chara
		
	Else   //no assignment character sequence was found
		<>atSDA_DestLine{$i}:=$tSource
	End if   //  If ($lFindAssignment>0)  `If assignment operator found
	
End for   //For ($i;1;$iArraysize)  `for each line in selection

//Now put the array elements back together as a single text var
<>tSDA_Scrap:=""

For ($i; 1; $iArraysize)  //for each line in the selection
	<>tSDA_Scrap:=<>tSDA_Scrap+<>atSDA_DestLine{$i}
End for   //For ($i;1;$iArraysize)  `for each line in the selection

SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)

//Clean up memory
<>tSDA_Scrap:=""
ARRAY TEXT:C222(<>atSDA_DestLine; 0)
ARRAY TEXT:C222(<>atSDA_SourceLine; 0)
