//%attributes = {}
//******************************************************************************
//Method: SDA_util_PostWaitChange(OldContents)->Status
//Written by  Tod Gentille on 4/20/98
//
//Purpose: Wait for the contents of the clipboard to change from the 
//passed old contents. Typically used from the SDA_ClipboardOps
//for copying and cutting keys. The clipboard gets set to some 
//predetermined value and then the copy or cut key is posted
//Only loop a maximum number of times, return error
//if clipboard doesn't change after that

//$1 - text -the text that was manually set in the clipboard 
//$0- boolean - return true if all works
//Copyright 1998 Syncor Systems, Inc.
//
//******************************************************************************
C_BOOLEAN:C305($0)
C_LONGINT:C283($iCount)
C_TEXT:C284($1; $tOldContents; $tCurrentContents)

$tOldContents:=$1

$iCount:=1

Repeat 
	DELAY PROCESS:C323(Current process:C322; 1)
	
	If (Pasteboard data size:C400(Text data:K20:2)>0)  //is there any text on the clipboard
		$tCurrentContents:=Get text from pasteboard:C524
		$iCount:=$iCount+1
		
	Else   //there is no text, could mean a picture was copied, so we are done
		$tCurrentContents:=""
	End if 
	
Until (($iCount><>SDA_MAX_WAIT_LOOP) | ($tCurrentContents#$tOldContents))

$0:=($iCount<<>SDA_MAX_WAIT_LOOP)
