//%attributes = {"publishedSql":true}
// Method: _date_StrToDate
// 2001.01.18-20:42:48 / Pasi Mankinen
// © Copyright 2001 Tom Dillon, DataCraft, 
// modified by Pasi Mankinen, Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
// Project Method: StringToDate (string) --> Date

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Tom Dillon, DataCraft

// Function: Returns the date equivalent of the string passed

// Called from HandleDate

// This works for MM/DD/YY & DD/MM/YY forms.
// Two digit years are resolved as per the SET DEFAULT CENTURY command.

// Dates can be enter with any character as a delimiter.
// If no year is entered, the current year is assumed.
// If only a one or two digit number is entered, the current month is assumed.

// If no delimiter is used, the following formats are supported:
//   070476 Returns a date of 07/04/76
//   07041976 Returns a date of 07/04/1976
//   0704 Returns 07/04/00 (If this is in fact the year 2000)
//   07 or 7 Returns the 7th day of the current month
//   74, 704 and 074 are not supported


C_DATE:C307($0; $_date_Date; $_date_Today)
C_TEXT:C284($1; $_date_DateStr; $_date_DateStr2; $_date_ThisYearStr; $_date_ThisMonthStr)
C_BOOLEAN:C305($_date_USDates)
C_LONGINT:C283($_date_DateStrLen; $_date_Slash1; $_date_Slash2)


$_date_DateStr:=$1
$_date_Today:=_date Current(kTrue)
$_date_ThisYearStr:=String:C10(Year of:C25($_date_Today); "0000")
$_date_ThisMonthStr:=String:C10(Month of:C24($_date_Today))
$_date_Slash1:=0
$_date_Slash2:=0

$_date_USDates:=Day of:C23(Date:C102("1/2/2000"))=2  // US-M/D/Y, Not US-D/M/Y, Others not supported

For ($_date_i; 1; Length:C16($_date_DateStr))
	If (($_date_DateStr[[$_date_i]]<"0") | ($_date_DateStr[[$_date_i]]>"9"))  // if it's not 0-9, it must be a delimiter
		$_date_DateStr[[$_date_i]]:="/"
	End if 
End for 

Repeat 
	$_date_DateStr2:=$_date_DateStr
	$_date_DateStr:=Replace string:C233($_date_DateStr2; "//"; "/")  // Since we replaced everthing but numbers with "/", better check for dups
	$_date_Done:=$_date_DateStr=$_date_DateStr2  // If no changes, then we're done
Until ($_date_Done)

$_date_DateStrLen:=Length:C16($_date_DateStr)
If ($_date_DateStrLen>0)
	If ($_date_DateStr[[1]]="/")  // If the first character is a slash, drop it
		$_date_DateStr:=Substring:C12($_date_DateStr; 2)
	End if 
End if   // ($_date_DateStrLen>0)

$_date_DateStrLen:=Length:C16($_date_DateStr)
If ($_date_DateStrLen>0)
	If (Substring:C12($_date_DateStr; $_date_DateStrLen; 1)="/")  // If the last character is a slash, drop it
		$_date_DateStr:=Substring:C12($_date_DateStr; 1; $_date_DateStrLen-1)
	End if 
Else 
	$_date_DateStr:="00/00/00"
End if   // ($_date_DateStrLen>0)

$_date_DateStrLen:=Length:C16($_date_DateStr)
$_date_Slash1:=Position:C15("/"; $_date_DateStr; *)  //v11 ;*
If (($_date_Slash1>0) & ($_date_Slash1<$_date_DateStrLen))
	$_date_Slash2:=Position:C15("/"; Substring:C12($_date_DateStr; $_date_Slash1+1); *)  //v11 ;*
	If ($_date_Slash2>0)
		$_date_Slash2:=$_date_Slash2+$_date_Slash1
	End if 
Else 
	$_date_Slash2:=0
End if   // ($_date_Slash1>0)

$_date_DateSubStr1:="00"
$_date_DateSubStr2:="00"
$_date_DateSubStr3:="00"

Case of 
	: ($_date_DateStr="")  // Skip the rest if the string is blank
		
	: ($_date_Slash2>0)  // There are two slashes
		$_date_DateSubStr1:=Substring:C12($_date_DateStr; 1; $_date_Slash1-1)
		$_date_DateSubStr2:=Substring:C12($_date_DateStr; $_date_Slash1+1; $_date_Slash2-$_date_Slash1-1)
		$_date_DateSubStr3:=Substring:C12($_date_DateStr; $_date_Slash2+1)
		
	: ($_date_Slash1>0)  // Only one slash 
		$_date_DateSubStr1:=Substring:C12($_date_DateStr; 1; $_date_Slash1-1)
		$_date_DateSubStr2:=Substring:C12($_date_DateStr; $_date_Slash1+1)
		$_date_DateSubStr3:=$_date_ThisYearStr  // Assume current year
		
		// No slashes (there are still some possibilities)
	: ($_date_DateStrLen<=2)  // Just the day was entered (1-2 characters)
		If ($_date_USDates)
			$_date_DateSubStr1:=$_date_ThisMonthStr
			$_date_DateSubStr2:=$_date_DateStr
		Else 
			$_date_DateSubStr1:=$_date_DateStr
			$_date_DateSubStr2:=$_date_ThisMonthStr
		End if 
		$_date_DateSubStr3:=$_date_ThisYearStr  // Assume current year
		
	: ($_date_DateStrLen=4)  // Month and day were entered (4 characters, 3 is too tough)
		$_date_DateSubStr1:=Substring:C12($_date_DateStr; 1; 2)
		$_date_DateSubStr2:=Substring:C12($_date_DateStr; 3; 2)
		$_date_DateSubStr3:=$_date_ThisYearStr  // Assume current year
		
	: ($_date_DateStrLen>=6)  // Month and day were entered (6 or more characters)
		$_date_DateSubStr1:=Substring:C12($_date_DateStr; 1; 2)
		$_date_DateSubStr2:=Substring:C12($_date_DateStr; 3; 2)
		$_date_DateSubStr3:=Substring:C12($_date_DateStr; 5)
End case 

$_date_Date:=Date:C102($_date_DateSubStr1+"/"+$_date_DateSubStr2+"/"+$_date_DateSubStr3)
$_date_Date:=_date Add($_date_Date; 0; 0; 0)
$0:=$_date_Date
