//%attributes = {"publishedSql":true}
// Method: _http_HeaderSend
// 2004.01.30-16:29:10 / Pasi Mankinen
// © Copyright 2004 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

If (False:C215)
	// Proc: http_SendHeader
	// Sends the beginning of a default HTTP answer header
	
	// $1 -> SocketRef
	// $2 -> HTTP error (ex: "200 OK")
	// $3 -> Content-Type (ex: "text/html")
	// $4 -> Content-Length (none if 0)
	
	// Ex:  HTTP_SendHeader($socket;$error;$type;$length)
End if 

C_LONGINT:C283($0; $1; $4; $_tcp_lHitLength; $_http_lErr)
C_TEXT:C284($2; $3; $_http_tHeader; $_http_tHeaderFlush)

_http_lHitError:=Num:C11(Substring:C12($2; 1; 3))  // keep the HTTP Error returned
_http_tHitHeader:=$2
$_tcp_lHitLength:=$4
$_http_tHeaderFlush:=""

If (Substring:C12(_http_tHitHeader; Length:C16(_http_tHitHeader)-1)=ksCRLF)
	$_http_tHeaderFlush:=ksCRLF
	_http_tHitHeader:=Substring:C12(_http_tHitHeader; 1; Length:C16(_http_tHitHeader)-2)
End if 

$_http_tHeader:="HTTP/1.0 "+_http_tHitHeader+ksCRLF  // sorry, we only support HTTP/1.0 (with a couple of extensions)
$_http_tHeader:=$_http_tHeader+"Date: "+_http_ DateTimeToRFC(Current date:C33; Current time:C178; 1)+ksCRLF
If (_http_lHitError#304)  // do not send server banner and optional info for cached requests
	$_http_tHeader:=$_http_tHeader+"Server: "+<>_http_tServerBanner+ksCRLF
	$_http_tHeader:=$_http_tHeader+"Accept-Ranges: bytes"+ksCRLF  // we support byte range serving
End if 

If ($3#"")
	$_http_tHeader:=$_http_tHeader+"MIME-Version: 1.0"+ksCRLF
	$_http_tHeader:=$_http_tHeader+"Content-Type: "+$3+ksCRLF
End if 

If (($_tcp_lHitLength#0) | (_http_lHitError=304))  // CQ 27/2/99 - allow keepalive on "304 Not modified" answers
	$_http_tHeader:=$_http_tHeader+"Content-Length: "+String:C10($_tcp_lHitLength)+ksCRLF
	If (_tcp_lKeepAlive=kTrue)
		If (_tcp_tKeepAliveHeader#"")
			$_http_tHeader:=$_http_tHeader+"Keep-Alive: "+_tcp_tKeepAliveHeader+ksCRLF  // CQ 14/4/99 -  added Keep-Alive infos in answer header
		End if 
		$_http_tHeader:=$_http_tHeader+"Connection: Keep-Alive"+ksCRLF
	End if 
Else 
	_tcp_lKeepAlive:=kFalse
End if 
// do not forget to send the remaining of the header
If ($_http_tHeaderFlush#"")
	$_http_tHeader:=$_http_tHeader+$_http_tHeaderFlush
End if 
$_http_lErr:=_tcp_ TextSend($1; $_http_tHeader)
_http_tSendHeader:=$_http_tHeader

If ($_http_lErr>0)
	_http_lDataSent:=_http_lDataSent+$_http_lErr
End if 
$0:=_http_lDataSent

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 