//%attributes = {}
// (PM) _mb4d_MethodResIdFind
// This method returns the ID of the CC4D resource for the specified
// project method. This resource contains a tokenized version of the
// program code of the project method.
// $1 = Method name
// $0 = Resource ID

C_TEXT:C284($_mb4d_tMethodName; $_mb4d_tCurrentMethodName)
C_LONGINT:C283($0; $_mb4d_lResID; $i; $_mb4d_lError; $_mb4d_lRecordLength; $_mb4d_lCount; $_mb4d_lStart; $_mb4d_lOffset)
C_BLOB:C604($vx_Data)

$_mb4d_tMethodName:=$1
$_mb4d_lRecordLength:=44
$_mb4d_lResID:=-1

// Get the list of project methods
// v19: $_mb4d_lError:=API Get Resource("TP4D"; 0; $vx_Data)

If ($_mb4d_lError=0)
	
	// Added code by Thomas S. for compatibility with 4D v11 SQL
	If (Num:C11(Application version:C493)>=1100)
		DELETE FROM BLOB:C560($vx_Data; 0; 8)
		$_mb4d_lRecordLength:=76
	End if 
	
	// Get the number of methods
	$_mb4d_lCount:=BLOB size:C605($vx_Data)\$_mb4d_lRecordLength
	
	$_mb4d_lStart:=0
	For ($i; 1; $_mb4d_lCount)
		
		// Get the current method name
		$_mb4d_lOffset:=$_mb4d_lStart
		$_mb4d_tCurrentMethodName:=BLOB to text:C555($vx_Data; Mac Pascal string:K22:8; $_mb4d_lOffset)
		
		// If we found the requested methodname
		If ($_mb4d_tCurrentMethodName=$_mb4d_tMethodName)
			// Get the ID of the corresponding CC4D resource and jump out of the loop      
			$_mb4d_lOffset:=$_mb4d_lStart+32
			$_mb4d_lResID:=BLOB to integer:C549($vx_Data; Native byte ordering:K22:1; $_mb4d_lOffset)
			//$_mb4d_lResID:=API Get Method ID ($_mb4d_tCurrentMethodName)  `v11, same as next BLOB to integer
			$i:=$_mb4d_lCount
		End if 
		
		$_mb4d_lStart:=$_mb4d_lStart+$_mb4d_lRecordLength
		
	End for 
	
End if 

$0:=$_mb4d_lResID