//%attributes = {}
//_prli_SetColumn(Area;ColumnNo;->Array;Header;Width;Format;ColJust;HdrJust)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//FUNCTION: 
//This method allows you to configure many of the settings for a report
//   column, all in one call.
//This command is over and above any PrintList™ commands.


//--------------------------------------------------------------------------------
//PARAMETERS
//$1: Longint: AreaRef
//$2: Longint: Column Number
//$3: Ptr: Pointer to the array/Field/variable
//$4: Text: Header Text
//$5: Longitn: Width.  (pass zero to auto-calculate)
//$6: Format (for numbers/date/boolean)
//$7-N: Text: Miscellaneouls column parameters:
//   ColJust;{ColJustNum}
//   ColFont;{FontName}
//   ColFontSize;{FontSize}
//   ColFontStyle;{StyleNum}

//   HdrJust;{HdrJustNum}
//   HdrFont;{FontName}
//   HdrFontSize;{FontSize}
//   HdrFontStyle;{StyleNum}

//   BrkText;{LevelNum};{Text}
//   BrkOverflowCols;{LevelNum};
//   BrkJust;{LevelNum};{ColJustNum}
//   BrkFont;{LevelNum};{FontName}
//   BrkFontSize;{LevelNum};{FontSize}
//   BrkFontStyle;{LevelNum};{StyleNum}

//   BkHText;{LevelNum};
//   BkHOverflowCols;{LevelNum};
//   BkHJust;{LevelNum};{ColJustNum}
//   BkHFont;{LevelNum};{FontName}
//   BkHFontSize;{LevelNum};{FontSize}
//   BkHFontStyle;{LevelNum};{StyleNum}



//--------------------------------------------------------------------------------
//REVISION HISTORY


//--------------------------------------------------------------------------------


C_LONGINT:C283($1; $_prli_iAreaRef; $_prli_iFindArea)
C_LONGINT:C283($2; $_prli_iStartCol)
C_POINTER:C301($3)  //Array
C_TEXT:C284($4)  //Header
C_LONGINT:C283($5)  //Width
C_TEXT:C284($6)  //Format
C_TEXT:C284(${7}; $_prli_Prm)  //Misc Prms

$_prli_iAreaRef:=$1

$_prli_iFindArea:=_prli_Util_FindAreaRef($_prli_iAreaRef; "_prli_AppendColumn")
If ($_prli_iFindArea>-1)
	
	$_prli_MaxCol:=Size of array:C274(_prli_aArray{$_prli_iFindArea})+1
	If ($2=0)
		$_prli_iStartCol:=$_prli_MaxCol
	Else 
		$_prli_iStartCol:=$2
		If ($_prli_iStartCol>$_prli_MaxCol)
			_info_ ALERT("Start Column is beyond the number of defined columns."+Char:C90(13)+"_prli_SetArraysPtr")
			$_prli_iStartCol:=$_prli_MaxCol
		End if 
	End if 
	
	_prli_SetArraysPtr($_prli_iAreaRef; $_prli_iStartCol; 1; $3)
	If (Count parameters:C259>3)
		_prli_SetHeaders($_prli_iAreaRef; $_prli_iStartCol; 1; $4)
	End if 
	If (Count parameters:C259>4)
		_prli_SetWidths($_prli_iAreaRef; $_prli_iStartCol; 1; $5)
	End if 
	
	If (Count parameters:C259>5)
		_prli_SetFormat($_prli_iAreaRef; $_prli_iStartCol; $6)
	End if 
	
	C_LONGINT:C283($_prli_i)
	For ($_prli_i; 7; Count parameters:C259)
		_prli_Util_SetColMiscPrm($_prli_iFindArea; $_prli_iStartCol; ${$_prli_i})
	End for 
	
End if 
