//%attributes = {}
//******************************************************************************
//
//Method: SDA_HeaderOps(ptrToPasteOpsPopup)
//
//Written by  Tod Gentille on 9/28/98
//
//Purpose: Perform the header operation chosen from the paste popup
//The list was defined with a list and set up in SDA_Startup
//Edit the list to add new items and then add the case
//to process that item here
//
//$1 -ptr to the pop up called via SELF from the popup
//
//Copyright 1998 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, 2/3/99
//Reason: Added code to set auto comment popup text according to status; also
// added status variable as a parameter to SDA_ma_MethodAnalysis.
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 2/4/99
//Reason: Added test for auto comment selection for no selection
//******************************************************************************
C_POINTER:C301($1; $pPopupMenu)
C_LONGINT:C283($iSelItem)
C_TEXT:C284($tChoice)
C_BOOLEAN:C305($bGo)
//All variables that end with _L could be locals except we need to pass pointers
//to them
C_LONGINT:C283(<>lSDA_ma_ControlCounter_L; <>lSDA_ma_MaxDepth_L)
C_TEXT:C284(<>tSDA_MethodAnalysis)

$pPopupMenu:=$1

$bGo:=True:C214  //will set false on error
$iSelItem:=$pPopupMenu->  //Find out which item was selected in the popup
$tChoice:=$pPopupMenu->{$iSelItem}  //Get the selected item
SDA_HeaderOpsCommentTxtSU($pPopupMenu; <>bSDA_ForceRplcComment)  //#### Set commenting text
$pPopupMenu->:=0
If ($iSelItem>0)  //if an item was selected
	
	Case of 
			
		: ($tChoice="Paste Header")
			<>tSDA_Scrap:=SDA_MethodHeader
			SDA_Util_Home
			
		: ($tChoice="Paste Method Name")
			<>tSDA_Scrap:=SDA_util_FrontmostMethodName
			
		: ($tChoice="Paste Comment Line of Dashes")
			<>tSDA_Scrap:="`-------------------------------------------------------------------------------"
			
		: ($tChoice="Paste Modified By...")
			<>tSDA_Scrap:="`"+Current user:C182+": "+_date Format(Current date:C33; "YYYY-MM-DD")
			
		: ($tChoice="Auto Comment Selection@")
			If (SDA_ma_MethodAnalysis(-><>lSDA_ma_ControlCounter_L; -><>lSDA_ma_MaxDepth_L; -><>atSDA_DestLine_L; <>bSDA_ForceRplcComment))
				
				If (Size of array:C274(<>atSDA_DestLine_L)>0)  //if there are lines to auto comment
					SDA_ma_AutoComment(-><>atSDA_DestLine_L; -><>tSDA_Scrap)
					
				Else   //no lines to auto comment
					_info_ ALERT("The selection was empty. Please select some text to update.")
				End if   //        If (Size of array(<>atSDA_DestLine_L)>0)  `if there are lines to auto com
			End if   //      If (SDA_ma_MethodAnalysis (-><>lSDA_ma_ControlCounter_L;-><>lSDA_ma_MaxDepth
			
		: ($tChoice="Auto Comment Entire Method@")
			SDA_util_PostSelectAll
			If (SDA_ma_MethodAnalysis(-><>lSDA_ma_ControlCounter_L; -><>lSDA_ma_MaxDepth_L; -><>atSDA_DestLine_L; <>bSDA_ForceRplcComment))
				SDA_ma_AutoComment(-><>atSDA_DestLine_L; -><>tSDA_Scrap)
			End if   //      If (SDA_ma_MethodAnalysis (-><>lSDA_ma_ControlCounter_L;-><>lSDA_ma_MaxDepth
			
		: ($tChoice="Auto Comment & Analyze Method@")
			<>tSDA_MethodAnalysis:=""
			SDA_util_PostSelectAll
			If (SDA_ma_MethodAnalysis(-><>lSDA_ma_ControlCounter_L; -><>lSDA_ma_MaxDepth_L; -><>atSDA_DestLine_L; <>bSDA_ForceRplcComment))
				SDA_ma_AutoComment(-><>atSDA_DestLine_L; -><>tSDA_Scrap)
				SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)  //do the paste now or the analysis dialog will prevent it
				$bGo:=False:C215  //no need to try and paste at end of case
				SDA_ma_BuildAnalysisMsg(<>lSDA_ma_ControlCounter_L; <>lSDA_ma_MaxDepth_L; -><>tSDA_MethodAnalysis)
				SDA_ma_ShowAnalysis
			End if   //      If (SDA_ma_MethodAnalysis (-><>lSDA_ma_ControlCounter_L;-><>lSDA_ma_MaxDepth
			
		: (SDA_HeaderOps_y($tChoice))  //Your added operations should be put in this method
			
		Else   //no recognized selection
			$bGo:=False:C215
			SDA_util_BugAlert(<>SDA_UNEXPECTED_PARAM; "Method: SDA_HeaderOps"; $tChoice)
	End case   //  Case of 
	
	If ($bGo)  //if we should paste something
		
		If (<>tSDA_Scrap="")  //if there is nothing to paste
			//not a problem
			
		Else   //something to paste
			SDA_ClipboardOps(<>SDA_PASTE; -><>tSDA_Scrap)
			<>tSDA_Scrap:=""
		End if   //(<>tSDA_Scrap="")  `if there is nothing to paste
		
	End if   //($bGo)  `if we should paste something
	
End if   //($iSelItem>0)  `if an item was selected
