//%attributes = {}
//******************************************************************************
//Method: SDA_SimilarOpen
//
//Written by  Tod Gentille on 11/3/97
//
//Purpose: Opens all the methods with a similar name
//
//Copyright 1997 Syncor Systems, Inc.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 3/1/99
//Reason: If the search string matched methods at the alphabetical end of
// the project method list, the repeat loop below never ended because it would
// always find the last method and it would match the search string. I corrected
// this by saving the last opened method name and comparing it to the next
// "opened" method.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 3/8/99
//Reason: Made further improvements so that the first method opened is handled
// correctly if it does not match the search string.
//
//Modified by: Cyril Harnisch, Syncor Systems, Inc., 3/9/99
//Reason: Tod & I decided to change the logic of this function. It will no longer
// try to open whatever is selected in the Explorer first. It will just present
// the designer with a request dialog for the leading characters. It will also
// close the Explorer when finished only if the explorer was not open to begin
// with.
//******************************************************************************
C_TEXT:C284($tWinTitle; $tStartsWith; $tLastOpenedMethodName)
ARRAY LONGINT:C221(<>alWinRef_L; 0)
C_LONGINT:C283($lFound)
C_BOOLEAN:C305($bExplorerWinOrigOpen)

WINDOW LIST:C442(<>alWinRef_L)  //get list of windows that are currently open.
$bExplorerWinOrigOpen:=SDA_util_IsExplorerWinOpen  //if the Explorer window is open
//
//Even if it fails just get the title of the frontmost window to prompt the user
BEEP:C151
BEEP:C151
$tWinTitle:="Type Method Prefix..."
$tLastOpenedMethodName:=$tWinTitle  //initialize to request instructions
$tStartsWith:=_info_ Request(<>SDA_OPEN_PROMPT; $tWinTitle; "Open Similar")

If (OK=1)  //if user hit accept from request dialog
	
	If (SDA_util_GotoExplorerMethodTab)  //if the Explorer's Method tab is selected
		//  SDA_util_PostKey (Home Key;0)  `move to the top of the explorer project method
		//------------------------------------------------------------------------------- 
		//Now bring the explorer to front, post a down arrow, then Enter
		//get the win title and if it matches $tStartsWith keep going
		//else close the window that didn't match  if it wasn't already open
		//if it was open keep it open. its win ref will be in <>alWinRef_L if it was open 
		//Move down to the first method that 4D thinks starts with the designated chars
		SDA_util_PostString($tStartsWith)
		SDA_util_OpenExplorerMethod  //open the currently highlighted method in the Explorer
		$tWinTitle:=SDA_util_GetWinTitleStripped
		$lFound:=Position:C15($tStartsWith; $tWinTitle)
		
		If ($lFound>0)  //if the 1st-opened method starts with the string
			
			Repeat   //for each method which starts with the entered string.
				// Note that 4D will open the next (non-matching) method if
				// a match is not found.
				
				If (SDA_util_OpenNextExplorerMethod)  //if we could open the next method window
					$tWinTitle:=SDA_util_GetWinTitleStripped
					$lFound:=Position:C15($tStartsWith; $tWinTitle)
					
					Case of   //if method not found or same as last found method
							
						: ($tWinTitle=$tLastOpenedMethodName)  //if method was previously opened
							$lFound:=0  //indicate it's time to quit looping
							
						: ($lFound=0)  //if window does not start with desired string
							SDA_util_CloseIfNewWindow(-><>alWinRef_L)  //close it if it wasn't right to start with
							
						Else   //found a new method matching prefix
							$tLastOpenedMethodName:=$tWinTitle  //save last opened method name to make sure
							// 4D hasn't opened the same method at the end of the method list.
					End case   //          Case of   `if method not found or same as last found method
					
				Else   //could not open the method window for some reason, let's exit the loop
					SDA_util_BugAlert(<>SDA_GENERAL_ERROR; " Method: SDA_SimilarOpen ")
					$lFound:=0  //indicate it's time to quit looping
				End if   //        If (SDA_util_OpenNextExplorerMethod )  `if we could open the next method
				
			Until ($lFound=0)  //      Repeat   `for each method which starts with the entered string.
			
		Else   //first method does not start with the string      
			SDA_util_CloseIfNewWindow(-><>alWinRef_L)  //close it if it wasn't right to start with
		End if   //    If ($lFound>0)  `if the 1st-opened method starts with the string
		
	End if   //  If (SDA_util_GotoExplorerMethodTab )  `if the Explorer's Method tab is selecte
	
	If ($bExplorerWinOrigOpen)  //if the Explorer window was originally open
		//leave it open
		
	Else 
		
		If (SDA_util_BringExplorerToFront)  //if the Explorer can be brought to the fore    
			SDA_util_PostKey(Space:K15:42; Command key mask:K16:1)  //close Explorer
			
		Else   //Explorer cannot be brought to the fore
			//do nothing      
		End if 
		
	End if 
	
End if   //If (OK=1)  `if user hit accept from request dialog
