//%attributes = {}
//******************************************************************************
//Method: SDA_ToolOpts_ClpbrdPrsrvToggle
//Written by  Cyril Harnisch on 2/22/99
//
//Purpose: Handle the text for the Preserve Clipboard Toggle in a consistent way. 
// This is used in the SDA_ToolOpts method when the user toggles the
// clipboard status and in the initial setup of the options array.
//
//$1 - Boolean -preserve clipboard flag
//$2 - pointer  - to array of misc options values
//$3 - longint - index for preserve clipboard in above array
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_BOOLEAN:C305($1; $bPreserveClipboard)
C_POINTER:C301($2; $pMiscOptionsArray)
C_LONGINT:C283($3; $lMiscOptsAryIdx)

$bPreserveClipboard:=$1
$pMiscOptionsArray:=$2
$lMiscOptsAryIdx:=$3

If ($bPreserveClipboard)  //if preserving clipboard
	$pMiscOptionsArray->{$lMiscOptsAryIdx}:=<>s40SDA_CLPBD_NONPRESERVE
	
Else   //not preserving clipboard
	$pMiscOptionsArray->{$lMiscOptsAryIdx}:=<>s40SDA_CLPBD_PRESERVE
End if 
