//%attributes = {}
//******************************************************************************
//Method: SDA_util_CheckForInitialChar(pArrayOfTextLines;CharToCheckFor)
//
//Written by  Jeff Kain/Tod Gentille on 5/8/98
//
//Purpose: Look at the current contents of the passed array and determine if the 
//first nonblank line starts with the passed character. Ignore any leading spaces
//or non-breaking spaces that may start the line
//
//$1 - pointer to array of text
//$2 - 1 char string to look fore
//
//Copyright 1998 Syncor Systems, Inc.
//Portions copyright Jeff Kain - used with permission
//******************************************************************************
C_POINTER:C301($1; $paSourceLines)
_O_C_STRING:C293(1; $2)
_O_C_STRING:C293(1; $s1CharToFind)
C_LONGINT:C283($lFirstLineWithText; $i)
C_BOOLEAN:C305($0)
C_TEXT:C284($tStrippedString)

$0:=False:C215  //init to false, set to true if character is found
$paSourceLines:=$1
$s1CharToFind:=$2

// in case the selection of  text  
// contains a few blank lines above the first line, figure out which
// line of the selection is the first to contain any text
$lFirstLineWithText:=0

For ($i; 1; Size of array:C274($paSourceLines->))
	If (Replace string:C233($paSourceLines->{$i}; Char:C90(Carriage return:K15:38); "")#"")  //then we have a line with text
		$lFirstLineWithText:=$i
		$i:=Size of array:C274($paSourceLines->)+1  //force an exit
	End if 
End for 

If ($lFirstLineWithText>0)
	// remove spaces and non breaking spaces and see if first char is our search char
	$tStrippedString:=SDA_util_StripWhiteSpace($paSourceLines->{$lFirstLineWithText})
	If ($tStrippedString[[1]]=$s1CharToFind)
		$0:=True:C214
	End if 
End if 
