//%attributes = {"publishedSql":true}
//*==============================================================================
//Project method : svn_methodTokenise
// Public
//
//DESCRIPTION :
// This method converts a text array containing some code into a CC4D blob 
// ready to bet saved 
//
// PARAMETRES :
//  $1 (POINTER) => text array pointer (the code, not modified)
//  $2 (POINTER) => blob pointer (the CC4D resource, modified)
//  
//NOTES : 
// Based on code provided in the API_Pack demo (Rob Laveaux and Miloslav Bystricky
// who also contributed to the original code)
//
//EXAMPLE D'APPEL : 
//  svn_methodTokenise
//  
//CREATION : Bruno LEGAY (BLE) - 12/04/07, 19:30:33 - v1.00.00
//*===============================================================================

C_POINTER:C301($1)  //text array pointer
C_POINTER:C301($2)  //Blob pointer

C_POINTER:C301($vp_arrayPtr)  //text array pointer
C_POINTER:C301($vp_tokenizedMethodBlobPtr)  //Blob pointer

If (Count parameters:C259>1)
	
	$vp_arrayPtr:=$1
	$vp_tokenizedMethodBlobPtr:=$2
	
	Case of 
		: (Type:C295($vp_arrayPtr->)#Text array:K8:16)
			_info_ ALERT(Current method name:C684+" : $1 is not of the expected type (text array pointer was expected) !")
			
		: (Type:C295($vp_tokenizedMethodBlobPtr->)#Is BLOB:K8:12)
			_info_ ALERT(Current method name:C684+" : $2 is not of the expected type (blob pointer was expected) !")
			
		Else 
			
			ARRAY TEXT:C222($tt_codeLines; 0)
			
			COPY ARRAY:C226($vp_arrayPtr->; $tt_codeLines)
			
			
			C_BLOB:C604($vx_methodBlob)  //CC4D resource content
			C_BLOB:C604($vx_tokenizedLine)
			C_LONGINT:C283($vl_offset; $vl_tokenLineSizeOffset; $vl_tokenLineSize; $vl_lineCount)
			C_TEXT:C284($vt_line)
			
			$vl_lineCount:=Size of array:C274($tt_codeLines)
			
			SET BLOB SIZE:C606($vx_methodBlob; 0)
			$vl_offset:=0
			
			//A method header of 10 bytes
			INTEGER TO BLOB:C548(100; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // Set the window rectangle
			INTEGER TO BLOB:C548(100; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
			INTEGER TO BLOB:C548(500; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
			INTEGER TO BLOB:C548(500; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
			INTEGER TO BLOB:C548(-$vl_lineCount; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // Set the line count (negative for listing)
			
			
			C_LONGINT:C283($vl_lineIndex; $vl_errCode)
			$vl_errCode:=0
			For ($vl_lineIndex; 1; $vl_lineCount)
				$vt_line:=$tt_codeLines{$vl_lineIndex}
				
				If (Length:C16($vt_line)>0)
					
					// Tokenize the method line
					SET BLOB SIZE:C606($vx_tokenizedLine; 0)
					$vl_errCode:=_mb4d_API_Tokenize($vt_line; ->$vx_tokenizedLine)
					If ($vl_errCode#0)  // Bail out of the loop
						$vl_lineIndex:=$vl_lineCount
					End if 
					
					// Get logical size of the tokens
					//at offset 34, we have an integer
					//$vx_tokenizedLine{34}
					//$vx_tokenizedLine{35}
					$vl_tokenLineSizeOffset:=0x0022
					$vl_tokenLineSize:=BLOB to integer:C549($vx_tokenizedLine; Native byte ordering:K22:1; $vl_tokenLineSizeOffset)
					
					
				Else 
					$vl_tokenLineSize:=0
				End if 
				
				//A method line header of 18 bytes
				//Byte 0x00 and 0x01 => integer (native byte ordering) with total line size (tokenizedLineSize + header size which seems to be 16)
				//Byte 0x02 and 0x03 => integer (native byte ordering) NextLine (only used for flowcharts)
				//Byte 0x04 and 0x05 => integer (native byte ordering) tokenizedLineSize
				//Byte 0x06 and 0x07 => integer (native byte ordering) True line (only used for flowcharts)
				//Byte 0x08 and 0x09 => integer (native byte ordering) Unknown
				//Byte 0x0A and 0x0B => integer (native byte ordering) Object position (only used for flowcharts)
				//Byte 0x0C and 0x0D => integer (native byte ordering) Unknown
				//Byte 0x0E and 0x0F => integer (native byte ordering) Unknown
				//Byte 0x10 and 0x11 => integer (native byte ordering) Unknown
				//Byte 0x12 to 0x12+$vl_tokenLineSize => tokenizedLine
				
				// Add the tokenized method to the CC4D resource
				$vl_offset:=BLOB size:C605($vx_methodBlob)
				
				// Add the CC4D token header
				//This is really 18, and not 16
				INTEGER TO BLOB:C548($vl_tokenLineSize+0x0012; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // LineSize = $vl_tokenLineSize + sizeof (header)
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // NextLine (only used for flowcharts)
				INTEGER TO BLOB:C548($vl_tokenLineSize; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // Logical line size
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // True line (only used for flowcharts)
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // Unknown
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // Object position (only used for flowcharts)
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)
				
				If ($vl_tokenLineSize>0)
					//Copying tokenLineSize bytes from tokenizedLine from offset 48 to the methodBlob (at offset $vl_offset)
					COPY BLOB:C558($vx_tokenizedLine; $vx_methodBlob; 0x0030; $vl_offset; $vl_tokenLineSize)  // Tokens
				End if 
				
				$vl_offset:=BLOB size:C605($vx_methodBlob)
				INTEGER TO BLOB:C548(0; $vx_methodBlob; Native byte ordering:K22:1; $vl_offset)  // NextLine (only used for flowcharts)
				
			End for 
			
			SET BLOB SIZE:C606($vp_tokenizedMethodBlobPtr->; 0)
			If ($vl_errCode=0)
				$vp_tokenizedMethodBlobPtr->:=$vx_methodBlob
			End if 
			SET BLOB SIZE:C606($vx_methodBlob; 0)
			
	End case 
	
	// Save the modified resource
	//If ($vl_errCode=0)
	//$vl_errCode:=API Set Resource ("CC4D";$vl_resID;"";$vx_methodBlob)
	//End if 
	//
	//` Add the new method to the method list
	//If ($vb_IsNewMethod&($vl_errCode=0))
	//
	//$vl_errCode:=API Get Resource ("TP4D";0;$vx_methodBlob)` Get the list of methods
	//If ($vl_errCode=0)
	//$vl_offset:=BLOB size($vx_methodBlob)` Get the current size
	//SET BLOB SIZE($vx_methodBlob;$vl_offset+44;0)` Add a new entry for the new method
	//TEXT TO BLOB($vs40_MethodName;$vx_methodBlob;Pascal string ;$vl_offset)` Insert the method name
	//$vl_offset:=BLOB size($vx_methodBlob)-44+32
	//INTEGER TO BLOB($vl_resID;$vx_methodBlob;Native byte ordering ;$vl_offset)
	//$vl_errCode:=API Set Resource ("TP4D";0;"";$vx_methodBlob)
	//
	//_info_ ALERT ("Re-open the structure file to see the changes applied.")
	//End if 
	//
	//End if 
End if 
