//%attributes = {}
//_prli_SetFormat (AreaRef; ColNum; Format; ColJust; HdrJust;
//UsePictHeight)

//Part of the PrintTwist(tm) component by Business Brothers, Inc.
//Written by Tony Ringsmuth

//See Also: _prli_SetFormatPtr
//--------------------------------------------------------------------------------
//PARAMETERS
//$1: Longint: Area Reference
//$2: Longint: Column Number: Pass Zero to configure all columns
//$3: Format
//    To format null Dates or Times as a nullstring, put a minus sign at the end
//     of the format
//    To format a longint column as time, pass "&/{TimeFormatNumber}"
//    Pass "-" to leave the format unchanged from it's prior setting
//$4: Longint: Column Justification
//  -1 = No Change, 0 = Default, 1 = Left, 2 = Center, 3 = Right
//$5: Longint: Column Justification
//  -1 = No Change, 0 = Default, 1 = Left, 2 = Center, 3 = Right
//$6: User Picture Height (currently not supported in PrintTwist)


//Time Formats:
//1     01:02:03 
//2     01:02 
//3     1 hour 2 minutes 3 seconds 
//4     1 hour 2 minutes 
//5     1:02 AM 

//Date Formats:
//0    4/19/05 (default) 
//1    4/19/05 
//2    Tue, Apr 19, 2005 
//3    Tuesday, April 16, 2005 
//4    04/19/2005 or 04/19/1905 
//5    April 19, 2005 
//6    Apr 19, 2005 
//--------------------------------------------------------------------------------
//REVISION HISTORY
//07/30/2007: Enable "-" formats to leave prior settings unchanged
//--------------------------------------------------------------------------------


C_LONGINT:C283($1; $_prli_iAreaRef)
C_LONGINT:C283($2; $_prli_iColNo)
C_TEXT:C284($3)
C_LONGINT:C283($4; $5; $6)
C_BOOLEAN:C305(_prli_bRunAsWrapper)

If (Count parameters:C259>2)  //Need at least 3 parameters to be meaningful.
	$_prli_iAreaRef:=$1
	
	$_prli_iFindArea:=_prli_Util_FindAreaRef($_prli_iAreaRef; Current method name:C684)
	If ($_prli_iFindArea>-1)
		
		$_prli_iColNo:=$2
		
		If (($_prli_iColNo>=0) & ($_prli_iColNo<=Size of array:C274(_prli_aArray{$_prli_iFindArea})))
			
			
			If ($_prli_iColNo=0)
				For ($_prli_iColCtr; 1; Size of array:C274(_prli_aArray{$_prli_iFindArea}))
					If ($3#"-")
						_prli_aFormat{$_prli_iFindArea}{$_prli_iColCtr}:=_str_ FormatChange($3)  // PM 2011-03-01
					End if 
					If (Count parameters:C259>3)
						If ($4#-1)
							_prli_aColJust{$_prli_iFindArea}{$_prli_iColCtr}:=$4
						End if 
					End if 
					If (Count parameters:C259>4)
						If ($5#-1)
							_prli_aHdrJust{$_prli_iFindArea}{$_prli_iColCtr}:=$5
						End if 
					End if 
				End for 
			Else 
				If ($3#"-")
					_prli_aFormat{$_prli_iFindArea}{$_prli_iColNo}:=_str_ FormatChange($3)  // PM 2011-03-01
				End if 
				If (Count parameters:C259>3)
					If ($4#-1)
						_prli_aColJust{$_prli_iFindArea}{$_prli_iColNo}:=$4
					End if 
				End if 
				If (Count parameters:C259>4)
					If ($5#-1)
						_prli_aHdrJust{$_prli_iFindArea}{$_prli_iColNo}:=$5
					End if 
				End if 
			End if   //($iColNo=0)
			
		Else 
			_prli_Util_ColRangeErrAlert($_prli_iFindArea; $_prli_iColNo)
		End if 
		
	End if 
	
	If (_prli_bRunAsWrapper)
		
		$_prli_Execute:="_prli_SetFormat ("+_prli_Util_AreaRefString($_prli_iAreaRef)+";"+String:C10($_prli_iColNo)+";"+Char:C90(34)+$3+Char:C90(34)+";"
		
		If (Count parameters:C259>3)
			$_prli_Execute:=$_prli_Execute+String:C10($4)+";"
		End if 
		If (Count parameters:C259>4)
			$_prli_Execute:=$_prli_Execute+String:C10($5)+";"
		End if 
		If (Count parameters:C259>5)
			$_prli_Execute:=$_prli_Execute+String:C10($6)+";"
		End if 
		
		$_prli_Execute:=Substring:C12($_prli_Execute; 1; Length:C16($_prli_Execute)-1)+")"
		_prli_Util_QueuePLCode($_prli_iAreaRef; $_prli_Execute)
	End if 
End if 
