//%attributes = {}
// Project Method: Calendar_SelectObject (->variable object)

// Searching for answers? Be sure to check out the "About..." menu located in the
// Apple menu (Macintosh) or the Help menu (Windows). There you can find online
// help for this example database, as well as a listing of numerous 4D resources
// available to you.

// Method created by Dave Batton, DataCraft

// This method selects the specified object on the calendar by placing one of our 
//   selection rectangle objects around it.
// See also Calendar_DeselectObject.


C_POINTER:C301($1; $cal_pObjectPtr; $cal_pRelatedObjectPtr)
C_LONGINT:C283($cal_lNextRect; $cal_lLeft; $cal_lTop; $cal_lRight; $cal_lBottom; $cal_lElement)

$cal_pObjectPtr:=$1

// First, deselect the currently selected object (if any).
cal_OBJECT_DESELECT(cal_pSelectedObjectPtr)

If (Not:C34(Is nil pointer:C315($cal_pObjectPtr)))  // Just to be safe.
	//READ ONLY([Calendar])
	cal_lEventIndex:=cal_AssociatedEventIndexGet($cal_pObjectPtr)
	
	Case of 
		: (do_adEnd_Date{cal_lEventIndex}#!00-00-00!)  //([To_Do]Type_="Banner")
			// Since a banner may span multiple rows, we need to select all other variable 
			//   objects associated with this [Calendar] record.
			$cal_lElement:=0
			$cal_lNextRect:=1
			Repeat 
				$cal_lElement:=Find in array:C230(cal_alEventIndex; cal_lEventIndex; $cal_lElement+1)  //[To_Do]Record_ID
				If ($cal_lElement>0)
					$cal_pRelatedObjectPtr:=Get pointer:C304(cal_atVariableName{$cal_lElement})
					OBJECT GET COORDINATES:C663($cal_pRelatedObjectPtr->; $cal_lLeft; $cal_lTop; $cal_lRight; $cal_lBottom)
					
					Case of 
						: (cal_atVariableName{$cal_lElement}="Cal_lDragBttnL@")
							cal_OBJECT_COLOR_SET(->cal_lDragSelectL; True:C214)
							OBJECT MOVE:C664(cal_lDragSelectL; $cal_lLeft; $cal_lTop; $cal_lRight; $cal_lBottom; *)
							
						: (cal_atVariableName{$cal_lElement}="Cal_lDragBttnR@")
							cal_OBJECT_COLOR_SET(->cal_lDragSelectR; True:C214)
							OBJECT MOVE:C664(cal_lDragSelectR; $cal_lLeft; $cal_lTop; $cal_lRight; $cal_lBottom; *)
							
						Else 
							OBJECT MOVE:C664(*; "SelectRect"+String:C10($cal_lNextRect); $cal_lLeft-2; $cal_lTop-2; $cal_lRight+2; $cal_lBottom+2; *)
							$cal_lNextRect:=$cal_lNextRect+1
					End case 
					
				End if 
			Until ($cal_lElement<1)
			
			
		Else   // It's a "Text" variable object.
			OBJECT GET COORDINATES:C663($cal_pObjectPtr->; $cal_lLeft; $cal_lTop; $cal_lRight; $cal_lBottom)
			OBJECT MOVE:C664(*; "SelectRect1"; $cal_lLeft-2; $cal_lTop-2; $cal_lRight+2; $cal_lBottom+2; *)
	End case 
	
	cal_pSelectedObjectPtr:=$cal_pObjectPtr
End if 
