//%attributes = {}
// Method: wma_add_BARCODE_FILE_READ
// 2010.01.10-16:15:53 / Arto Kokkila
// © Copyright 2010 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
C_LONGINT:C283($1; $st_inv_lGetAll; $2; $st_inv_lClearOldValues; $st_inv_lDocCounter; $st_inv_lRow; $st_inv_lFirstRow)
C_TEXT:C284($st_inv_tParsedDocName; $st_inv_tBarcodeFolder; $st_inv_tNewDocPath; $st_inv_tNewDocNewName; $st_inv_tNewDocNewPath; $st_inv_tProcessedFolder; $st_inv_tFolderSeparator)
C_TEXT:C284($st_inv_tNewDocumentFolder; $st_inv_tDocNameDateTime; $st_inv_tDefaultHeaderToNewFile; $st_inv_tFieldSeparator; $st_inv_tMaterial; $st_inv_tBarcodeDocName; $st_inv_tProductQryFld)
C_TEXT:C284($st_inv_tTextConversionType)
C_LONGINT:C283($st_inv_lOK; $st_inv_lDocIndex; $st_inv_lDocArrSize; $st_inv_lFieldSeparatorAscii; $st_inv_lColumn; $st_inv_lRow; $st_inv_lOK; $st_inv_lProductQryFld)
C_REAL:C285($st_inv_rAmount)
C_BLOB:C604(st_inv_xDoc)
$st_inv_lGetAll:=$1
$st_inv_lClearOldValues:=$2
//PrintFolderPath
ARRAY TEXT:C222(st_inv_atDocRow; 0)

$st_inv_tFolderSeparator:=_doc FolderSeparator

$st_inv_tDocNameDateTime:=_date DateTimeToFilename
$st_inv_tDocNameDateTime:=Replace string:C233($st_inv_tDocNameDateTime; "-"; "")
$st_inv_tDocNameDateTime:=Replace string:C233($st_inv_tDocNameDateTime; "_"; "-")

$st_inv_tBarcodeFolder:=_prf_ XmlValue(<>st_inv_tPreferenceName; "BarcodeFolderPath")
$st_inv_tBarcodeFolder:=_str EndCharRemove($st_inv_tBarcodeFolder; $st_inv_tFolderSeparator; kTrue)  //remove last "\"-chars

$st_inv_tBarcodeDocName:=_prf_ XmlValue(<>st_inv_tPreferenceName; "BarcodeDocumentName")

$st_inv_tProcessedFolder:=_prf_ XmlValue(<>st_inv_tPreferenceName; "ProcessedFolderPath")
$st_inv_tProcessedFolder:=_str EndCharRemove($st_inv_tProcessedFolder; $st_inv_tFolderSeparator; kTrue)  //remove last "\"-chars
$st_inv_tFieldSeparator:=_prf_ XmlValue(<>st_inv_tPreferenceName; "FieldSeparatorAscii")
$st_inv_tFieldSeparator:=Char:C90(Num:C11($st_inv_tFieldSeparator))

$st_inv_tProductQryFld:=_prf_ XmlValue(<>st_inv_tPreferenceName; "ProductField")
If ($st_inv_tProductQryFld#"")
	$st_inv_lProductQryFld:=_var ConstantNameToLong($st_inv_tProductQryFld)
Else 
	$st_inv_lProductQryFld:=pr_kProduct_ID
End if 
Case of 
	: ($st_inv_tBarcodeFolder="")
		_err MESSAGE(_lang Current("Barcode folder path is empty"); Current method name:C684; kFalse)
	: (Test path name:C476($st_inv_tBarcodeFolder)#Is a folder:K24:2)
		_err MESSAGE(_lang Current("Barcode folder does not exist")+": "+$st_inv_tBarcodeFolder; Current method name:C684; kFalse)
	: ($st_inv_tProcessedFolder="")
		_err MESSAGE(_lang Current("Barcode processed folder path is empty"); Current method name:C684; kFalse)
	: (Test path name:C476($st_inv_tProcessedFolder)#Is a folder:K24:2)
		_err MESSAGE(_lang Current("Barcode processed folder does not exist")+": "+$st_inv_tProcessedFolder; Current method name:C684; kFalse)
	Else 
		OK:=1
		ARRAY TEXT:C222($st_inv_atNewDocument; 0)
		If ($st_inv_lGetAll=kFalse)
			$st_inv_hDocRef:=Open document:C264("")
			If (OK=1)
				$st_inv_tNewDocPath:=Document
				CLOSE DOCUMENT:C267($st_inv_hDocRef)
				ARRAY TEXT:C222($st_inv_atNewDocument; 1)
				$st_inv_atNewDocument{1}:=$st_inv_tNewDocPath
			End if 
		Else 
			DOCUMENT LIST:C474($st_inv_tBarcodeFolder; $st_inv_atNewDocument)
		End if 
		
		If (OK=1)
			//clear old values
			If ($st_inv_lClearOldValues=kTrue)
				st_inv_VALUES_CLEAR
			End if 
			
			$st_inv_lDocCounter:=0
			//read documents contents and add rows
			$st_inv_lDocArrSize:=Size of array:C274($st_inv_atNewDocument)
			For ($st_inv_lDocIndex; 1; $st_inv_lDocArrSize)
				$st_inv_lOK:=kTrue
				Case of 
					: ($st_inv_lGetAll=kFalse)
						$st_inv_tNewDocPath:=$st_inv_atNewDocument{$st_inv_lDocIndex}
					: ($st_inv_atNewDocument{$st_inv_lDocIndex}=$st_inv_tBarcodeDocName)
						$st_inv_tNewDocPath:=$st_inv_tBarcodeFolder+$st_inv_tFolderSeparator+$st_inv_atNewDocument{$st_inv_lDocIndex}
					Else 
						$st_inv_lOK:=kFalse
				End case 
				If ($st_inv_lOK=kTrue)
					If (Test path name:C476($st_inv_tNewDocPath)#Is a document:K24:1)
						$st_inv_lOK:=kFalse
						_err MESSAGE(_lang Current("Barcode document does not exist")+": "+$st_inv_tNewDocPath; Current method name:C684; kFalse)
					End if 
				End if 
				
				If ($st_inv_lOK=kTrue)
					$st_inv_tTextConversionType:=_prf_ XmlValue(<>st_inv_tPreferenceName; "TextConversionType")  // "ISO-8859-1"
					_ptr:=_arr PtrToTmpArr(->st_inv_atDocRow)
					_arr apDISK(kLoad; _ptr; $st_inv_tNewDocPath; kFalse; ""; $st_inv_tTextConversionType)
					If (OK=1)
						//add rows
						C_LONGINT:C283($st_inv_lAppendToOldAmount)
						$st_inv_lAppendToOldAmount:=Num:C11(_prf_ XmlValue(<>st_inv_tPreferenceName; "AppendToOldAmount"))
						$st_inv_lArrSize:=Size of array:C274(st_inv_atDocRow)
						For ($st_inv_lIndex; 1; $st_inv_lArrSize)
							st_inv_atDocRow{$st_inv_lIndex}:=_bc_ AsciiChange(kDecode; st_inv_atDocRow{$st_inv_lIndex})
							$st_inv_tMaterial:=_str Parse(st_inv_atDocRow{$st_inv_lIndex}; $st_inv_tFieldSeparator; 1)
							$st_inv_rAmount:=Num:C11(_str Parse(st_inv_atDocRow{$st_inv_lIndex}; $st_inv_tFieldSeparator; 2))
							$st_inv_lRow:=st_inv_ProductAdd(kTrue; $st_inv_tMaterial; $st_inv_rAmount; $st_inv_lAppendToOldAmount)
							If ($st_inv_lIndex=1)
								$st_inv_lFirstRow:=$st_inv_lRow
							End if 
						End for 
						st_inv_DEFAULT_CELL_GOTO(kTrue; $st_inv_lFirstRow)
						
						//move original to processed folder
						If (Test path name:C476($st_inv_tNewDocPath)#Is a document:K24:1)
							_err MESSAGE(_lang Current("Document does not exist")+": "+$st_inv_tDocPath; Current method name:C684; kFalse)
						Else 
							$st_inv_lDocCounter:=$st_inv_lDocCounter+1
							If ($st_inv_lDocCounter>1)
								$st_inv_tNewDocNewName:=$st_inv_tDocNameDateTime+"_"+String:C10($st_inv_lDocCounter)+"_"+_doc NameGet($st_inv_tNewDocPath)
							Else 
								$st_inv_tNewDocNewName:=$st_inv_tDocNameDateTime+"_"+_doc NameGet($st_inv_tNewDocPath)
							End if 
							$st_inv_tNewDocNewPath:=$st_inv_tProcessedFolder+$st_inv_tFolderSeparator+$st_inv_tNewDocNewName
							COPY DOCUMENT:C541($st_inv_tNewDocPath; $st_inv_tNewDocNewPath)
							SET BLOB SIZE:C606(st_inv_xDoc; 0)
							$st_inv_lOK:=_blob Document(kSave; ->st_inv_xDoc; $st_inv_tNewDocPath)
							If ($st_inv_lOK=kFalse)
								_err CRY(_lang Current("Can not empty document. Delete content manually")+": "+$st_inv_tNewDocPath; kTrue)
							End if 
						End if 
						
					End if 
				End if 
			End for 
			ARRAY TEXT:C222(st_inv_atDocRow; 0)
		End if 
End case 
