//%attributes = {}
// Method: xml_easygen_SALES_RECEIVE
//
// sets preference array sizes: sor_apXml_PrfArr
COMPILER_sor_xml_prf_arr(0)
// sor_atXml_Prf_Sales_Order_id
// sor_alXml_Prf_Sales_Order_id
// sor_alXml_Prf_Row_Number
// sor_alXml_Prf_Partial_Deliv_Num
// sor_atXml_Prf_Product_id
//
// find data start & end elements in result file
// xml_atInSegment contains the result file rows
xml_lAllStartRow:=2  // 1. row is header
xml_lAllEndRow:=Find in array:C230(xml_atInSegment; "@<EOF>@"; xml_lAllStartRow)-1
xml_lPickedStartRow:=Find in array:C230(xml_atInSegment; "@<EOT>@"; xml_lAllEndRow)+1
xml_lPickedEndRow:=Find in array:C230(xml_atInSegment; "@<EOF>@"; xml_lPickedStartRow)-1

C_LONGINT:C283(xml_lRowCount)  // the amount of product rows in result file
xml_lRowCount:=xml_lAllEndRow-xml_lAllStartRow+1
//
// read preference-text to arrays
// in preferences is saved the information that is not included in the data sent
// to reader
C_TEXT:C284(xml_tPrfName; xml_tPrfTxt)
xml_tPrfTxt:=""
If (Size of array:C274(xml_atInSegment)>=xml_lAllStartRow)
	xml_tPrfName:=_str Parse(xml_atInSegment{xml_lAllStartRow-1}; "|"; 3)  //prf number is in 1. rows 3. column
	xml_tPrfName:="easygen_send_SALES_"+xml_tPrfName
	xml_tPrfTxt:=_prf_ Txt(""; xml_tPrfName)
	ARRAY POINTER:C280(sor_apXml_PrfArr; 4)
	sor_apXml_PrfArr{1}:=Get pointer:C304("sor_atXml_Prf_Sales_Order_id")
	sor_apXml_PrfArr{2}:=Get pointer:C304("sor_alXml_Prf_Row_Number")
	sor_apXml_PrfArr{3}:=Get pointer:C304("sor_alXml_Prf_Partial_Deliv_Num")
	sor_apXml_PrfArr{4}:=Get pointer:C304("sor_atXml_Prf_Product_id")
	_txt TO_ARR(xml_tPrfTxt; ->sor_apXml_PrfArr; "|"; ksCR; "")
End if 
//
//Error handling
xml_lContinue:=kFalse
Case of 
	: (xml_tPrfTxt="")
		_err MESSAGE(_lang Current("Linked preference text is empty")+": "+xml_tPrfName+ksCR+_lang Current("Operation is cancelled"); Current method name:C684; kFalse)
	: (xml_lAllEndRow<xml_lAllStartRow)  //no rows at all in document 
		_err MESSAGE(_lang Current("No data was found")+ksCR+_lang Current("Operation is cancelled"); Current method name:C684; kFalse)
	: (xml_lAllStartRow<=0)
		_err MESSAGE(_lang Current("Received data syntax is not right")+" / AllStartRow"+ksCR+_lang Current("Operation is cancelled"); Current method name:C684; kFalse)
	: (xml_lAllEndRow<=0)
		_err MESSAGE(_lang Current("Received data syntax is not right")+" / AllEndRow"+ksCR+_lang Current("Operation is cancelled"); Current method name:C684; kFalse)
	: (xml_lPickedEndRow<xml_lPickedStartRow)  //no rows picked
		xml_lContinue:=kTrue
	: (xml_lPickedStartRow<=0)
		_err MESSAGE(_lang Current("Received data syntax is not right")+" / PickedStartRow"+ksCR+_lang Current("Operation is cancelled"); Current method name:C684; kFalse)
	: (xml_lPickedEndRow<=0)
		_err MESSAGE(_lang Current("Received data syntax is not right")+" / PickedEndRow"+ksCR+_lang Current("Operation is cancelled"); Current method name:C684; kFalse)
	Else 
		xml_lContinue:=kTrue
End case 

// read the data into arrays
xml_sResponse:="ERR"
If (xml_lContinue=kTrue)
	//xml_lIndex goes through the product rows in received data file`
	//xml_lIndex2 goes through the new rows in sor_atXml_
	//xml_lIndex3 goes through the preferences rows  
	C_LONGINT:C283(xml_lIndex; xml_lIndex2; xml_lMessageExecuted)
	xml_lOldArrSize:=Size of array:C274(sor_atXml_Sales_Order_id)
	COMPILER_sor_xml_arr(xml_lOldArrSize+xml_lRowCount)
	xml_lIndex2:=xml_lOldArrSize
	xml_lIndex3:=0
	xml_lMessageExecuted:=kFalse
	For (xml_lIndex; xml_lAllStartRow; xml_lAllEndRow)
		xml_lIndex2:=xml_lIndex2+1
		xml_lIndex3:=xml_lIndex3+1
		Case of 
			: (Size of array:C274(xml_atInSegment)<xml_lIndex)
				xml_lIndex:=xml_lAllEndRow
			: (Size of array:C274(sor_atXml_Sales_Order_id)<xml_lIndex2)
				xml_lIndex:=xml_lAllEndRow
			: (Size of array:C274(sor_atXml_Prf_Sales_Order_id)<xml_lIndex3)
				// new products not sent to reader, use sales order id of first product    
				sor_atXml_Sales_Order_id{xml_lIndex2}:=sor_atXml_Prf_Sales_Order_id{1}
				sor_atXml_Product_id{xml_lIndex2}:=_str SpacesTrim(_str Parse(xml_atInSegment{xml_lIndex}; "|"; 1))
				sor_alXml_Row_Number{xml_lIndex2}:=0
				sor_alXml_Partial_Delivery_Num{xml_lIndex2}:=0
				sor_atXml_Collected_Amount{xml_lIndex2}:=_str SpacesTrim(_str Parse(xml_atInSegment{xml_lIndex}; "|"; 4))
				If (sor_atXml_Collected_Amount{xml_lIndex2}#"0")
					sor_alXml_Picked{xml_lIndex2}:=kTrue
				Else 
					sor_alXml_Picked{xml_lIndex2}:=kFalse
				End if 
			Else 
				// read the values saved in preferences        
				sor_atXml_Sales_Order_id{xml_lIndex2}:=sor_atXml_Prf_Sales_Order_id{xml_lIndex3}
				sor_alXml_Row_Number{xml_lIndex2}:=sor_alXml_Prf_Row_Number{xml_lIndex3}
				sor_alXml_Partial_Delivery_Num{xml_lIndex2}:=sor_alXml_Prf_Partial_Deliv_Num{xml_lIndex3}
				// read the picked quantity from received data
				sor_atXml_Collected_Amount{xml_lIndex2}:=_str SpacesTrim(_str Parse(xml_atInSegment{xml_lIndex}; "|"; 4))
				// read the pick status from the received data
				_txt:=_str Parse(xml_atInSegment{xml_lIndex}; "|"; 6)
				sor_alXml_Picked{xml_lIndex2}:=kTrue
				// if nothing has been collected, the collected amount is set to empty
				If (_txt="@-@")
					sor_alXml_Picked{xml_lIndex2}:=kFalse
					sor_atXml_Collected_Amount{xml_lIndex2}:=""
				End if 
		End case 
	End for 
	xml_sResponse:="OK"
End if 
COMPILER_sor_xml_prf_arr(0)
