// form/nc/nc-workpost/workpost.js

export default {
	setup() {
		const rec = state.rec
		return { rec }

		function getEmployee() {
			var data, emp, rec
			rec = state.rec
			data = state.data
			emp = rec.em_employee_id
			if (emp !== '') {
				// state.rec.data.em.data does not exist
				emp = nc.findCaseInsensitiveRecFromArr(data.em.data, 'em_employee_id', rec.em_employee_id)
			}
			if (!emp || emp === '') {
				nc.setRec(state, 'em_employee_id', '')
				return nc.setRec(state, 'em_whole_name', '')
			} else {
				nc.setRec(state, 'em_employee_id', emp.em_employee_id)
				return nc.setRec(state, 'em_whole_name', emp.em_whole_name)
			}
		}

		function setWorkGridCallback(ret) {
			var ref, ref1
			if (ret.grid.work && ret.grid.work.options) {
				// and grid.column
				return (ret.grid.work.options.callback = workGridCallback)
			}
		}

		function queryInit() {
			var callb, parameter
			console.debug('queryInit')
			// nc.callServer($view, "query", {"name": "dialog/workpost/workpost_grid.json", "parameter": {"load_group": rec.load_group}})
			function callb(ret) {
				var emp, ref, ref1, user
				// query()
				setWorkGridCallback(ret)
				return
			}
			parameter = {}
			nc.callServer(
				state,
				'query',
				{
					name: 'dialog/workpost/workpost_init.json',
					parameter: parameter
				},
				callb
			)
		}

		function documentGridCallback(eventType, event, gridVm) {
			console.debug('workGridCallback, eventType', eventType, event, event.data.id)
			documentRowClicked(event.data.id - 1)
		}

		function loadDocument(product_id) {
			var callb
			console.debug('loadDocument', product_id)
			function callb(ret) {
				var grid, ref
				grid = state.grid && state.grid.document
				if (grid && grid.options) {
					return (grid.options.callback = documentGridCallback)
				}
			}
			nc.callServer(
				state,
				'dialog/document',
				{
					parameter: {
						state: state.rec.state,
						product: product_id
					}
				},
				callb
			)
		}

		function workGridCallback(eventType, event, gridVm) {
			/* if eventType is "onCellEditingStarted"
				cellEditingStarted = true
			else if eventType is "onCellEditingStopped"
				cellEditingStarted = false
			else if eventType is "onCellValueChanged"
			*/
			// console.debug("workGridCallback, eventType", eventType, event, event.data.pr_product_id)
			// rowRec = null
			if (eventType === 'onRowClicked') {
				rowRec = event.data
				loadDocument(event.data.pr_product_id)
			}
		}

		function query() {
			var callb, parameter
			console.debug('query')
			// em = state.data.em
			// queryParam = {"production_lot": state.rec.wo_work_order_id, "employee": state.rec.em_employee_id, "days_before": state.rec.days_before}
			// todo: __keep_value
			function callb(ret) {
				setWorkGridCallback(ret)
			}
			// state.data.em = em
			// refresh()
			parameter = {
				load_group: state.rec.load_group
			}
			nc.callServer(
				state,
				'query',
				{
					name: 'dialog/workpost/workpost_grid.json',
					parameter: parameter
				},
				callb
			)
		}

		function refresh() {
			console.debug('refresh, wo: ', state.data.wo)
			// return state.$forceUpdate()
		}
		function initButton() {}
		function buttonDisabled() {
			return false
		}

		function editButton(edit, wpaRec, wosRec) {
			var oldWpaRec
			if (!wpaRec) {
				return
			}
			if (edit === 'edit') {
				wpaRec._web_edit = true
				wosRec._disable = true
				oldWpaRec = nc.clone(wpaRec)
			} else if (edit === 'cancel') {
				nc.copyRecord(oldWpaRec, wpaRec)
				wpaRec._web_edit = false
				wosRec._disable = false
				wpaRec._web_state_executing = null
			} else {
				// else if edit is "ok" # this calls clickButton
				//  wpaRec._web_edit = false
				alert('unknown edit state when calling editButton()')
			}
			refresh()
		}

		function clickButton(state) {
			var callb, parameter, woRec, wosRec, wpaRec
			if (!rowRec) {
				return
			}
			if (!state.rec.em_employee_id || state.rec.em_employee_id === '') {
				return
			}
			wosRec = rowRec
			woRec = {}
			wpaRec = {}
			// get production order (wo)
			function callb(ret) {
				var callb2, parameter
				console.debug('query production order')
				if (ret && ret.data && ret.data[0]) {
					woRec = ret.data[0]
					// get start phase (wpa)
					callb2 = function (ret) {
						console.debug('query open phase')
						if (ret && ret.data && ret.data[0]) {
							wpaRec = ret.data[0]
							state.rec.wpa_rec = wpaRec
						}
						clickButtonSave(state, wpaRec, wosRec, woRec)
					}
					parameter = {
						person: state.rec.em_employee_id,
						production_lot: rowRec.wos_production_lot,
						work_phase_number: rowRec.wos_work_phase
					}
					nc.callServer(
						state,
						'query/data',
						{
							name: 'query/local/product/product_work/workpost/person_open_actual_work_phase.json',
							parameter: parameter
						},
						callb2
					)
				}
			}
			parameter = {
				production_lot: rowRec.wos_production_lot
			}
			return nc.callServer(
				state,
				'query/data',
				{
					name: 'query/local/product/production_order/workpost/work_row_production_order.json',
					parameter: parameter
				},
				callb
			)
		}

		function clickButtonSave(state, wpaRec, wosRec, woRec) {
			var employee, parameter, pauseOther, queryParam, wo, wos, wpa
			if (!wosRec || !woRec) {
				// in "start" wpaRec is null
				return
			}
			// _web_state
			// wpaRec is nil in start
			if (state !== 'save' && wpaRec && (wpaRec._web_edit === true || wpaRec._web_state === state)) {
				return
			}
			employee = state.rec.em_employee_id
			parameter = {}
			pauseOther = false
			if (state === 'setup') {
				queryParam = {
					employee: employee,
					production_lot: wosRec.wos_production_lot,
					work_phase: wosRec.wos_work_phase
				}
				wos = {
					employee: employee,
					wos_production_lot: wosRec.wos_production_lot,
					wos_work_phase: wosRec.wos_work_phase,
					wos_work_load_group_id: wosRec.wos_work_load_group_id,
					wos_record_id: wosRec.wos_record_id,
					wo_record_id: woRec.wo_record_id
				}
				parameter = {
					action: state,
					query_param: queryParam,
					rec: wos
				}
			} else if (state === 'start') {
				pauseOther = state.rec.pause_other
				wos = [
					{
						wos_work_load_group_id: wosRec.wos_work_load_group_id,
						wos_production_lot: wosRec.wos_production_lot,
						wos_work_phase: wosRec.wos_work_phase,
						wos_record_id: wosRec.wos_record_id
					}
				]
				wo = [
					{
						wo_record_id: woRec.wo_record_id,
						wos: wos
					}
				]
				parameter = {
					action: state,
					structure: {
						wo: wo
					},
					parameter: {
						employee: employee,
						production_lot: wosRec.wos_production_lot,
						work_phase: wosRec.wos_work_phase
					},
					array: {}
				}
			} else if (state === 'pause') {
				// wpa = [{"wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
				wpa = [wpaRec]
				wos = [
					{
						wos_work_load_group_id: wosRec.wos_work_load_group_id,
						wos_production_lot: wosRec.wos_production_lot,
						wos_work_phase: wosRec.wos_work_phase,
						wos_record_id: wosRec.wos_record_id,
						wpa: wpa
					}
				]
				wo = [
					{
						wo_record_id: woRec.wo_record_id,
						wos: wos
					}
				]
				parameter = {
					action: state,
					structure: {
						wo: wo
					},
					parameter: {
						employee: state.rec.em_employee_id
					},
					array: {}
				}
				// , employee: wpaRec.start_emloyee_id
			} else if (state === 'continue') {
				pauseOther = state.rec.pause_other
				queryParam = {
					wpa_record_id: wpaRec.wpa_record_id
				}
				// wpa = [{"wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
				wpa = [wpaRec]
				wos = [
					{
						wos_work_load_group_id: wosRec.wos_work_load_group_id,
						wos_production_lot: wosRec.wos_production_lot,
						wos_work_phase: wosRec.wos_work_phase,
						wos_record_id: wosRec.wos_record_id,
						wpa: wpa
					}
				]
				wo = [
					{
						wo_record_id: woRec.wo_record_id,
						wos: wos
					}
				]
				parameter = {
					action: state,
					structure: {
						wo: wo
					},
					parameter: {
						employee: state.rec.em_employee_id
					},
					array: {}
				}
			} else if (state === 'stop') {
				wpaRec = state.rec.wpa_rec
				wpaRec._web_edit = true
				wpaRec._web_state_executing = 'stop'
				// clear field values because of coming from pause state
				wpaRec.wpa_date_ = '0000-00-00'
				wpaRec.wpa_end_time = '00:00:00'
				if (wpaRec.wpa_work_time__amount === 0) {
					wpaRec.wpa_work_time__amount = '' // easier to enter number
				}
				if (wpaRec.wpa_produced_amount === 0) {
					wpaRec.wpa_produced_amount = ''
				}
				editButton('edit', wpaRec, wosRec)
				return
			} else if (state === 'save' && wpaRec._web_state_executing && wpaRec._web_state_executing === 'stop') {
				wpaRec = state.rec.wpa_rec
				if (wpaRec.wpa_work_time__amount === '') {
					wpaRec.wpa_work_time__amount = 0
				}
				if (wpaRec.wpa_produced_amount === '') {
					wpaRec.wpa_produced_amount = 0
				}
				wpaRec._web_edit = false
				wpaRec._web_state_executing = null
				queryParam = {
					wpa_record_id: wpaRec.wpa_record_id
				}
				// wpa = [{"wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
				wpa = [wpaRec]
				wos = [
					{
						wos_work_load_group_id: wosRec.wos_work_load_group_id,
						wos_production_lot: wosRec.wos_production_lot,
						wos_work_phase: wosRec.wos_work_phase,
						wos_record_id: wosRec.wos_record_id,
						wpa: wpa
					}
				]
				wo = [
					{
						wo_record_id: woRec.wo_record_id,
						wos: wos
					}
				]
				parameter = {
					action: 'stop',
					structure: {
						wo: wo
					},
					parameter: {
						employee: state.rec.em_employee_id,
						check_previous_phase_produced_amount: state.rec.check_previous_phase_produced_amount
					},
					array: {}
				}
			} else if (state === 'save') {
				wpaRec._web_edit = false
				// wpa = [{"wpa_produced_amount": wpaRec.wpa_produced_amount, "wpa_work_time__amount": wpaRec.wpa_work_time__amount, "wpa_date_": wpaRec.wpa_date_, "wpa_end_time": wpaRec.wpa_end_time, "wpa_info": wpaRec.wpa_info, "wpa_record_id": wpaRec.wpa_record_id}]
				wpa = [wpaRec]
				wos = [
					{
						wos_record_id: wosRec.wos_record_id,
						wpa: wpa
					}
				]
				wo = [
					{
						wo_record_id: woRec.wo_record_id,
						wos: wos
					}
				]
				parameter = {
					action: state,
					structure: {
						wo: wo
					},
					parameter: {
						employee: state.rec.em_employee_id,
						check_previous_phase_produced_amount: state.rec.check_previous_phase_produced_amount
					},
					array: {}
				}
			}
			wosRec._disable = false
			return save(parameter, pauseOther)
		}

		function save(parameter, pauseOther) {
			var arr, em, endTime
			em = state.data.em
			arr = [] // collect same user in run state
			endTime = ''
			function setPause() {
				function setPauseCallb() {
					if (arr.length > 0) {
						arr.shift() // Remove the first item of an array
						return setPause()
					}
				}
				parameter = {
					x: arr[0]
				}
				return nc.callServer(
					state,
					'run/preference',
					{
						name: 'dialog/workpost_gig/call.json',
						parameter: parameter
					},
					setPauseCallb
				)
			}
			if (arr.length > 0) {
				setPause()
			}
			function callb(ret) {
				state.data.em = em
				if (state.rec.clear_after_save === true) {
					if (ret.data == null || typeof ret.data !== 'string' || ret.data === '') {
						// no error message from lua
						nc.setRec(state, 'em_employee_id', '')
						nc.setRec(state, 'em_whole_name', '')
						nc.setRec(state, 'wo_work_order_id', '')
						query()
					}
				}
				if (parameter.action === 'stop' && ret.status === 'ok' && typeof ret.data !== 'string') {
					// not error message in data
					nc.setSuccess(state.hdr.workpost_gig.save_ok)
					return setTimeout(() => {
						return nc.setSuccess('')
					}, state.rec.save_ok_show_time) // show save_ok for 5 seconds
				}
			}
			return nc.callServer(
				state,
				'run/preference',
				{
					name: 'dialog/workpost_gig/call.json',
					parameter: parameter
				},
				callb
			)
		}
	}
}
