//%attributes = {}
//******************************************************************************
//Method: SDA_CheckResChangeSave
//Written by  Cyril Harnisch on 2/5/99
//
//Purpose: Check if the displayed resource was changed and offer to save
// it if it was.
//
//$1 - pointer -previous resource value holder
//$2 - pointer -resource value display variable
//$3 - time-document reference
//$4 - pointer-resource ID array
//$5 - pointer-constants blob
//$6 - pointer-resource string array
//$7 - string 4-resource type string
//$8 - Boolean-save confirmation presentation flag; optional, default=true
//
//Copyright 1999 Syncor Systems, Inc.
//******************************************************************************
C_POINTER:C301($1; $2; $4; $pPrevResourceValue; $pResourceValue; $pRes_ID_array)
C_TIME:C306($3; $hDocReference)
C_POINTER:C301($5; $6; $pConstantsBlob; $pResourceAry)
_O_C_STRING:C293(4; $7; $s4ResourceType)
C_BOOLEAN:C305($8; $bSaveConfirmationFlag)
C_LONGINT:C283($lResPositionInAry; $lResource_ID)
_O_C_STRING:C293(20; $s20ResourceID)
C_TEXT:C284($tMessage)

$pPrevResourceValue:=$1
$pResourceValue:=$2
$hDocReference:=$3
$pRes_ID_array:=$4
$pConstantsBlob:=$5
$pResourceAry:=$6
$s4ResourceType:=$7

If (Count parameters:C259>7)  //if at least 8 parameters
	$bSaveConfirmationFlag:=$8
	
Else   //less than 8 parameters
	$bSaveConfirmationFlag:=True:C214
End if   //If (Count parameters>7)  `if at least 8 parameters

If ($pPrevResourceValue->=$pResourceValue->)  //if resource was not changed
	
Else   //resource was changed
	C_LONGINT:C283($lResourceIDPosition)
	_O_ARRAY STRING:C218(32; $a324DK_ResourceNames; 0)
	ARRAY LONGINT:C221($alResourceIDs; 0)
	
	$lResPositionInAry:=Find in array:C230($pResourceAry->; $pPrevResourceValue->)  //find the previous value in the array
	
	If ($lResPositionInAry=-1)  //if previous resource not found
		//this should not happen
		
	Else   //previous resource found    
		$lResource_ID:=$pRes_ID_array->{$lResPositionInAry}  //get the currently selected resources ID
		RESOURCE LIST:C500($s4ResourceType; $alResourceIDs; $a324DK_ResourceNames; $hDocReference)  //get list of resource names
		$lResourceIDPosition:=Find in array:C230($alResourceIDs; $lResource_ID)  //search for the resource ID
		
		If ($lResourceIDPosition=-1)  //if resource ID not found
			//#### Try to add new resource
			C_BOOLEAN:C305($bDone)
			C_TEXT:C284($tResourceID_In)
			
			Repeat   //loop until user enters a valid resource ID
				$s20ResourceID:=String:C10($pRes_ID_array->{Int:C8($pResourceAry->)})
				$tMessage:="Enter an ID for your resource between "+String:C10(<>lSDA_StartingResouceID_Range)
				$tMessage:=$tMessage+" & "+String:C10(<>lSDA_EndingResouceID_Range)+"."
				$tResourceID_In:=_info_ Request($tMessage; $s20ResourceID; "Done"; "Cancel")
				
				If (OK=1)  //if the user entered an ID
					$lResource_ID:=Num:C11($tResourceID_In)  //set resource ID
					
					If ($lResource_ID>=<>lSDA_StartingResouceID_Range) & ($lResource_ID<=<>lSDA_EndingResouceID_Range)  //resource ID between 15001 & 20999
						$lResourceIDPosition:=Find in array:C230($alResourceIDs; $lResource_ID)  //search for the resource ID in the structure
						
						If ($lResourceIDPosition=-1)  //if resource ID not found in structure
							//save the resource
							$pRes_ID_array->{$lResPositionInAry}:=$lResource_ID  //save to the resource ID array
							_O_ARRAY STRING:C218(254; <>SDAa254ResourceElements_L; 0)  //save an empty list of resources since they don't exist yet
							SDA_ResEdtrSaveResourceStr($lResource_ID; ->$pConstantsBlob; -><>SDAa254ResourceElements_L; $hDocReference; $s4ResourceType)
							_O_SET RESOURCE NAME:C514($s4ResourceType; $lResource_ID; $pResourceValue->)  //Now set the name to this resource
							$pPrevResourceValue->:=$pResourceValue->  //update the previous version holder   
							$pResourceAry->{$lResPositionInAry}:=$pResourceValue->  //update the array
							$bDone:=True:C214  //exit loop
							
						Else   //resource ID found in structure
							BEEP:C151
							_info_ ALERT("Resource ID, "+String:C10($lResource_ID)+" already exists in the structure. Please try another.")
							$bDone:=False:C215  //remain in loop
						End if   //            If ($lResourceIDPosition=-1)  `if resource ID not found in structure
						
					Else   //resource not between 15001 & 20999
						BEEP:C151
						_info_ ALERT("Resource ID "+String:C10($lResource_ID)+" is not between 15001 & 20999")
						$bDone:=False:C215  //remain in loop
					End if   //          If ($lResource_ID>=<>lSDA_StartingResouceID_Range) & ($lResource_ID<=<
					
				Else   //user cancelled resource ID input      
					$pResourceValue->:=$pPrevResourceValue->  //restore the resource name to the previous value   
					$bDone:=True:C214  //exit loop
				End if   //        If (OK=1)  `if the user entered an ID
				
			Until ($bDone)  //      Repeat   `loop until user enters a valid resource ID
			
		Else   //resource ID found    
			//#### Change resource name code goes here
			_O_SET RESOURCE NAME:C514($s4ResourceType; $lResource_ID; $pResourceValue->)
			
			If (OK=0)  //if the resource could not be renamed
				BEEP:C151
				
			Else   //resource was renamed      
				$pPrevResourceValue->:=$pResourceValue->  //update the previous version holder   
				$pResourceAry->{$lResPositionInAry}:=$pResourceValue->  //update the array
			End if   //      If (OK=0)  `if the resource could not be renamed
			
		End if   //    If ($lResourceIDPosition=-1)  `if resource ID not found
		
	End if   //  If ($lResPositionInAry=-1)  `if previous resource not found
	
End if   //If ($pPrevResourceValue->=$pResourceValue->)  `if resource was not changed
